% SampTimeF.m - this script runs timef on subj ee114, component 1 just
%               to use as a figure in Scott's ICA tutorial


dir = ['/disks/berger/enghoff/raw/'];

subj = 'ee114';
data = [];
for a=1:5      % load LVF data
   for b=1:2
       if (a~=b)
         dir  = ['/disks/berger/enghoff/raw/' subj '/'];
         tmp  = floatread([dir,subj,'_',int2str(a),int2str(b)],[31,inf]);
         data = [data tmp];
      end;  %  endif
   end;   % for_b
end;    % for_a
load(['/disks/berger/enghoff/newsubj/' subj '_grand_wts.mat']);
winv = inv(w*s);
act = icaact(data,w,s);   % compute component activation
for j=1    % compute timef for component 1 only
   figure;
   [Ptmp,Rtmp,mbasetmp,timestmp,freqstmp,Pboottmp,Rboottmp] = timef(act(j,:), ...
       768,[-1000 2000],'ee114: comp1',256,0,128,200,2,50,winv(:,1),'chan.locs',.03);
end;
