Arno,

I don't think your concern is well placed. ICA wouldn't "miss" the 
removed components. If they represented (mainly) single processes
that would otherwise "distract" ICA from decomposing the rest of the
data, then it is better that they be omitted.

The problem is this: say there are 20 brain EEG components of interest,
32 channels, and 20 different types of artifacts throughout the session
(even after "bad" trial rejection). Simple ICA decomposition would find
only 32 components. Because artifacts are so distinct from the rest
of the data, ICA might find all 20 artifacts and only 12 EEG components.

This is the "overcomplete" problem.

For example, say you had 4-channel data:
Say epoch 1 (long epochs) 
had neural components A,B,C and artifacts X and Y.
In fact:

epoch 1     A B C      X Y
epoch 2     A B C      X   Z
epoch 3     A B C    W   Y
...

Then decomposing the epochs together, ICA could find only 4 components,
say A X Y Z -- and these would be mixed with B, C and W. If single-epoch
decompositions could remove, say W, Y and Z, then the clean data would
be:

epoch 1'    A B C      X  
epoch 2'    A B C      X    
epoch 3'    A B C         
...

Then ICA decomposition of the cleaned epochs would separate A B C and X.

OK?

Scott

	Date: Mon, 23 Apr 2001 17:09:20 -0700
	From: Arnaud Delorne <arno@salk.edu>
	To: Scott Makeig <scott@salk.edu>
	Subject: Re: ICA on ICA

	Well if you remove the artifact components, you might end with more relevant
	ICA components related to brain processes.
	What I don't like about reprojecting the data is the lack of uniformity. Some
	epoch will have minus 3 components, some others minus 2... Appling ICA on
	that could result in components that just account for the differences in the
	sets of epochs (of course it might not but how can we know). You don't have
	this problem when you work directly on components.

	Arno

	Scott Makeig wrote:

	> Arno -
	>
	> The question I have is WHY the ICA-on-component-maps should separate
	> processes further? Your comparison should be against the set of components
	> (maps, and then activations) returned by ICA on all the data epochs.
	> ... OR against ICA performed on all the data epochs AFTER removing the
	> epoch subset artifact components...
	>
	> Scott

