#!/usr/local/pkgs/bin/perl 
# -*-perl-*-
# ica-download.pl
#
# logs form data into $ICALOGFILE before allowing user to download ica.tar.Z
#
# Dara Ghahremani <dara@salk.edu> - March 17, 1997

printf "Content-type: text/html\n\n";
printf "<HTML><BODY BGCOLOR=\"#ffffdd\">\n";

$INPUT=<STDIN>;			# Get the input sent by httpd
				# $INPUT is one long string of data in the following
				# form: <varname1>=<value1>&<varname2>=<value2>...
$rawinput=$INPUT;
chop $INPUT, if $INPUT =~ "\n";			# Remove <CR> if exists
&parse_input;			# Parse up the info from the form (i.e. convert escape chars., etc.)
# &print_variables;		# for debuggin stage only


$ICALOGFILE="/disks/services/netscape-server/docs/cnl-pages/lib/ica-download-log";


$VERSIONFILE="/home/scott/matlab/release4/Version";

&addtolog;

&print_header;

 "Location: http://www.cnl.salk.edu/~scott/ica.tar.gz","\n\n";
exit(0);

####################################################
sub parse_input			# parse up what httpd fed us.
{
    @variables=split(/&/,$INPUT);	# split the string into an array of substrings
    foreach $var (@variables) {	# create an associative array of var name, value
   ($name,$value) = split(/=/,$var);
   $value =~ tr/+/ /;		# convert URL encoded value
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;
   $entry{$name}=$value;
   }
    
    foreach $name (sort keys(%entry)) {
	if ($entry{$name} ne "") {
	eval "\$$name=\$entry{$name}";
	push(@formvars, "$name");
        }
    }
}

############################################################
sub print_variables {

    printf "<HTML>";
    $rawinput =~ s/\&/\n\&/gi;

    print "<H2>Raw Input</H1>", $rawinput;
    printf "<BR><HR>\n\n";

    printf "<H2>Parsed Variables</H2>\n\n";
    printf "<H3>(reminder: HTML tags in variables won't appear here)</H3>\n\n";
    foreach $var (@formvars) {
	eval "printf \"<B>$var:</B> \$$var\n\n\"";
	printf "<BR>\n\n";
    }
	printf "<HR>\n\n";
}   


####################################################
sub print_header {

    local(@VERSION);
    &read_file("$VERSIONFILE",*VERSION);
    chop(@VERSION[0]); # remove trailing newline

    print "<HEAD>
<TITLE>Download ICA Scripts</TITLE>
</HEAD>
<CENTER>
<BR>

<HR SIZE=0 WIDTH=0>
<HR SIZE=0 WIDTH=0>
<HR SIZE=0 WIDTH=0>
<HR SIZE=0 WIDTH=0>

<HR WIDTH=50% ALIGN=center>
<P>
Thank you, $username. You may now <BR>
<B>
Download Matlab ICA / EEG Scripts (Version @VERSION)</B>:
<P>
<A HREF=\"http://www.cnl.salk.edu/~scott/ica4.tar.gz\">ica4.tar.gz</A> - gziped tar file
<BR>
<A HREF=\"http://www.cnl.salk.edu/~scott/ica4.zip\">ica4.zip</A>
<BR><BR>
<A HREF=\"http://www.cnl.salk.edu/~scott/ica5.tar.gz\">ica5.tar.gz</A> - gziped tar f
ile
<BR>
<A HREF=\"http://www.cnl.salk.edu/~scott/ica5.zip\">ica5.zip</A>
<BR><BR>
<HR WIDTH=50% ALIGN=center>
<BR>
</CENTER>
<CENTER>";

}


####################################################
sub addtolog {
# write data to log file

    local(@logline);
    local($date=`date`); 
    chop($date);
    push(@logline,"$username $email $date $ENV{'REMOTE_HOST'}\n");
    $comments=~s/\r/\t/g;
    $comments=~s/\n/\n\t/g;
    push(@logline,"\t$comments\n\n"), if $comments;
#    print @logline;
    &append_file($ICALOGFILE,@logline);
}



############################################################
sub append_file {
    #write @filearray to file;

    local($FILENAME) = shift(@_);
    local(@filearray) = @_;     # * means that $_[2] array is aliased to "arrayname"
    # untaint $FILENAME
    $FILENAME =~ /^\s*([\/?-?\+?\w-?\.?\+?]*)\s*$/; 
    $untaintedfilename = $1;

    open(FILE,">>$untaintedfilename") || die "$0: couldn't open $untaintedfilename - $!";
    flock(FILE,2);              # lock the file
        print FILE @filearray;
    flock(FILE,8);              # unlock the file     
    close(FILE);
}


############################################################
sub read_file {
    local($FILENAME) = $_[0];
    local(*filearray) = $_[1];  # * means that $_[2] array is aliased to "arrayname"
    open(FILE,"$FILENAME") || die "$0: couldn't open $FILENAME - $!";
    flock(FILE,2);              # lock the file
        @filearray=<FILE>;
    flock(FILE,8);              # unlock the file
    close(FILE);
}

