% check_image_ui() - perform the hi/lo byte swap if necessary with
%                    a graphic user interface
%
% Usage:
%    >> check_image_ui;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2003-03-03
%
% See also: check_image_ui()
%
% Notes: - This function comes with a graphic user interface to
%          display the average functional images (up to 15 slices)
%        - Once the images need to be changed from little-endian to
%          big-endian format (FMRLAB takes only big-endian format
%          images), click on "swap hi/lo byte" button to perform
%          the byte swapping. 
%        - Press "close" button to end the process

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: check_image_ui.m,v $
% Revision 1.1  2003/03/04 00:50:02  duann
% Initial revision
%

function check_image_ui(action)
  
  if nargin < 1,
    action = 'init';
  end
  
  global FMRI
  global h0
  global ax
  global mean_data
  global ii

  if length(FMRI) == 0,
    fmrlab_messagedlg('Extract Brain Voxels',...
	       'Error:',...
	       ['No current data set exists. Please load a ''.fmr''' ...
		' data files first']);
    return;
  end

  RGB_mainwin = [1 .984 .895];
  RGB_background = [0.860 0.824 0.618];
  RGB_button = [0.860 0.824 0.618];
  RGB_text = [0.333 0.283 0.003];
  
  if isunix,
      text_size = 14;
  else
      text_size = 12;
  end
  
  axw = 168;
  axg = 10;
  axgh = 25;

  if strcmp(action,'init'),
      a = get_status(FMRI.processed);
      switch(a)
      case 'raw'
          temp = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y* ...
		    FMRI.dime_z,FMRI.timepoint+FMRI.dummy);
      case 'rm_sliced'
          temp = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y* ...
		    FMRI.dime_z,FMRI.timepoint+FMRI.dummy);
      otherwise
          temp = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y* ...
		    FMRI.dime_z,FMRI.timepoint);
      end

      mean_data = mean(temp');
    mean_data = reshape(mean_data,FMRI.dime_x,FMRI.dime_y, ...
			FMRI.dime_z);
    h0 = figure(...
	'Color',RGB_background, ...
	'PaperUnits','points', ...
	'units','pixels',...
	'Position',[50 100 900 625], ...
	'Tag','check_image_win', ...
	'name', 'Check Image Data',...
	'numbertitle','off',...
	'ToolBar','none',...
	'menubar','none');
    
    ax = []; % keep the handles of image axes for further use
    for i=1:3,
      for j=1:5,
	pos(1) = j*axg + (j-1)*axw;
	pos(2) = 625 - i*(axgh+axw);
	pos(3) = axw;
	pos(4) = axw;
	h1 = axes(...
	    'Parent',h0, ...
	    'units','pixels',...
	    'position',pos,...
	    'Color',RGB_mainwin, ...
	    'box','on',...
	    'Tag','image_ax',...
	    'xtick',[],...
	    'xticklabel',[],...
	    'ytick',[],...
	    'yticklabel',[]);
	ax = [ax h1];
      end
    end

    bt1 = uicontrol(...
	'Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',[620 axg 160 25], ...
	'String','Swap Hi/Lo Byte', ...
	'callback','check_image_ui(''swap'')',...
	'Tag','Pushbutton1');
    bt2 = uicontrol(...
	'Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',[790 axg 100 25], ...
	'String','Close', ...
	'callback','check_image_ui(''close'')',...
	'Tag','Pushbutton2');

    switch(a)
    case 'raw'
        set(bt1,'enable','on');
    otherwise
        set(bt1,'enable','off');
    end


    % display images
    if FMRI.dime_z < 16
      for i=1:FMRI.dime_z,
	axes(ax(i));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	colormap(gray);
      end
    else
      for i=1:15,
	axes(ax(i));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	colormap(gray);
      end
    end
  
  elseif strcmp(action,'close'),
      a = get_status(FMRI.processed);
      switch(a)
      case 'raw'
          FMRI.data = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y*...
			FMRI.dime_z*(FMRI.timepoint+FMRI.dummy),1);
      otherwise
      end
    
    close(h0);
    show_parameters;
 
  elseif strcmp(action,'swap'),
    temp = FMRI.data;
    temp = mod(temp,256)*256 + floor(temp/256);
    FMRI.data = temp;
    temp = reshape(temp,FMRI.dime_x*FMRI.dime_y* ...
			FMRI.dime_z,FMRI.timepoint+FMRI.dummy);
    mean_data = mean(temp');
    mean_data = reshape(mean_data,FMRI.dime_x,FMRI.dime_y, ...
			FMRI.dime_z);
    % display images
    if FMRI.dime_z < 16
      for i=1:FMRI.dime_z,
	axes(ax(i));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	colormap(gray);
      end
    else
      for i=1:15,
	axes(ax(i));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	colormap(gray);
      end
    end

   end