

function er_bold(act)
  
  global FMRI
  
  if nargin < 1,
    act = 'init';
  end
  
  RGB_mainwin = [1 .984 .895];
  RGB_background = [0.860 0.824 0.618];
  RGB_button = [0.860 0.824 0.618]; 
  RGB_text = [0.333 0.283 0.003];

  switch(act)
   case 'init'
    f_erbold = figure(...
	'name','Event-Related BOLD Image',...
	'menubar','none',...
	'numbertitle','off',...
	'color',RGB_mainwin,...
	'position',[100 100 640 480],...
	'backingstore','off',...
	'deletefcn','er_bold(''close'');');
    
    % create axes for time course
    tc_axis = axes('Parent',f_erbold, ...
		   'units','pixels',...
		   'position',[50 40 580 120],...
		   'Color',RGB_mainwin,...
		   'box','on',...
		   'Tag','tc_axis',...
		   'fontsize',12,...
		   'fontweight','bold');
    
    % upsample the component time course and plot it in tc_axis
    % get component number from window 
    a = findobj('name',['Display Component ROA on Functional Variance' ...
			' Images']);
    if isempty(a),
      a = findobj('name',['Display Component ROA on Structural' ...
			  ' Images']);
    end
    if isempty(a),
      fmrlab_messagedlg('er_bold()',...
			'Error:',...
			'Cannot find Component Browser');
      return;
    end
    b = findobj(a,'tag','ed_component');
    comp = str2num(get(b,'string'));
    % compute back-projected component time course according to
    % comp
    % 1. find ed_thre
    b = findobj(a,'tag','ed_thre');
    z_thre = str2num(get(b,'string'));
    % 2. find index of ROA+
    W = FMRI.icaweight * FMRI.icasphere;
    invW = pinv(W);
    u = W * FMRI.data;
    temp_data = u(comp, :);
    mean_temp_data = mean(temp_data);
    std_temp_data = std(temp_data);
    temp_data = (temp_data-mean_temp_data)/std_temp_data; %convert to z score
    uidx = find(temp_data >= z_thre);
    % 3. calculate back-projected component time course according
    % to uidx
    ddd = zeros(size(invW,1),size(u,2));
    ddd = invW(:,comp) * u(comp,:);
    ddd = ddd(:,uidx)';
    bpctc = mean(ddd);
    ddd = FMRI.data(:,uidx);
    ddd = mean(ddd');
    bpctc = 100 * (bpctc-mean(bpctc)) / mean(ddd);
    roatc = 100 * (ddd-mean(ddd))/mean(ddd);
    % 4. add the dummy scans back to the beginning of
    % back-projected component time course
    for i=1:FMRI.dummy,
      bpctc = [bpctc(1) bpctc];
    end
    % 5. upsample back-projected component time course
    bpctc = resample(bpctc,FMRI.tr*1000,1);
    % 6. plot bpctc
    axes(tc_axis);
    tt = [1:length(bpctc)];
    li = plot(tt,bpctc);
    set(li,'linewidth',2);
    set(gca,'color',RGB_mainwin);
    set(get(gca,'xlabel'),'string','(ms)',...
		      'fontsize',12,...
		      'fontweight','bold',...
		      'color',RGB_text);
    set(get(gca,'ylabel'),'string','\Delta BOLD (%)',...
		      'fontsize',12,...
		      'fontweight','bold',...
		      'color',RGB_text);
    
    % create axes of BOLD image
    bi_axis = axes('Parent',f_erbold, ...
		   'units','pixels',...
		   'position',[230 265 400 210],...
		   'Color',RGB_mainwin,...
		   'box','on',...
		   'Tag','bi_axis',...
		   'fontsize',12,...
		   'fontweight','bold',...
		   'xtick',[],...
		   'xticklabel',[],...
		   'ytick',[],...
		   'yticklabel',[]);
    erb_axis = axes('Parent',f_erbold, ...
		   'units','pixels',...
		   'position',[230 185 400 80],...
		   'Color',RGB_mainwin,...
		   'box','on',...
		   'Tag','erb_axis',...
		   'fontsize',12,...
		   'fontweight','bold',...
		   'xtick',[],...
		   'xticklabel',[],...
		   'ytick',[],...
		   'yticklabel',[]);
     
    % create graphic user interface
    % 1. Create title showing the component number
    h1 = uicontrol(...
	'style','text',...
	'string',['Component ' num2str(comp)],...
	'position', [10 440 180 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'tag','title',...
	'horizontalalign','center',...
	'fontsize',16,...
	'fontweight','bold');
    % 2. button to load up event timing
    h1 = uicontrol(...
	'style','pushbutton',...
	'string','Load Event',...
	'position', [10 415 180 30],...
	'backgroundcolor',RGB_button,...
	'foregroundcolor',RGB_text,...
	'tag','bt_loadevent',...
	'horizontalalign','center',...
	'fontsize',14,...
	'callback','er_bold(''loadevent'');');
    % 3. edit for start timing
    h1 = uicontrol(...
	'style','text',...
	'string','Pre',...
	'position', [10 380 40 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','left',...
	'fontsize',14);
    h1 = uicontrol(...
	'style','edit',...
	'string','-1000',...
	'position', [50 380 100 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','center',...
	'fontsize',14,...
	'tag','ed_pre');
    h1 = uicontrol(...
	'style','text',...
	'string','ms',...
	'position', [150 380 40 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','right',...
	'fontsize',14);
    % 4. edit for end timing
    h1 = uicontrol(...
	'style','text',...
	'string','Post',...
	'position', [10 345 40 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','left',...
	'fontsize',14);
    h1 = uicontrol(...
	'style','edit',...
	'string','9000',...
	'position', [50 345 100 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','center',...
	'fontsize',14,...
	'tag','ed_post');
    h1 = uicontrol(...
	'style','text',...
	'string','ms',...
	'position', [150 345 40 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','right',...
	'fontsize',14);
    % 5. edit of moving average
    h1 = uicontrol(...
	'style','text',...
	'string','MA',...
	'position', [10 310 40 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','left',...
	'fontsize',14);
    h1 = uicontrol(...
	'style','edit',...
	'string','1',...
	'position', [50 310 100 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','center',...
	'fontsize',14,...
	'tag','ed_ma');
    h1 = uicontrol(...
	'style','text',...
	'string','trial',...
	'position', [150 310 40 30],...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'horizontalalign','right',...
	'fontsize',14);
    % 6. plot BOLD image
    h1 = uicontrol(...
	'style','pushbutton',...
	'string','Plot BOLD image',...
	'position', [10 275 180 30],...
	'backgroundcolor',RGB_button,...
	'foregroundcolor',RGB_text,...
	'tag','bt_plot',...
	'horizontalalign','center',...
	'fontsize',14,...
	'enable','off',...
	'callback','er_bold(''plot'');');
    % 7. buttons for cleaning BOLD image plot and event plot
    h1 = uicontrol(...
	'style','pushbutton',...
	'string','Clear BOLD image',...
	'position', [10 240 180 30],...
	'backgroundcolor',RGB_button,...
	'foregroundcolor',RGB_text,...
	'tag','bt_clear1',...
	'horizontalalign','center',...
	'fontsize',14,...
	'callback','er_bold(''clear1'');');
    h1 = uicontrol(...
	'style','pushbutton',...
	'string','Clear Event mark',...
	'position', [10 205 180 30],...
	'backgroundcolor',RGB_button,...
	'foregroundcolor',RGB_text,...
	'tag','bt_clear2',...
	'horizontalalign','center',...
	'fontsize',14,...
	'callback','er_bold(''clear2'');');
    % 8. button to close window
    % before 'close'. put an option to determine if want to remove
    % baseline
    h1 = uicontrol(...
	'style','checkbox',...
	'string','rMean',...
	'position', [10 170 90 30],...
	'backgroundcolor',RGB_button,...
	'foregroundcolor',RGB_text,...
	'tag','ck_rmean',...
	'horizontalalign','center',...
	'fontsize',14);
    h1 = uicontrol(...
	'style','pushbutton',...
	'string','Close',...
	'position', [105 170 85 30],...
	'backgroundcolor',RGB_button,...
	'foregroundcolor',RGB_text,...
	'tag','bt_close',...
	'horizontalalign','center',...
	'fontsize',14,...
	'callback','er_bold(''close'');');
    
    % save some important parameter for redraw in userdata of main
    % window
    userdata.tc_axis = tc_axis;
    userdata.bi_axis = bi_axis;
    userdata.erb_axis = erb_axis;
    userdata.bpctc = bpctc;
    set(f_erbold,'userdata',userdata);
    
   case 'close'
    delete(gcf);
    
   case 'loadevent'
    a = findobj('name','Event-Related BOLD Image');
    if isempty(a)
      fmrlab_messagedlg('er_bold()',...
			'Error:',...
			['Window of Event-Related BOLD Image not' ...
			 ' found']);
      return;
    end
    userdata = get(a,'userdata');
    bpctc = userdata.bpctc;
    [filename,pathname] = uigetfile;
    if isempty(filename),
      return;
    end
    fname = [pathname filename];
    event_timing = load(fname);
    ev = zeros(1,length(bpctc));
    ev(event_timing.latency) = 1;
    pos = axis(userdata.tc_axis);
    ev = ev*(pos(4)-pos(3))+pos(3);
    axes(userdata.tc_axis);
    hold on
    plot([1:length(bpctc)],ev,'r');
    userdata.event_timing = event_timing;
    set(a,'userdata',userdata);
    a = findobj('tag','bt_plot');
    set(a,'enable','on');
    
   case 'clear1'
    a = findobj('name','Event-Related BOLD Image');
    if isempty(a)
      fmrlab_messagedlg('er_bold()',...
			'Error:',...
			['Window of Event-Related BOLD Image not' ...
			 ' found']);
      return;
    end
    userdata = get(a,'userdata');
    axes(userdata.bi_axis);
    cla;
    set(gca,'color',RGB_mainwin,...
	    'xtick',[],...
	    'xticklabel',[],...
	    'ytick',[],...
	    'yticklabel',[]);
    pos1 = get(gca,'position');
    axes(userdata.erb_axis);
    cla;
    set(gca,'color',RGB_mainwin,...
	    'xtick',[],...
	    'xticklabel',[],...
	    'ytick',[],...
	    'yticklabel',[]);
    pos2 = get(gca,'position');
    pos2(3) = pos1(3);
    set(gca,'position',pos2);
    a = findobj('tag','Colorbar');
    delete(a);
    
   case 'clear2'
    a = findobj('name','Event-Related BOLD Image');
    if isempty(a)
      fmrlab_messagedlg('er_bold()',...
			'Error:',...
			['Window of Event-Related BOLD Image not' ...
			 ' found']);
      return;
    end
    userdata = get(a,'userdata');
    axes(userdata.tc_axis);
    cla;
    li = plot([1:length(userdata.bpctc)],userdata.bpctc);
    set(li,'linewidth',2);
    set(get(gca,'xlabel'),'string','(ms)',...
		      'fontsize',12,...
		      'fontweight','bold',...
		      'color',RGB_text);
    set(get(gca','ylabel'),'string','\Delta BOLD (%)',...
		      'fontsize',12,...
		      'fontweight','bold',...
		      'color',RGB_text);
    a = findobj('tag','bt_plot');
    set(a,'enable','off');
    
   case 'plot'
    a = findobj('name','Event-Related BOLD Image');
    if isempty(a)
      fmrlab_messagedlg('er_bold()',...
			'Error:',...
			['Window of Event-Related BOLD Image not' ...
			 ' found']);
      return;
    end
    userdata = get(a,'userdata');
    a = findobj('tag','ed_pre');
    pre = str2num(get(a,'string'));
    a = findobj('tag','ed_post');
    post = str2num(get(a,'string'));
    a = findobj('tag','ed_ma');
    ma = str2num(get(a,'string'));
    a = [];
    b = userdata.event_timing.latency;
    for i=1:length(b),
      if b(i)+pre > 0 & b(i)+post < length(userdata.bpctc),
	temp = userdata.bpctc(b(i)+pre:b(i)+post);
	ck1 = findobj('tag','ck_rmean');
	ck1 = get(ck1,'value');
	if ck1 == 1,
	  if pre < 0,
	    m = mean(temp(1:-pre)');
	    temp = temp-m;
	  end
	end
	a = [a; temp];
      end
    end
    axes(userdata.bi_axis)
    imagesc(a);
    set(gca,'xtick',[],'tag','erbimage','ydir','normal');
    li = line([0-pre 0-pre],[1 size(a,1)]);
    set(li,'linestyle','--','color','k');
    h = colorbar;
    pos = get(h,'position');
    pos(3) = pos(3)*0.75;
    set(h,'position',pos);
    ax = findobj('tag','erbimage');
    pos = get(ax,'position');
    axes(userdata.erb_axis);
    pos2 = get(gca,'position');
    pos2(3) = pos(3);
    set(gca,'position',pos2);
    plot(pre:post,mean(a),'linewidth',2);
    ax = axis(gca);
    ax(1) = pre;
    ax(2) = post;
    axis(ax);
    set(gca,'color',RGB_mainwin);
    li = line([0 0],[ax(3) ax(4)]);
    set(li,'linestyle','--','color','k');
  end
  