% execute_ica() - graphic user interface (GUI) to laonch ICA
%                 process for fMRI data, all parameters can be
%                 assigned in a popup window.
% 
% Usage:
%   >> execute_ica;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CN:/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: set_fmri_global_ui()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software

% $Log: execute_ica.m,v $
% Revision 1.2  2003/03/03 21:23:17  duann
% correct typo
%
% Revision 1.1  2003/02/06 18:57:44  duann
% Initial revision
%

function execute_ica

global FMRI

  if length(FMRI) == 0,
    fmrlab_messagedlg('Execute ICA',...
	       'Error:',...
	       ['No current data set exists. Please load a ''.fmr''' ...
		' data files first']);
    return;
  end
  
%FMRI.maxsteps = 512;
prompt = {'Number of principal dimensions to retain (0 ->all):',...
	  'Annealing Angle (in degrees):',...
	  'Use Extended ICA (yes/no):',...
	  'Maximum training steps:'};
if ~isempty(FMRI.pcano),
  str_pcano = num2str(FMRI.pcano);
else
  str_pcano = int2str(round(sqrt(size(FMRI.data,2)))); 
end

if ~isempty(FMRI.annealdeg),
  str_annealdeg = num2str(FMRI.annealdeg);
else
  str_annealdeg = '60';
end

if ~isempty(FMRI.extended),
  if FMRI.extended == 0,
    str_extended = 'no';
  else
    str_extended = 'yes';
  end
else
  str_extended = 'no';
end

if ~isempty(FMRI.maxsteps),
  str_maxsteps = num2str(FMRI.maxsteps);
else
  str_maxsteps = '512';
end

defs = {str_pcano, str_annealdeg, str_extended, str_maxsteps};
a = fmrlab_inputdlg(prompt,'ICA Decomposition Parameters',1,defs);
if isempty(a),
  %errordlg('Cancelled by user ...!');
  return;
else
  FMRI.pcano = str2num(char(a(1)));
  FMRI.annealdeg = str2num(char(a(2)));
  if strcmp(char(a(3)),'yes')
    FMRI.extended = 1;
  else
    FMRI.extended = 0;
  end
  FMRI.maxsteps = str2num(char(a(4)));
end
show_parameters;

if isunix,
    arg = ['[w,sph]=binica(FMRI.data' ',' '''maxsteps''' ',' int2str(FMRI.maxsteps)];
else
    arg = ['[w,sph]=runica(FMRI.data' ',' '''maxsteps''' ',' int2str(FMRI.maxsteps)];
end
if FMRI.pcano ~= 0,
  arg = [arg ',' '''' 'pca' '''' ',' int2str(FMRI.pcano)];
end

if FMRI.annealdeg ~= 60,
  arg = [arg ',' '''' 'annealdeg' '''' ',' int2str(FMRI.annealdeg)];
end

if FMRI.extended == 1,
  arg = [arg ',' '''' 'extended' '''' ',1'];
end

%if FMRI.maxsteps ~= 512,
%  arg = [arg ',' '''maxsteps''' ',' int2str(FMRI.maxsteps)];
%end

arg = [arg ');']
eval(arg);

FMRI.icasphere = sph;
FMRI.icaweight = w;
FMRI.processed = [FMRI.processed ':ica_trained'];

show_parameters;
