% extract_brain_ui2() - extract brain area (or remove the off-brain
%                      voxels) from the sequential fMRI data. 
%
% Usage:
%    >> extract_brain_ui2;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2001-10
%
% See also: extract_brain_by_edit()
%
% Notes: - This function provides users to remove the off-brain
%          voxels interactively by either:
%        - setting threshold using horizontal scroll bar, or
%        - setting threshold by keying in number in edit box
%        - before doing thresholding, press refresh first to load
%          up the images
%        - press OK to accept the thresold value
%        - press CANCEL to omit the thresholding

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: extract_brain_ui2.m,v $
% Revision 1.3  2003/03/01 19:47:56  duann
% correct typo
%
% Revision 1.2  2003/03/01 19:38:51  duann
% reshape FMRI.data back if 'cancel' pressed
%
% Revision 1.1  2003/02/06 18:58:48  duann
% Initial revision
%

function extract_brain_ui2(action)
  
  if nargin < 1,
    action = 'init';
  end
  
  global FMRI
  global h0
  global ax
  global mean_data
  global ii
  
  if length(FMRI) == 0,
    fmrlab_messagedlg('Extract Brain Voxels',...
	       'Error:',...
	       ['No current data set exists. Please load a ''.fmr''' ...
		' data files first']);
    return;
  end

  if size(FMRI.data,1)==FMRI.timepoint,
    fmrlab_messagedlg('Extract Brain Voxels',...
		   'Error:',...
		   ['Off-brain voxels have been removed. Please move' ...
		    ' on to run ICA directly.']);
    return;
  end
 
  RGB_mainwin = [1 .984 .895];
  RGB_background = [0.860 0.824 0.618];
  RGB_button = [0.860 0.824 0.618];
  RGB_text = [0.333 0.283 0.003];
  
  axw = 168;
  axg = 10;
  axgh = 25;
  
  if strcmp(action,'init'),
      
      if isunix,
          text_size = 14;
      else
          text_size = 12;
      end
      
    FMRI.data = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y* ...
			FMRI.dime_z,FMRI.timepoint);
    mean_data = mean(FMRI.data');
    mean_data = reshape(mean_data,FMRI.dime_x,FMRI.dime_y, ...
			FMRI.dime_z);
    h0 = figure(...
	'Color',RGB_background, ...
	'PaperPosition',[10 35 576 650], ...
	'PaperUnits','points', ...
	'units','pixels',...
	'Position',[50 100 900 625], ...
	'Tag','extract_brain_win', ...
	'name', 'Remove Off-Brain Voxels',...
	'numbertitle','off',...
	'ToolBar','none',...
	'menubar','none');
  
    ax = []; % keep the handles of image axes for further use
    for i=1:3,
      for j=1:5,
	pos(1) = j*axg + (j-1)*axw;
	pos(2) = 625 - i*(axgh+axw);
	pos(3) = axw;
	pos(4) = axw;
	h1 = axes(...
	    'Parent',h0, ...
	    'units','pixels',...
	    'position',pos,...
	    'Color',RGB_mainwin, ...
	    'box','on',...
	    'Tag','image_ax',...
	    'xtick',[],...
	    'xticklabel',[],...
	    'ytick',[],...
	    'yticklabel',[]);
	ax = [ax h1];
      end
    end
    
    uicontrol(...
	'parent',h0,...
	'units','pixels',...
	'style','text',...
	'position',[10 630-axgh 300 15],...
	'fontsize',text_size,...
	'horizontalalign','left',...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'string','Original data');
    uicontrol(...
	'parent',h0,...
	'units','pixels',...
	'style','text',...
	'position',[10 630-(axgh*2+axw) 300 15],...
	'fontsize',text_size,...
	'horizontalalign','left',...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'string','Thresholded data');
    uicontrol(...
	'parent',h0,...
	'units','pixels',...
	'style','text',...
	'position',[10 630-(axgh*3+axw*2) 300 15],...
	'fontsize',text_size,...
	'horizontalalign','left',...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'string','Thresholded data in log scale');
    
    % create slider bar
    uicontrol(...
	'parent',h0,...
	'units','pixels',...
	'style','text',...
	'position',[5 5 20 15],...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'string','0');
    ti = sprintf('%5.0f',max(FMRI.data(:)));
    uicontrol(...
	'parent',h0,...
	'units','pixels',...
	'style','text',...
	'position',[480 5 40 15],...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'string',ti);
    uicontrol(...
	'parent',h0,...
	'units','pixels',...
	'style','text',...
	'position',[30 5 450 15],...
	'fontsize',text_size-2,...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'string','Move slider or enter off-brain threshold');
    if FMRI.dime_z > 5,
      ti = sprintf('Showing middle\nfive slices');
      uicontrol(...
	'parent',h0,...
	'units','pixels',...
	'style','text',...
	'position',[605 5 120 35],...
	'fontsize',text_size-2,...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'string',ti);  
    end    
    sb = uicontrol(...
	'Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'Callback','extract_brain_ui2(''refresh_slider'')', ...
	'ListboxTop',0, ...
	'Position',[10 20 500 15], ...
	'SliderStep',[0.001 0.01], ...
	'Style','slider', ...
	'Tag','slider1',...
	'min',0,...
	'max',round(max(FMRI.data(:))));
    ed1 = uicontrol(...
	'Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_mainwin, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',[520 axg 80 25], ...
	'Style','edit', ...
	'string','0',...
	'callback','extract_brain_ui2(''refresh_edit'')',...
	'Tag','edit1');
    bt1 = uicontrol(...
	'Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',[720 axg 80 25], ...
	'String','OK', ...
	'callback','extract_brain_ui2(''OK'')',...
	'Tag','Pushbutton1');
    bt2 = uicontrol(...
	'Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',[810 axg 80 25], ...
	'String','Cancel', ...
	'callback','extract_brain_ui2(''cancel'')',...
	'Tag','Pushbutton2');
    % display images
    
    if FMRI.dime_z < 6
      for i=1:FMRI.dime_z,
	axes(ax(i));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	axes(ax(i+5));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	axes(ax(i+10));
	temp = mean_data(:,:,i);
	temp = log(1+temp);
	imagesc(temp');
	axis image
	axis off
	colormap(gray);
      end
    else
      start_slice = round(FMRI.dime_z/2)-2;
      for i=start_slice+1:start_slice+5,
	axes(ax(i-start_slice));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	axes(ax(i-start_slice+5));
	imagesc(mean_data(:,:,i)');
	axis image
	axis off
	axes(ax(i-start_slice+10));
	temp = mean_data(:,:,i);
	temp = log(1+temp);
	imagesc(temp');
	axis image
	axis off
	colormap(gray);
      end
    end
    
  elseif strcmp(action,'cancel'),
    FMRI.data = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y*...
			FMRI.dime_z*FMRI.timepoint,1);
    close(h0);
    
  elseif strcmp(action,'refresh_edit'),
    % get threshold from edit box
    a = findobj('tag','edit1');
    b =str2num(get(a,'string'));
    % set the value of slider bar
    a = findobj('tag','slider1');
    set(a,'value',b);
    temp = mean_data;
    ii = find(temp < b);
    temp(ii) = 0;
    if FMRI.dime_z < 6
      for i=1:FMRI.dime_z,
	axes(ax(i+5));
	imagesc(temp(:,:,i)');
	axis image
	axis off
	axes(ax(i+10));
	imagesc(log(1+temp(:,:,i))');
	axis image
	axis off
	colormap(gray);
      end
    else
      start_slice = round(FMRI.dime_z/2)-2;
      for i=start_slice+1:start_slice+5,
	axes(ax(i-start_slice+5));
	imagesc(temp(:,:,i)');
	axis image
	axis off
	axes(ax(i-start_slice+10));
	imagesc(log(1+temp(:,:,i))');
	axis image
	axis off
	colormap(gray);
      end
    end
        
  elseif strcmp(action,'refresh_slider'),
    % get threshold from slider
    a = findobj('tag','slider1');
    b = round(get(a,'value'));
    % set the value of slider bar
    a = findobj('tag','edit1');
    set(a,'string',num2str(b));
    temp = mean_data;
    ii = find(temp < b);
    temp(ii) = 0;
    if FMRI.dime_z < 6
      for i=1:FMRI.dime_z,
	axes(ax(i+5));
	imagesc(temp(:,:,i)');
	axis image
	axis off
	axes(ax(i+10));
	imagesc(log(1+temp(:,:,i))');
	axis image
	axis off
	colormap(gray);
      end
    else
      start_slice = round(FMRI.dime_z/2)-2;
      for i=start_slice+1:start_slice+5,
	axes(ax(i-start_slice+5));
	imagesc(temp(:,:,i)');
	axis image
	axis off
	axes(ax(i-start_slice+10));
	imagesc(log(1+temp(:,:,i))');
	axis image
	axis off
	colormap(gray);
      end
    end
    
  elseif strcmp(action, 'OK'),
    FMRI.data = FMRI.data';
    FMRI.data(:,ii) = [];
    FMRI.idx = 1:FMRI.dime_x*FMRI.dime_y*FMRI.dime_z;
    FMRI.idx(ii) = [];
    FMRI.processed = [FMRI.processed ':brain_extracted'];
    close(h0);
    show_parameters
    
  end
  
