% fmrlab_messagedlg() - message and question dialog for FMRLAB.
%
% Usage:
%    button_pressed = fmrlab_messagedlg2(tit, typ, msg, btn);
%
% Inputs:
%    tit - title of the dialog
%    typ - type of the message or question dialog (can be: 'Error',
%          'Warning', etc)
%    msg - string of message
%    btn - cell array of button(s) displayed in the dialog (e.g.,
%          {'OK','Cancel'}, {'Yes', 'No', 'Cancel'}, etc)
%
% Outputs:
%    button_pressed - button number pressed by user (the same order
%                     beginning with 1 defined by argument 'btn'
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: errordlg()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: fmrlab_messagedlg.m,v $
% Revision 1.1  2003/02/06 19:00:21  duann
% Initial revision
%


function button_pressed = fmrlab_messagedlg(tit, typ, msg, btn)

if nargin<4,
    btn = {'OK'};
end

RGB_mainwin = [1 .984 .895];
RGB_background = [0.860 0.824 0.618];
RGB_button = [0.860 0.824 0.618];
RGB_text = [0.333 0.283 0.003];

if isunix,
    text_size = 14;
else
    text_size = 12;
end
  
pos = get(0,'defaultfigureposition');
fig_wid = 300;
fig_hei = 150;
pos(3:4) = [fig_wid fig_hei];
fig = dialog(...
    'visible','off',...
    'name',tit,...
    'pointer','arrow',...
    'units','points',...
    'position',pos,...
    'keypressfcn','fmrlab_messagedlg #figkeypressfcn',...
    'userdata',0,...
    'integerhandle','off',...
    'windowstyle','normal',...
    'handlevisibility','callback',...
    'tag',tit,...
    'color',RGB_background);

no_buttons = length(btn);
btn_wid = 80;
btn_hei = 25;
btn_gap = (300-20-btn_wid*no_buttons) / (no_buttons+1);
cb_str = 'uiresume(gcf)';

for i=1:no_buttons
    bt(i) = uicontrol(...
        fig,...
        'style','pushbutton',...
        'units','points',...
        'position',[10+i*btn_gap+(i-1)*btn_wid 10 btn_wid btn_hei],...
        'callback',cb_str,...
        'string',char(btn(i)),...
        'horizontalalign','center',...
        'fontunits','points',...
        'fontsize',text_size,...
	'fontweight','BOLD',...
        'backgroundcolor',RGB_button,...
        'foregroundcolor',RGB_text,...
        'tag',char(btn(i)));
end

tx1 = uicontrol(...
    fig,...
    'style','text',...
    'units','points',...
    'position',[10 15+btn_hei 280 85],...
    'string',msg,...
    'tag','msg',...
    'horizontalalignment','center',...
    'fontsize',text_size,...
    'fontweight','bold',...
    'backgroundcolor',RGB_background,...
    'foregroundcolor',RGB_text);

tx2 = uicontrol(...
    fig,...
    'style','text',...
    'units','points',...
    'position',[10 100+btn_hei 280 20],...
    'string',typ,...
    'tag','typ',...
    'horizontalalignment','left',...
    'fontweight','bold',...
    'fontsize',text_size,...
    'backgroundcolor',RGB_background,...
    'foregroundcolor',RGB_text);

screenunits = get(0,'units');
set(0,'units','points');
screensize = get(0,'screensize');
set(0,'units',screenunits);

figpos(1) = (screensize(3)-fig_wid)/2;
figpos(2) = (screensize(4)-fig_hei)/2;
figpos(3:4) = [fig_wid fig_hei];
set(fig,'position',figpos);

set(fig,'windowstyle','modal','visible','on');
drawnow;

uiwait(fig);

temphide = get(0,'showhiddenhandles');
set(0,'showhiddenhandles','on');

if any(get(0,'children')==fig),
    if get(fig,'userdata'),
        button_pressed = default;
    else
        button_pressed = get(get(fig,'currentobject'),'string');
    end
    delete (fig);
else
    button_pressed = default;
end

set(0,'showhiddenhandles',temphide);

    