% fmrlab_questdlg() - question dialog with yes/no buttons
%
% Usage:
%    >> button_pressed = fmrlab_questdlg(action, title, disp_str);
%
% Inputs:
%    action   - put 'init' to initialize the dialog
%    title    - title of the dialog
%    disp_str - question string
%
% Outputs:
%    buttin_pressed - button pressed by user, either 'yes' or
%                     'no'
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: questdlg(), fmrlab_messagedlg()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: fmrlab_questdlg.m,v $
% Revision 1.1  2003/02/06 19:00:42  duann
% Initial revision
%



function button_pressed = fmrlab_questdlg(action, title, disp_str)

  global button_pressed
  
  if nargin < 1,
    action = 'init';
  end
  
  RGB_mainwin = [1 .984 .895];
  RGB_background = [0.860 0.824 0.618];
  RGB_button = [0.860 0.824 0.618];
  RGB_text = [0.333 0.283 0.003];
  
  if isunix,
      text_size = 14;
  else
      text_size = 12;
  end
  
  if strcmp(action, 'init'),
    pos = get(0,'screensize');
    
    % create window
    h0 = figure(...
	'numbertitle','off',...
	'name',title,...
	'menubar','none',...
	'color',RGB_mainwin,...
	'position',[(pos(3)-300)/2 (pos(4)-150)/2 300 150]);
    pos = get(h0,'position');
    h1 = uicontrol(...
	'parent',h0,...
	'style','text',...
	'backgroundcolor',RGB_mainwin,...
	'foregroundcolor',RGB_text,...
	'fontsize',text_size-2,...
	'position',[20 pos(4)-110 pos(3)-40 100],...
	'string',disp_str);
    h1 = uicontrol(...
	'parent',h0,...
	'style','pushbutton',...
	'position',[20 10 100 30],...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'fontsize',text_size,...
	'string','OK',...
	'callback','fmrlab_questdlg(''OK'')');
    h1 = uicontrol(...
	'parent',h0,...
	'style','pushbutton',...
	'position',[180 10 100 30],...
	'backgroundcolor',RGB_background,...
	'foregroundcolor',RGB_text,...
	'fontsize',text_size,...
	'string','Cancel',...
	'callback','fmrlab_questdlg(''Cancel'')');
    button_pressed = '';
    
  elseif strcmp(action,'OK'),
    close;
    button_pressed = 'OK';
    
  elseif strcmp(action,'Cancel'),
    close;
    button_pressed = 'Cancel';
  end
  