% fmrlab_scale() - rescale the input vector to range (newMin,
%                  newMax)
%
% Usage:
%    >> newv = fmrlab_scale(v, newMin, newMax, oldMin, oldMax);
%
% Inputs:
%    v      - input vector
%    newMin - value of new minimum
%    newMax - value of new maximum
%    oldMin - value of old minimum (default = min(v))
%    oldMax - value of old maximum (default = max(v))
%
% Outputs:
%    newv - new vector
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: max(), min()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: fmrlab_scale.m,v $
% Revision 1.1  2003/02/06 19:00:58  duann
% Initial revision
%

function newv = fmrlab_scale(v, newMin, newMax, oldMin, oldMax)
  
  if nargin < 4,
    oldMin = min(v(:));
  end
  if nargin < 5,
    oldMax = max(v(:));
  end
  
  sz = size(v);
  newv = newMin + (v-oldMin)*(newMax-newMin)/(oldMax-oldMin);
  newv = reshape(newv,sz);
  
  