% label_brain_area() - display normalized ICA component maps (or ROAs) in 2D
%                      slice-by-slice display on top of normalized structural
%                      images.
%
% Usage:
%   >> label_brain_area;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: fmrlab_normalize(), spm_affsub3(), show_3d(), show_mip()
%
% Notes: - Must have structural images to perform the spatial
%          normalization process.
%        - show_2d() only works on normalized ICA component maps
%          (or ROAs) and structural images.
%        - The accuracy of the spatial normalization process
%          heavily depends on the image quality and slice
%          number. Thus, the validity of the results of show_2d()
%          cannot be guaranteed. 
        
% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: label_brain_area.m,v $
% Revision 1.1  2003/02/06 19:01:22  duann
% Initial revision
%

function label_brain_area()

     % Jeng-Ren Duann, CNL/Salk Inst., 2002-11-16

  RGB_mainwin = [1 .984 .895];

disp('Select the maps you want to label...');
map_name = spm_get([], 'nroa_*.img', 'Get Normalized ROA file');
if isequal(map_name,0),
  fmrlab_messagedlg('Label Brain Areas',...
		'Warning:',...
		['To export normalized ROA image files, see: Visualize' ...
		 ' > Export Selected Comps']);
  return;
end

for i=1:size(map_name,1);
  fp = fopen(map_name(i,:),'rb','ieee-le');
  if fp == -1,
    %errordlg('Cannot open map file...!');
    fmrlab_messagedlg('Label Brain areas',...
		  'Error:',...
		  'Cannot open map file');
    return;
  end
  data = fread(fp,'float');  
  fclose(fp);
  
  ii = find(data >= 2.0);
  x = 2*(mod(ii,79)-40);
  y = 2*(mod(floor(ii/79),95)-57);
  z = 2*(mod(floor(ii/79/95),68)-26);

  for j=length(map_name(i,:)):-1:1,
    if map_name(i,j) == '.',
      break;
    end
  end
%  load MNISpace
  target_name = [map_name(i,1:j-1) '_pos.txt']
  fp = fopen(target_name,'w');
%  fprintf(fp,'No.  X   Y   Z   z-value  Name\n');
  for j=1:length(x),
    fprintf(fp,'%d %d %d\n', x(j),y(j),z(j));
%    nx = (x(j)+80)/2;
%    ny = (y(j)+114)/2;
%    nz = (z(j)+52)/2;
%    ind = nz*79*95 + ny*79 + nx + 1;
%    fprintf(fp,'%d %-4d %-4d %-4d %-10.2f %s,%s,%s,%s,%s\n',...
%        ind,x(j),y(j),z(j),data(ii(j)),...
%	    DB.cNames{1}{DB.data(ind, 1)},...
%	    DB.cNames{2}{DB.data(ind, 2)},...
%	    DB.cNames{3}{DB.data(ind, 3)},...
%	    DB.cNames{4}{DB.data(ind, 4)},...
%        DB.cNames{5}{DB.data(ind, 5)});
  end
  fclose(fp);
%  clear DB

  ii = find(data <= -2.0);
  x = 2*(mod(ii,79)-40);
  y = 2*(mod(floor(ii/79),95)-57);
  z = 2*(mod(floor(ii/79/95),68)-26);
  for j=length(map_name(i,:)):-1:1,
    if map_name(i,j) == '.',
      break;
    end
  end
  target_name = [map_name(i,1:j-1) '_neg.txt']
  fp = fopen(target_name,'w');
  for j=1:length(x),
    fprintf(fp,'%d %d %d\n', x(j),y(j),z(j));
  end
  fclose(fp);

end

