% load_dataset() - load FMRI data structure saved previously in the
%                  disk up to the current working environment.
% 
% Usage: 
%   >> load_dataset;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: clear_fmri_global(), set_fmri_global_ui()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: load_dataset.m,v $
% Revision 1.1  2003/02/06 19:01:30  duann
% Initial revision
%

function load_dataset

global FMRI
global hwnd

% before load new dataset, close all the displayed window to begin
% with
clear_workspace(3);

if ~isempty(FMRI),
  FMRI = [];
  h = findobj(hwnd,'tag','text1');
  set(h,'string','');
end

[filename, pathname] = uigetfile('*','Load Dataset from File');
if filename == 0,
  %errordlg('Cancelled by user!');
  return
end



temp = ['cd ' pathname];
eval(temp);

temp = ['load -mat ' filename];
eval(temp);

if isempty(FMRI),
  %errordlg('The file specified is not FMRI data set, please try
  %again!');
  jr_messagedlg2('Load Dataset',...
		'Error:',...
		['The file specified is not FMRI data set, please' ...
		 ' try again']);
  return
else
  show_parameters
end

