% make_blob() - This function is used to read the ICA result
%               (better after spatial normalization to the 
%               standard space), and make a structure consists of:
%               dat = struct('XYZ',xyz,...
%                            't'  ,t,...
%                            'mat',mat,...
%                            'dim',dim);
%
% Usage: 
%   >> dat = make_blobs(filename, z_threshold);
%
% Inputs:
%   filename    - name of the file contains the blob information (in z
%                 value), no extension needed (e.g., nroa_0001)
%   z_threshold - threshold in z value to screen the blobs (default
%                 = 1.5)
%
% Outputs: 
%   dat - data structure used in fmrlab_render() routine
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: fmrlab_render(), spm_render(), fmrlab_normalize()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: make_blobs.m,v $
% Revision 1.1  2003/02/06 19:01:37  duann
% Initial revision
%

function dat = make_blobs(filename, z_threshold)

% Jeng-Ren Duann, CNL/Salk Inst, 2002-03-26
  
  if nargin < 2,
    z_threshold = 2.0;
  end
  if nargin < 1,
    %errordlg('Please assign the file name you want to
    %convert...');
    fmrlab_messagedlg('Export Results',...
		  'Error:',...
		  'Please assign the file name you want to convert');
    return;
  end
  
  hdr_name = [filename '.hdr'];
  img_name = [filename '.img'];
  hdr = read_analyze_hdr(hdr_name);
  
  fp = fopen(img_name,'rb','ieee-be');
  if fp == -1,
    %errordlg(['Cannot open image file ''' img_name '''...!']);
    str = ['Cannot open image file ''' img_name ''''];
    fmrlab_messagedlg('Export Results',...
		  'Error:',...
		  str);
    return;
  end
  if hdr.datatype == 4,
    data = fread(fp,'int16');
  elseif hdr.datatype == 8,
    data = fread(fp,'int32');
  else    
    data = fread(fp,'float');
  end
  fclose(fp);
  
  if max(data > 65536),
    fp = fopen(img_name,'rb','ieee-le');
    if hdr.datatype == 4,
      data = fread(fp,'int16');
    elseif hdr.datatype == 8,
      data = fread(fp,'int32');
    else    
      data = fread(fp,'float');
    end
    fclose(fp);
  end
  
  pos_ii = find(data > z_threshold)';
  pos = data(pos_ii)';
  x = mod(pos_ii,hdr.dim(2));
  y = mod(floor(pos_ii/hdr.dim(2)),hdr.dim(3));
  z = mod(floor(pos_ii/hdr.dim(2)/hdr.dim(3)),hdr.dim(4));
  ii = find(x==0);
  x(ii) = 1;
  ii = find(x>hdr.dim(2));
  x(ii) = hdr.dim(2);
  ii = find(y==0);
  y(ii) = 1;
  ii = find(y>hdr.dim(3));
  y(ii) = hdr.dim(3);
  ii = find(z==0);
  z(ii) = 1;
  ii = find(z>hdr.dim(4));
  z(ii) = hdr.dim(4);
  pos_xyz = [x; y; z];
  mat = [hdr.pixdim(2) 0 0 -hdr.origin(1)*hdr.pixdim(2);
	 0 hdr.pixdim(3) 0 -hdr.origin(2)*hdr.pixdim(3);
	 0 0 hdr.pixdim(4) -hdr.origin(3)*hdr.pixdim(4);
	 0 0 0 1];
  if length(pos) ~= 0,
    dat(1) = struct('XYZ',pos_xyz,...
		    't', pos,...
		    'mat',mat,...
		    'dim',hdr.dim(2:4));
  end
  
  nag_ii = find(data < -z_threshold)';
  if length(nag_ii) ~= 0,
    nag = abs(data(nag_ii)');
    x = mod(nag_ii,hdr.dim(2));
    y = mod(floor(nag_ii/hdr.dim(2)),hdr.dim(3));
    z = mod(floor(nag_ii/hdr.dim(2)/hdr.dim(3)),hdr.dim(4));
    ii = find(x==0);  
    x(ii) = 1;
    ii = find(x>hdr.dim(2));
    x(ii) = hdr.dim(2);
    ii = find(y==0);
    y(ii) = 1;
    ii = find(y>hdr.dim(3));
    y(ii) = hdr.dim(3);
    ii = find(z==0);
    z(ii) = 1;
    ii = find(z>hdr.dim(4));
    z(ii) = hdr.dim(4);
    nag_xyz = [x; y; z];
    if isempty(dat),
      dat(1) = struct('XYZ',nag_xyz,...
		  't', nag,...
		  'mat',mat,...
		  'dim',hdr.dim(2:4));
    else
      
      dat(2) = struct('XYZ',nag_xyz,...
	    	      't', nag,...
		      'mat',mat,...
		      'dim',hdr.dim(2:4));
    end
  end
  
  
 