% read_structure() - read structural images according to the format
%                    indicated by 'data_format' argument
%
% Usage: 
%   >> struc = read_structure(fname, data_format);
%
% Inputs:
%   fname       - file name of structural images
%   data_format - data format for reading structural images (e.g.,
%                 'int16', 'uint16', 'float', etc)
% 
% Outputs:
%   struc - variable of structural images
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: set_struc_info()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: read_structure.m,v $
% Revision 1.1  2003/02/06 19:13:55  duann
% Initial revision
%

function strc = read_structure(fname,data_format)

fp = fopen(fname,'rb','ieee-be');
strc = fread(fp,data_format);
fclose(fp);
