% reselect_fmri() - keep the same parameters and select another
%                   fMRI data set for analysis. This function is
%                   very used for when user wants to analyze
%                   several sessions of fMRI experiments with them
%                   same experimental design and image acquisition
%                   parameters.
%
% Usage:
%   >> reselect_fmri;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: Set_fmri_global_ui(), modify_param()
%
% Notes: - A popup window will help user to select new fMRI data
%          set for analysis.
%        - Newly specified fMRI data will be assigned to FMRI.data
%          field. 
%        - All the status and result fields (e.g., FMRI.icaweight,
%          FMRI.icasphere, etc, will be cleared.
  
% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: reselect_fmri.m,v $
% Revision 1.1  2003/02/06 19:14:13  duann
% Initial revision
%

function reselect_fmri

global FMRI
global hwnd

% popup the file select dialog
[filename, pathname] = uigetfile('*', 'Select Image File');
if filename == 0,
  %errordlg('Cancelled by user, exit program!');
  return
end

fname = [pathname '/' filename];
fp = fopen(fname,'rb','ieee-be');
if fp == -1,
  %errordlg('File does not exist ...','Error');
  fmrlab_messagedlg('Import New Image Data',...
		'Error:',...
		'File not found');
  return;
end
set(hwnd,'pointer','watch');
data = fread(fp,'uint16');
fclose(fp);
set(hwnd,'pointer','arrow');

FMRI.data = data;
FMRI.icaweight = [];
FMRI.icasphere = [];
FMRI.icacomp = [];
FMRI.processed = 'raw';
FMRI.idx = [];
FMRI.filename = filename;

show_parameters
