% save_dataset() - save FMRI data structure into a Matlab .mat file
%
% Usage:
%   >> save_dataset;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 
%
% See also: set_fmri_global_ui(), set_struc_info()
%
% Notes: - Although the FMRI data structure is saved in Matlab .mat
%          file, the extension of the data file should be changed
%          to .fmr for FMRLAB system to recognize.
%        - .fmr extension name should be added manually by the user
%          while specifying the filename for save_dataset().
 
% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: save_dataset.m,v $
% Revision 1.1  2003/02/06 19:15:48  duann
% Initial revision
%

function save_dataset

global FMRI

if isempty(FMRI),
  %errordlg('No fMRI dataset in workspace!');
  fmrlab_messagedlg('Save Dataset',...
		'Error:',...
		'No fMRI data set in workspace');
  return;
end

[filename,pathname] = uiputfile('*','Save Dataset');
if filename == 0,
  %errordlg('Cancelled by user, quit saving dataset!');
  return;
end

if isempty(FMRI),
  %errordlg('No dataset in workspace, please create FMRI data set
  %first!');
  fmrlab_messagedlg('Save Dataset',...
		'Error:',...
		'No fMRI data set in workspace');
  return;
end

temp = ['save ' filename ' FMRI'];
eval(temp);

%fp = fopen(filename, 'wb','ieee-be');
%if fp == -1,
%  errordlg('Cannot open file, quit saving dataset!');
%  return;
%end

%if isempty(FMRI.data),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = length(FMRI.data);
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.data,'uint16');
%end

%if isempty(FMRI.filename),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = length(FMRI.filename);
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.filename,'char');
%end

%if isempty(FMRI.pathname),
%  temp = 0;
%  fwrite(fp,temo,'uint32');
%else
%  temp = length(FMRI.pathname);
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.pathname,'char');
%end

%if isempty(FMRI.dime_x),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.dime_x,'uint16');
%end

%if isempty(FMRI.dime_y),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.dime_y,'uint16');
%end

%if isempty(FMRI.dime_z),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.dime_z,'uint16');
%end

%if isempty(FMRI.fov_x),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.fov_x,'float');
%end

%if isempty(FMRI.dime_z),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.fov_y,'float');
%end

%if isempty(FMRI.slicetk),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.slicetk,'float');
%end

%if isempty(FMRI.dummy),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.dummy,'uint16');
%end

%if isempty(FMRI.timepoint),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.timepoint,'uint16');
%end

%if isempty(FMRI.tr),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.tr,'float');
%end

%if isempty(FMRI.processed),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = length(FMRI.processed);
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.processed,'char');
%end

%if isempty(FMRI.pcano),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.pcano,'uint16');
%end

%if isempty(FMRI.annealdeg),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.annealdeg,'uint16');
%end

%if isempty(FMRI.extended),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = 1;
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.extended,'uint16');
%end

%if isempty(FMRI.icasphere),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = length(FMRI.icasphere);
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.icasphere,'float');
%end

%if isempty(FMRI.icaweight),
%  temp = 0;
%  fwrite(fp,temp,'uint32');
%else
%  temp = length(FMRI.icaweight);
%  fwrite(fp,temp,'uint32');
%  fwrite(fp,FMRI.icaweight,'float');
%end

%fclose(fp);