% set_fmri_global_ui() - the data structure of FMRI as a global variable
%                        for fMRI data analysis with graphic user
%                        interface
%
% Usage:
%   >> set_fmri_global_ui()
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: set_struc_info(), modify_param(), save_dataset()
%
% Notes:
%    - parameters in FMRI structure:
%    - GENERAL USE VARIABLES:
% 	FMRI.data	image body
%	FMRI.filename	image file name
%	FMRI.pathname	image path
%	FMRI.dime_x	image width (in pixels)
%	FMRI.dime_y	image height (in pixels)
%	FMRI.dime_z	image depth (in pixels)
%	FMRI.fov_x	field of view in x direction (in mm)
%	FMRI.fov_y	field of view in y direction (in mm)
%	FMRI.slicetk	slice thickness (in mm)
%	FMRI.dummy	dummy scans conducted in fMRI experiment
%	FMRI.timepoint	real time point acquired in fMRI experiment
%			total time point = dummy + timepoint
%	FMRI.tr		inter-scan interval = TR (in sec)
%       FMRI.idx        index of brain voxels
% 	FMRI.processed	recording the stage of image processing
%			it can be: 'raw', 'slice_timed', 'deskulled', 'icaed'
%       FMRI.struc_name filename of structural images
%       FMRI.struc_path path name of structural images
%       FMRI.struc_image_width image width of structural images
%       FMRI.struc_image_height image height of structural images
%       FMRI.struc_image_depth  slice_number of structural images
%       FMRI.struc_fov_x field of view in x direction of structural images
%       FMRI.struc_fov_y field of view in y direction of structural images  
%       FMRI.struc_slicetk slice thickness of structural images
%       FMRI.struc_resort resort image or not (1: resort; 0: no resort)
%       FMRI.struc_flip  flip image or not (1: flip; 0: no flip)
%
%    - ICA VARIABLE:
%	FMRI.pcano	dimensionality to be reduced to (default = 0, all)
%	FMRI.annealdeg	annleaing angle used in ICA training (default = 60 degree)
%	FMRI.extended	if extended ICA used (default = 0, no)
%	FMRI.icasphere	sphere matrix of ica result
%	FMRI.icaweight	weight matric of ica result
%       FMRI.icacomp    mark for meaningful components
%       FMRI.rejcomp    mark for rejected components
%       FMRI.ica_zthre  z threshold for ROA selection (default=1.5)
%       FMRI.ica_zbound upper bound for ROA display (default = 12.0);
%
%    - BOLD Image parameters:
%       FMRI.soa        soa of each trial
%       FMRI.trial_length length of each trial

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: set_fmri_global_ui.m,v $
% Revision 1.3  2003/03/04 01:19:08  duann
% move check_image_ui() to main menu
%
% Revision 1.2  2003/03/04 00:50:11  duann
% add "check_image_ui" function to check if the imported images are in big-endian, otherwise swap them
%
% Revision 1.1  2003/02/06 19:16:20  duann
% Initial revision
%

function set_fmri_global_ui

% Jeng-Ren Duann, CNL, Salk Inst., 2001-07-31

global FMRI
global hwnd

[filename, pathname] = uigetfile('*', 'Select Image File');
if filename == 0,
  %errordlg('Cancelled by user, exit program!');
  return
end

fname = [pathname '/' filename];
fp = fopen(fname,'rb','ieee-be');
if fp == -1,
  %errordlg('File does not exist ...','Error');
  fmrlab_messagedlg('Set fMRI Parameters',...
		'Error:',...
		'File not found');
  return;
end
data = fread(fp,64*64,'uint16');
if max(data) > 32768,
  fclose(fp);
  fp = fopen(fname, 'rb','ieee-le');
else
  fseek(fp,0,-1);
end

set(hwnd,'pointer','watch');
data = fread(fp,'uint16');
fclose(fp);
set(hwnd,'pointer','arrow');

prompt = {'Image Width (in pixels):',...
	  'Image Height (in pixels):', ...
          'Image Depth (number of slices):', ...
	  'Field of View (FOV) on X-axis (|left-right|, mm):', ...
          'Field of View (FOV) on Y-axis (|ant-post|, mm):', ...
	  'Slice thickness including gap (mm):', ...
          'Number of scans (total):', ...
	  'Number of initial (dummy) scans to remove:', ...
	  'TR (inter-scan interval, in sec):'};
a = fmrlab_inputdlg(prompt, 'Functional Image Parameters');
if isempty(a),
  %errordlg('Cancelled by user, exit program ...');
  return
end
dime_x = str2num(char(a(1)));
dime_y = str2num(char(a(2)));
dime_z = str2num(char(a(3)));
fov_x = str2num(char(a(4)));
fov_y = str2num(char(a(5)));
slicetk = str2num(char(a(6)));
dummy = str2num(char(a(8)));
timepoint = str2num(char(a(7))) - dummy;
tr = str2num(char(a(9)));
idx = [];

pcano = 0;
annealdeg = 60;
extended = 0;

%prompt = {'PCA Number:', 'Annealing Angle:', 'Extended:'};
%defs = {'0', '60','0'};
%a = inputdlg(prompt,'Set ICA defaults',1,defs);
%if isempty(a),
%  errordlg('Cancelled by user, exit program ...');
%  return;
%end
%pcano = str2num(char(a(1)));
%annealdeg = str2num(char(a(2)));
%extended = str2num(char(a(3)));

FMRI = struct('data',      data, ...
              'filename',  filename, ...
              'pathname',  pathname, ...
	      'dime_x',    dime_x, ...
	      'dime_y',    dime_y, ...
              'dime_z',    dime_z, ...
              'fov_x',     fov_x, ...
              'fov_y',     fov_y, ...
              'slicetk',   slicetk, ...
              'dummy',     dummy, ...
              'timepoint', timepoint, ...
              'tr',        tr, ...
              'idx',       idx, ...
              'processed', 'raw', ...
	      'pcano',     pcano, ...
	      'annealdeg', annealdeg, ...
              'extended',  extended, ...
              'icasphere', [], ...
              'icaweight', [],...
              'icacomp',[],...
	      'rejcomp',[],...
              'soa',[],...
	      'ica_zthre',1.5,...
	      'ica_zbound',12.0,...
              'trial_length',0,...
	      'maxsteps',512,...
	      'alignslice',[]);

set_struc_info;
show_parameters
