% set_struc_info() - setup the information of structural images, which will be 
%                    incoperated in the fmr data structure
% 
% Usage:
%   >> set_struf_info(action);
%
% Inputs:
%   action - 'initialize': initialize the graphic user interface
%            for set_struc_info()
%          - 'cancel': cancel the editing and discard the changes
%          - 'ok': accept the changes and save then into FMRI data
%            structure
%          - 'fileselection': popup the file selection window to
%            select file.
%
% Outputs:
%
% Author: Jeng-Ren Duann, CN:/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: set_fmri_global_ui(), modify_param(), reselect_fmri()
%
% Notes: - Structural images might be necessary if the user wants
%          to normalize the functional images as well as resulting ICA
%          component maps (or ROAs) to the standard (Talaraich) brain
%          template for better visualization.
%        - Structural images are also needed by the function
%          map_on_struc().

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: set_struc_info.m,v $
% Revision 1.2  2003/03/04 01:09:27  duann
% check window style to modal
%
% Revision 1.1  2003/02/06 19:16:30  duann
% Initial revision
%

function set_struc_info(action)
  
% This function is called within 'set_fmri_global_ui' function
% to setup the information of structural images, which will be 
% incoperated in the fmr data structure.
%
% Jeng-Ren Duann, CNL/Salk Inst., 2002-05-21
  
  global FMRI

  RGB_mainwin = [1 .984 .895];
  RGB_background = [0.860 0.824 0.618];
  RGB_button = [0.860 0.824 0.618];
  RGB_text = [0.333 0.283 0.003];

  lw = 120;
  lh = 25;
  lg = 10;
  POS = get(0,'screensize');
  
  if nargin < 1,
    action = 'initialize';
  end
  
  if strcmp(action,'initialize'),
    lw = 120;
    lh = 25;
    lg = 10;
    POS = get(0,'screensize');
    
    if isunix,
        text_size = 14;
    else
        text_size = 12;
    end
    
    fg1 = findobj('name','Structural image information');
    if isempty(fg1)
      fg1 = figure(...
	  'name','Structural image information',...
	  'numbertitle','off',...
	  'doublebuffer','on',...
	  'color',RGB_mainwin,...
	  'backingstore','off',...
	  'toolbar','none',...
	  'menubar','none',...
	  'windowstyle','modal');
      pos = get(fg1,'position');
      pos(1) = (POS(3)-pos(3))/2;
      pos(3) = lw*4+25+lg*5;
      pos(4) = lh*6+lg*7;
      pos(2) = POS(4)-pos(4)-100;
      set(fg1,'position',pos);
      
      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01 pos(4)*0.85 lw lh],...
	  'string','Filename: ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01 pos(4)*0.85-(lh+lg) lw lh],...
	  'string','Filepath: ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01 pos(4)*0.85-(lh+lg)*2 lw lh],...
	  'string','Image width (voxel): ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01 pos(4)*0.85-(lh+lg)*3 lw lh],...
	  'string','Image height (voxel): ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01 pos(4)*0.85-(lh+lg)*4 lw lh],...
	  'string','Image depth: ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
      
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+(lw+lg) pos(4)*0.85 lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_filename',...
	  'horizontalalignment','right');
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+(lw+lg) pos(4)*0.85-(lh+lg) lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_pathname',...
	  'horizontalalignment','right');
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+(lw+lg) pos(4)*0.85-(lh+lg)*2 lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_image_width',...
	  'string','',...
	  'horizontalalignment','right');
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+(lw+lg) pos(4)*0.85-(lh+lg)*3 lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_image_height',...
	  'string','',...
	  'horizontalalignment','right');
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+(lw+lg) pos(4)*0.85-(lh+lg)*4 lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_image_depth',...
	  'string','',...
	  'horizontalalignment','right');
      
      uicontrol(...
	  'style','pushbutton',...
	  'position',[pos(1)*0.01+(lw+lg)*2-5 pos(4)*0.85 30 lh],...
	  'string','...',...
	  'backgroundcolor',RGB_button,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','btn_select_file',...
	  'callback','set_struc_info(''fileselection'')');

      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01+30+(lw+lg)*2 pos(4)*0.85 lw lh],...
	  'string','FOV X (mm): ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01+30+(lw+lg)*2 pos(4)*0.85-(lh+lg) lw lh],...
	  'string','FOV Y (mm): ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
      uicontrol(...
	  'style','text',...
	  'position',[pos(3)*0.01+30+(lw+lg)*2 pos(4)*0.85-(lh+lg)*2 lw lh],...
	  'string','Slice thickness (mm): ',...
	  'backgroundcolor',RGB_mainwin,...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size);
%      uicontrol('style','checkbox',...
%	      'position',[pos(3)*0.01+(lw+lg)*2+30 pos(4)*0.85-(lh+lg)*3 lw*2+lg lh],...
%	      'string','Flip images (left|right)',...
%	      'backgroundcolor',RGB_button,...
%		'foregroundcolor',RGB_text,...
%	      'fontsize',text_size,...
%		'value',1,...
%	      'tag','check_flip');
      
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+30+(lw+lg)*3 pos(4)*0.85-(lh+lg)*0 lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_fov_x',...
	  'string',num2str(FMRI.fov_x),...
	  'horizontalalignment','right');
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+30+(lw+lg)*3 pos(4)*0.85-(lh+lg)*1 lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foreground',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_fov_y',...
	  'string',num2str(FMRI.fov_y),...
	  'horizontalalignment','right');
      uicontrol(...
	  'style','edit',...
	  'position',[pos(1)*0.01+30+(lw+lg)*3 pos(4)*0.85-(lh+lg)*2 lw lh],...
	  'backgroundcolor',[1 1 1],...
	  'foregroundcolor',RGB_text,...
	  'fontsize',text_size,...
	  'tag','edit_thickness',...
	  'string',num2str(FMRI.slicetk),...
	  'horizontalalignment','right');
%      uicontrol('style','checkbox',...
%	      'position',[pos(3)*0.01+(lw+lg)*2+30 pos(4)*0.85-(lh+lg)*4 lw*2+lg lh],...
%	      'string','Reorder slices (last -> 1st)',...
%	      'backgroundcolor',RGB_button,...
%		'foregroundcolor',RGB_text,...
%	      'fontsize',text_size,...
%	      'tag','check_resort');
      
      uicontrol(...
	  'style','pushbutton',...
	  'position',[pos(1)*0.01+(lw+lg)*1 pos(4)*0.85-(lh+lg)*5 lw lh],...
	  'string','OK',...
	  'fontsize',text_size,...
	  'tag','btn_OK',...
	  'callback','set_struc_info(''ok'')',...
	  'backgroundcolor',RGB_button,...
	  'foregroundcolor',RGB_text);
      uicontrol(...
	  'style','pushbutton',...
	  'position',[pos(1)*0.01+30+(lw+lg)*2 pos(4)*0.85-(lh+lg)*5 lw lh],...
	  'string','Cancel',...
	  'fontsize',text_size,...
	  'tag','btn_cancel',...
	  'callback','set_struc_info(''cancel'')',...
	  'backgroundcolor',RGB_button,...
	  'foregroundcolor',RGB_text);
    end
    
  elseif strcmp(action,'cancel'),
    FMRI.struc_name = '';
    FMRI.struc_path = '';
    FMRI.struc_image_width = [];
    FMRI.struc_image_height = [];
    FMRI.struc_image_depth = [];
    FMRI.struc_fov_x = [];
    FMRI.struc_fov_y = [];
    FMRI.struc_slicetk = [];
%    FMRI.struc_flip = [];
%    FMRI.struc_resort = [];
    
    h1 = findobj('name','Structural image information');
    if ~isempty(h1);
      close(h1);
    end
    
    str = sprintf(['Structural image information not available to' ...
		   [' edit this information, please use Modify' ...
		    ' Structural Info under Dataset menu']]);
    %errordlg(str);
    fmrlab_messagedlg('Set Structural Info',...
		  'Warning:',...
		  str);
    
  elseif strcmp(action,'ok'),
    error_flag = 0;
    h1 = findobj('tag','edit_filename');
    str = get(h1,'string');
    FMRI.struc_name = str;
    h1 = findobj('tag','edit_pathname');
    str = get(h1,'string');
    FMRI.struc_path = str;
    h1 = findobj('tag','edit_image_width');
    str = get(h1,'string');
    if isempty(str),
      error_flag = 1;
      msg = sprintf(['Structural image width, height and depth must' ...
		     [' be entered\nSee:\n' ...
		      ' Dataset > Edit Struc Info']]);
      fmrlab_messagedlg('Set Structural Info.',...
		    'Error:',...
		    msg);
      break;
    end
    FMRI.struc_image_width = str2num(str);
    
    h1 = findobj('tag','edit_image_height');
    str = get(h1,'string');
    if isempty(str),
      error_flag = 1;
      msg = sprintf(['Structural image width, height and depth must' ...
		     [' be entered\nSee:\n' ...
		      ' Dataset > Edit Struc Info']]);
      fmrlab_messagedlg('Set Structural Info.',...
		    'Error:',...
		    msg);
      break;
    end
    FMRI.struc_image_height = str2num(str);
    
    h1 = findobj('tag','edit_image_depth');
    str = get(h1,'string');
    if isempty(str),
      error_flag = 1;
      msg = sprintf(['Structural image width, height and depth must' ...
		     [' be entered\nSee:\n' ...
		      ' Dataset > Edit Struc Info']]);
      fmrlab_messagedlg('Set Structural Info.',...
		    'Error:',...
		    msg);
      break;
    end
    FMRI.struc_image_depth = str2num(str);
    
    h1 = findobj('tag','edit_fov_x');
    str = get(h1,'string');
    FMRI.struc_fov_x = str2num(str);
    h1 = findobj('tag','edit_fov_y');
    str = get(h1,'string');
    FMRI.struc_fov_y = str2num(str);
    h1 = findobj('tag','edit_thickness');
    str = get(h1,'string');
    FMRI.struc_slicetk = str2num(str);
%    h1 = findobj('tag','check_flip');
%    FMRI.struc_flip = get(h1,'value');
%    h1 = findobj('tag','check_resort');
%    FMRI.struc_resort = get(h1,'value');
    
    if error_flag == 0,
      h1 = findobj('name','Structural image information');
      if ~isempty(h1);
	close(h1);
      end
    end
    
  elseif strcmp(action,'fileselection'),
    [fname,pname] = uigetfile({'*','All Files (*)'},'Pick a file');
    if ~isempty(fname),
      h1 = findobj('tag','edit_filename');
      set(h1,'string',fname);
      h1 = findobj('tag','edit_pathname');
      set(h1,'string',pname);
    end
    
  end
  