% show_2d() - display normalized ICA component maps (or ROAs) in 2D
%           slice-by-slice display on top of normalized structural
%           images.
%
% Usage:
%   >> show_2d;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: fmrlab_normalize(), spm_affsub3(), show_3d(), show_mip()
%
% Notes: - Must have structural images to perform the spatial
%          normalization process.
%        - show_2d() only works on normalized ICA component maps
%          (or ROAs) and structural images.
%        - The accuracy of the spatial normalization process
%          heavily depends on the image quality and slice
%          number. Thus, the validity of the results of show_2d()
%          cannot be guaranteed. 
        
% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: show_2d.m,v $
% Revision 1.4  2003/02/13 19:13:19  duann
% *** empty log message ***
%
% Revision 1.3  2003/02/13 19:03:07  duann
% if -> switch
%
% Revision 1.2  2003/02/13 18:54:31  duann
% add coronal and sagittal views.
%
% Revision 1.1  2003/02/06 19:16:44  duann
% Initial revision
%

function show_2d

% Jeng-Ren Duann, CNL/Salk Inst., 2002-05-25

  RGB_mainwin = [1 .984 .895];

disp('Select the resulting file to display:');
[map_name, map_path] = uigetfile(...
                    {'nroa_*.img','Load Normalized ROA file (nroa_*.img)'},...
				 'Get Normalized ROA file');
if isequal(map_name,0) | isequal(map_path,0),
  fmrlab_messagedlg('ROA on 2D Normalized Slices',...
		'Warning:',...
		['To export normalized ROA image files, see: Visualize' ...
		 ' > Export Selected Comps']);
  return;
end

disp('Select template file:');
[temp_name, temp_path] = uigetfile(...
  {'*.img','Analyze format image'},...
				   'Select Template');
if isequal(temp_name,0) | isequal(temp_path,0),
  %errordlg('Cancelled by user...!');
  return;
end

str = sprintf('Orientation:\n1: Axial\n2: Sagittal\n3: Coronal');
prompt = {str, 'Z value range:','Slice range (ex. -26:2:20):'};
defs = {'1','[2 10]','-26:2:20'};
a = fmrlab_inputdlg(prompt, '2D Overlay', 1, defs);
if isempty(a),
  %errordlg('Cancelled by user...!');
  return;
end

ori = str2num(char(a(1)));
z_range = str2num(char(a(2)));
slice_range = str2num(char(a(3)));
struc_file = [temp_path temp_name];
map_file = [map_path map_name];

switch(ori),
 case 1,
   show_actslice(struc_file, map_file, z_range, map_file, -1*z_range, ...
	        'axial',slice_range);
 case 2,
   show_actslice(struc_file, map_file, z_range, map_file, -1*z_range, ...
	        'sagittal',slice_range);
 case 3,
   show_actslice(struc_file, map_file, z_range, map_file, -1*z_range, ...
	        'coronal',slice_range);
end

set(gcf,...
    'numbertitle','off',...
    'toolbar','none',...
    'color',RGB_mainwin,...
    'name','2D Slice Overlay of ICA ROAs');
