% show_3d() - display normalized ICA component maps (or ROAs) on 3D
%             rendered brain template provided by SPM99.
%
% Usage:
%    >> show_3d;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: fmrlab_normalize(), spm_affsub3(), show_2d(), show_mip()
% 
% Notes: - Must have structural images to perform the spatial
%          normalization process.
%        - There are SPM96, Averaged and single subject's 3D
%          rendered brain template available.
%        - Translucent or solid color overlay can be displayed in
%          show_3d().

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: show_3d.m,v $
% Revision 1.1  2003/02/06 19:16:51  duann
% Initial revision
%

function show_3d

  RGB_mainwin = [1 .984 .895];

[fname,pname] = uigetfile(...
            {'nroa_*.img','Load Normalized ROA file (nroa_*.img)'},...
			  'Get Normalized ROA file');
if isequal(fname,0) | isequal(pname,0),
  fmrlab_messagedlg('ROA on SPM 3D Brain Template',...
		'Warning:',...
		['To export normalized ROA image files, see: Visualize' ...
		 ' > Export Selected Comps']);
  return;
end

% resolving componet number
for i=length(fname):-1:1
  if fname(i) == '.',
    break;
  end
end
temp = fname(i-4:i-1);
temp = str2num(temp);
ti = sprintf('Comp %d',temp);

str = sprintf('Render on:\n1: SPM96\n2: Average\n3: Single subject');
prompt = {'Lower Bound Z Threshold:', 'Translucences (0.25/0.5/0.75/1):',str};
defs = {'2.0', '0.5','1'};
a = fmrlab_inputdlg(prompt,'3D Rendering',1,defs);
if isempty(a),
  %errordlg('Cancelled by user...!');
  return;
end
zthre = str2num(char(a(1)));
if strcmp(char(a(2)),'nan') == 1,
  trans = nan;
else
  trans = str2num(char(a(2)));
end
temp = str2num(char(a(3)));
filename = [pname fname];
for i=length(filename):-1:1,
  if filename(i) == '.'
    break;
  end
end
filename = filename(1:i-1);
dat = make_blobs(filename, zthre);
switch temp,
  case 1
    fmrlab_render(dat,trans,'render_spm96.mat');
  case 2
    fmrlab_render(dat,trans,'render_smooth_average.mat');
  case 3
    fmrlab_render(dat,trans,'render_single_subj.mat');
end

set(gcf,...
    'color',RGB_mainwin,...
    'numbertitle','off',...
    'toolbar','none',...
    'name','3D Rendering of ICA ROAs');

tx = textsc(0.5, 0.95, ti);
if isunix,
    text_size = 14;
else
    text_size = 12;
end
set(tx,'fontsize',text_size+2,...
       'color',[1 1 1]);