% show_parameters() - display information about all data fields of
%                     FMRI data structure
%
% Usage:
%   >> show_parameters;
%
% Inputs:
%
% Outputs:
%
% Notes: - Instead of showing the content of data fields, for some
%          reason, show_parameters() shows only the length or the size of
%          the data fields.
%
% Author: Jeng-Ren Duann, CNL/Salk Inst., 2001-10
%
% See also: FMRI, set_fmri_global_ui(), modify_param()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: show_parameters.m,v $
% Revision 1.1  2003/02/06 19:17:15  duann
% Initial revision
%

function show_parameters

global FMRI
global hwnd
RGB_text = [.333 .283 .003];

if isunix,
    text_size = 14;
else
    text_size = 12;
end

str = sprintf('\nFMR dataset parameters\n\n');
if isempty(FMRI.filename),
  str = [str sprintf(' Image file name:\n')];
else
  str = [str sprintf(' Image file name:      %s\n',FMRI.filename)];
end
if isempty(FMRI.pathname),
  str = [str sprintf(' Image path:\n')];
else
  if length(FMRI.pathname) <= 25,
    str = [str sprintf(' Image path:           %s\n',FMRI.pathname)];
  else
    j = 0;
    for i=length(FMRI.pathname):-1:1,
      if FMRI.pathname(i) == '\' | FMRI.pathname(i) == '/',
	j = j + 1;
	if j>2,
	  break;
	end
      end
    end
    %temp_str = ['..' FMRI.pathname(i:length(FMRI.pathname))];
    temp_str = FMRI.pathname(length(FMRI.pathname)-21:length(FMRI.pathname));
    str = [str sprintf(' Image path:           ..%s\n',temp_str)];
  end
end

if isempty(FMRI.data),
  str = [str sprintf(' Data size:\n')];
else
  sz = size(FMRI.data);
  str = [str sprintf(' Data size:            %d x %d\n',sz(1),sz(2))];
end
if isempty(FMRI.dime_x),
  str = [str sprintf(' Image dimensions:\n')];
else
  str = [str sprintf(' Image dimensions:     %d x %d x %d\n',FMRI.dime_x,FMRI.dime_y,FMRI.dime_z)];
end
if isempty(FMRI.fov_x),
  str = [str sprintf(' FOV (mm):\n')];
else
  str = [str sprintf(' FOV (mm):             %5.2f x %5.2f\n',...
		     FMRI.fov_x,FMRI.fov_y)];
end
if isempty(FMRI.slicetk),
  str = [str sprintf(' Slice thickness (mm):\n')];
else
  str = [str sprintf(' Slice thickness (mm):%5.2f\n',FMRI.slicetk)];
end
if isempty(FMRI.dummy),
  stra = sprintf('0 dummies');
else
  stra = sprintf('%d dummies',FMRI.dummy);
end
if isempty(FMRI.timepoint),
  strb = sprintf('0 scans');
else
  strb = sprintf('%d scans\n', FMRI.timepoint);
end
str = [str ' Total scan number:    ' stra ' + ' strb];
%if ~isempty(FMRI.dummy) & ~isempty(FMRI.timepoint),
%  str = [str sprintf('  Total scan number:    %d\n',FMRI.dummy+FMRI.timepoint)];
%else
%  str = [str sprintf('  Total scan number:\n')];
%end
if isempty(FMRI.tr),
  str = [str sprintf(' TR:\n')];
else
  str = [str sprintf(' TR (sec):            %5.2f\n',FMRI.tr)];
end
if isempty(FMRI.alignslice),
  str = [str sprintf(' Time-aligned to slice:\n')];
else
  str = [str sprintf(' Time-aligned to slice:%d\n', ...
		     FMRI.alignslice)];
end

	 
%if isempty(FMRI.idx),
%  str = [str sprintf('  Index of brain voxels:\n')];
%else
%  str = [str sprintf('  Index of brain voxels:    %d\n',length(FMRI.idx))];
%end

str = [str sprintf('\nICA parameters\n\n')];
if isempty(FMRI.pcano),
  str = [str sprintf(' Principal dimensions:\n')];
else  
  str = [str sprintf(' Principal dimensions:     %d\n',FMRI.pcano)];
end
if isempty(FMRI.annealdeg),
  str = [str sprintf(' Annealing angle (deg):\n')];
else
  str = [str sprintf(' Annealing angle (deg):    %d\n',FMRI.annealdeg)];
end

if isempty(FMRI.extended),
  str = [str sprintf(' Extended ICA:\n')];
else
  if FMRI.extended == 1,
    str = [str sprintf(' Extended ICA:             Yes\n')];
  else 
    str = [str sprintf(' Extended ICA:             No\n')];
  end       
end

if isempty(FMRI.icasphere)
  str = [str sprintf(' Length of sphere matrix:\n')];
else
  sz = size(FMRI.icasphere);
  str = [str sprintf(' Length of sphere matrix:  %d x %d\n',sz(1),sz(2))];
end

if isempty(FMRI.icaweight)
  str = [str sprintf(' Length of weight matrix:\n')];
else
  sz = size(FMRI.icaweight);
  str = [str sprintf(' Length of weight matrix:  %d x %d\n',sz(1),sz(2))];
end

h = findobj(hwnd,'tag','text2');
set(h,'string',str,...
      'foregroundcolor',RGB_text,...
      'fontname','Courier',...
      'fontsize',text_size);

str = [];
if isempty(FMRI.processed),
  str = [str sprintf('\nDATASET STATUS\n')];
else
    ii = fix(length(FMRI.processed)/45);
    str2 = [];
    for i=1:ii,
        str2 = [str2 sprintf('  %s\n',FMRI.processed((i-1)*45+1:i*45))]; 
    end
    str2 = [str2 sprintf('  %s\n',FMRI.processed(ii*45+1:length(FMRI.processed)))];
  str = [str sprintf('\nDATASET STATUS \n',FMRI.processed) str2];
end

h = findobj(hwnd,'tag','text1');
set(h,'string',str,...
      'foregroundcolor',RGB_text,...
      'fontname','Courier',...
      'fontsize',text_size);








