% slice_timing_ui() - graphic user interface for slice_timing().
%
% Usage:
%   >> slice_timing_ui;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst., 2001-10
%
% See also: slice_timing()


% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: slice_timing_ui.m,v $
% Revision 1.1  2003/02/06 19:34:56  duann
% Initial revision
%

function fig = slice_timing_ui()

  global FMRI
  
  if length(FMRI) == 0,
    fmrlab_messagedlg('Slice Timing',...
		   'Error:',...
		   ['No current data set exists. Please load a' ...
		    ' ''.fmr'' data file first']);
    return;
  end
  

  load slice_timing_ui

% check if the data size is correct
datalen = FMRI.dime_x*FMRI.dime_y*FMRI.dime_z*FMRI.timepoint;
if size(FMRI.data,1) < datalen,
  fmrlab_messagedlg('Slice Timing',...
		 'Error:',...
		 ['Data has been aligned to timing of the specified' ...
		  [' slice. Please move on to extract brain' ...
		   ' voxls.']]);
  return;
end

RGB_mainwin = [1 .984 .895];
RGB_background = [0.860 0.824 0.618];
RGB_button = [0.860 0.824 0.618];
RGB_text = [0.333 0.283 0.003];

if isunix,
    text_size = 14;
else
    text_size = 12;
end

win_width = 340;
win_height = 200;
if isunix,
    btn_height = 25;
    btn_width = 80;
    edit_height = 25;
    edit_width = 280;
else
    btn_height = 20;
    btn_width = 75;
    edit_height = 20;
    edit_width = 245;
end
pos = get(0,'screensize');

fcn = sprintf('h = findobj(gcf,''tag'',''popup1'');');
ss = 'str = {''Interleaved (1,3,5,...,2,4,6,...)'';';
ss = [ss sprintf('''Ascending (1,2,3,...)'';')];
ss = [ss sprintf('''Descending (...,3,2,1)'';')];
ss = [ss sprintf('''Other (enter order below)''};')];
fcn = [fcn sprintf('\n%s',ss)];
fcn = [fcn sprintf('\nset(h,''string'',str);')];
fcn = [fcn sprintf('\nh = findobj(gcf,''tag'',''edit1'');')];
fcn = [fcn sprintf('\nset(h,''string'','''');')];

h0 = figure('Color',RGB_mainwin, ...
	'CreateFcn',fcn, ...
	'FileName','/n/tesla-fe1/usr/export/berger/home/duann/matlab/fmri_toolbox/slice_timing_ui.m', ...
	'PaperUnits','normalized', ...
	'Position',[(pos(3)-win_width)/2 (pos(4)-win_height)/2 win_width win_height], ...
	'name','Align Slice Timing',...
	'numbertitle','off',...
	'ToolBar','none',...
	    'units','points',...
	    'menubar','none');
pos = get(h0, 'position');
h1 = uicontrol('parent',h0,...
	       'style','text',...
	       'string','Slice Acquisition Order',...
	       'position',[5 5*(5+edit_height)+40 edit_width edit_height],...
	       'backgroundcolor',RGB_mainwin,...
	       'foregroundcolor',RGB_text,...
	       'fontsize',text_size,...
	       'horizontalalignment','left'); 
str = {'Interleaved (1,3,5,...,2,4,6,...)';...
       'Ascending (1,2,3,...)';...
       'Descending (...,3,2,1)';...
       'Other (enter order below)'};
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',RGB_button, ...
	       'foregroundcolor',RGB_text,...
	'Callback','slice_timing_ui2', ...
	'fontsize',text_size, ...
	'HorizontalAlignment','left', ...
	'ListboxTop',0, ...
	'Max',4, ...
	'Min',1, ...
	'Position',[5 4*(5+edit_height) edit_width edit_height], ...
	'String',str, ...
	'Style','popupmenu', ...
	'Tag','popup1', ...
	'Value',1);
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',RGB_mainwin, ...
	       'foregroundcolor',RGB_text,...
	'Enable','off', ...
	'fontsize',text_size, ...
	'HorizontalAlignment','left', ...
	'ListboxTop',0, ...
	'Position',[5  3*(5+edit_height) edit_width edit_height], ...
	'Style','edit', ...
	'Tag','edit1',...
	'callback','slice_timing_ui1');
str = 'Adjust data to time of slice (1-N): [where N=nslice]';
str = [str sprintf('\n  Use default: [middle slice in acquisition order]')];
h1 = uicontrol('parent',h0,...
	       'units','points',...
	       'position',[5 2*(5+edit_height) edit_width 1.1*edit_height],...
	       'fontsize',text_size-2,...
	       'style','text',...
	       'string',str,...
	       'horizontalalignment','left',...
	       'backgroundcolor',RGB_mainwin,...
	       'foregroundcolor',RGB_text,...
	       'tag','text1');
aa = [1:2:FMRI.dime_z 2:2:FMRI.dime_z];
%aa = cell(FMRI.dime_z,1);
%for i=1:FMRI.dime_z,
%  aa(i) = {num2str(i)};
%end
h1 = uicontrol('parent',h0,...
	       'units','points',...
	       'position',[5 (5+edit_height) edit_width edit_height],...
	       'fontsize',text_size,...
	       'style','edit',...
	       'tag','edit2',...
	       'backgroundcolor',RGB_mainwin,...
	       'foregroundcolor',RGB_text,...
	       'string', num2str(aa(ceil(length(aa)/2))));
%set(h1,'value',FMRI.dime_z);
get(h0,'position');
btn_gap = (pos(3)-2*btn_width)/3;
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',RGB_button, ...
	       'foregroundcolor',RGB_text,...
	'Callback','slice_timing_ui4', ...
	'fontsize',text_size, ...
	'ListboxTop',0, ...
	'Position',[btn_gap 3 btn_width btn_height], ...
	'String','OK', ...
	'Tag','Pushbutton1');
pos = get(h1,'position');
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback',mat6, ...
	'fontsize',text_size, ...
	'ListboxTop',0, ...
	'Position',[2*btn_gap+btn_width 3 btn_width btn_height], ...
	       'backgroundcolor',RGB_button,...
	       'foregroundcolor',RGB_text,...
	'String','Cancel', ...
	'Tag','Pushbutton2');
if nargout > 0, fig = h0; end
