% slice_timing_ui4() - subfunction called by slice_timing().
%
% Usage:
%    >> slice_timing_ui4;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst., 2001-10
%
% See also: slice_timing()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: slice_timing_ui4.m,v $
% Revision 1.1  2003/02/06 19:34:52  duann
% Initial revision
%


function slice_timing_ui4
  
  global FMRI
  global hwnd
  
  hh = findobj('name','Align Slice Timing');
  h = findobj(hh,'tag','popup1');
  a = get(h,'value');
  if a == 4,
    h = findobj(hh,'tag','edit1');
    b = '';
    b = get(h,'string');
    slice_order = str2num(char(b));
  end
    
  if a == 1,
    slice_order = [];
    for i=1:2:FMRI.dime_z,
      slice_order = [slice_order i];
    end
    for i=2:2:FMRI.dime_z,
      slice_order = [slice_order i];
    end
  end
      
  if a == 2,
    slice_order = [];
    for i=1:FMRI.dime_z,
      slice_order = [slice_order i];
    end 
  end 
  
  if a == 3,
    slice_order = []; 
    for i=FMRI.dime_z:-1:1, 
      slice_order = [slice_order i]; 
    end 
  end 
  
  slice_order 
  
  % get the refering_slice
  h = findobj(hh, 'tag','edit2');
  a = get(h,'string');
  refering_slice = str2num(char(a))
  if refering_slice > FMRI.dime_z | refering_slice < 1,
    fmrlab_messagedlg('Slice Timing',...
		   'Error:',...
		   'Slice number specified is out of range');
    return;
  end

  set(hwnd,'pointer','watch'); 
  FMRI.data = slice_timing(FMRI.data,FMRI.timepoint,slice_order, refering_slice); 
  set(hwnd,'pointer','arrow'); 
  FMRI.processed = [FMRI.processed ':time_aligned']; 
  show_parameters 
  close
%  hh = findobj('name','Align Slice Timing');
%  close
