% spatial_smooth() - perform 3 by 3 averaging mask on 2D slices of
%                    fMRI data. 
% 
% Usage:
%   >> spatial_smooth;
%
% Inputs:
%
% Outputs:
%
% Notes: - spatial_smooth() is not recommended for the common data
%          analysis of fMRI data using ICA, especially infomax ICA,
%          unless the fMRI data is fairly noisy in spatial domain. 
%        - spatial_smooth() works only in 2D slices instead of 3D
%          volume by a simple 3 by 3 averaging mask beacuse we don't
%          want too much smoothing to change the data distribution of
%          fMRI data.
%
% Author: Jeng-Ren Duann, CNL/Salk Inst., 2002-10
% 
% See also: rm_slice(), temporal_smooth()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: spatial_smooth.m,v $
% Revision 1.1  2003/02/06 18:26:29  duann
% Initial revision
%

function spatial_smooth
  
  global FMRI
  global hwnd
  
  if length(FMRI) == 0,
    fmrlab_messagedlg('Spatial Smoothing',...
	       'Error:',...
	       ['No current data set exists. Please load a ''.fmr''' ...
		' data files first']);
    return;
  end
  
  str = sprintf('Spatially smooth the data with a 3x3 smoothing-window?');
  button_name = fmrlab_messagedlg(...
      'Spatial Smoothing',...
      'Information',...
      str,...
      {'OK','Cancel'});

  if strcmp(button_name,'OK'),
    FMRI.data = reshape(FMRI.data,FMRI.dime_x,FMRI.dime_y, ...
	  	      FMRI.dime_z,FMRI.timepoint);
    data = FMRI.data;
    x = FMRI.dime_x;
    y = FMRI.dime_y;
    for i=1:FMRI.timepoint,
      for j=1:FMRI.dime_z,
	temp = reshape(FMRI.data(:,:,j,i),FMRI.dime_x,FMRI.dime_y);
	temp1 = zeros(size(temp));
	temp2 = zeros(size(temp));
	temp3 = zeros(size(temp));
	temp4 = zeros(size(temp));
	temp5 = zeros(size(temp));
	temp6 = zeros(size(temp));
	temp7 = zeros(size(temp));
	temp8 = zeros(size(temp));
	
	temp1(1:x-1,1:y-1) = temp(2:x,2:y);
	temp2(1:x-1,:)   = temp(2:x,:);
	temp3(1:x-1,2:y)   = temp(2:x,1:y-1);
	temp4(:,1:y-1)     = temp(:,2:y);
	temp5(:,2:y)       = temp(:,1:y-1);
	temp6(2:x,1:y-1)   = temp(1:x-1,2:y);
	temp7(2:x,:)       = temp(1:x-1,:);
	temp8(2:x,2:y)     = temp(1:x-1,1:y-1);
	
	temp = (temp+temp1+temp2+temp3+temp4+temp5+temp6+temp7+ ...
		temp8)/9;
	
	data(:,:,j,i) = reshape(temp,x,y,1,1);
%        for y=2:FMRI.dime_y-1,
%	  for x=2:FMRI.dime_x-1,
%	    temp = FMRI.data(x-1:x+1,y-1:y+1,j,i);
%	    temp = sort(temp(:));
%	    data(x,y,j,i) = temp(5);
%	  end
%        end
      end
    end
    FMRI.data = reshape(data,FMRI.dime_x*FMRI.dime_y*FMRI.dime_z*FMRI.timepoint,1);
    FMRI.processed = [FMRI.processed ':spatially_smoothed'];
    show_parameters;
  end
  