% clear_fmri_global() - clear FMRI data structure from the current
%                       working environment. 
%
% Usage: 
%   >> clear_fmri_global;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2001-10
%
% See also: set_fmri_global_ui(), load_dataset()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: clear_fmri_global.m,v $
% Revision 1.1  2003/02/06 18:56:43  duann
% Initial revision
%

function clear_fmri_global

global FMRI

if ~isempty(FMRI),
  FMRI = struct('data',    [], ...
              'filename',  [], ...
              'pathname',  [], ...
	      'dime_x',    [], ...
	      'dime_y',    [], ...
              'dime_z',    [], ...
              'fov_x',     [], ...
              'fov_y',     [], ...
              'slicetk',   [], ...
              'dummy',     [], ...
              'timepoint', [], ...
              'tr',        [], ...
              'idx',       [], ...
              'processed', [], ...
		'struc_name', [], ...
		'struc_path', [], ...
		'struc_image_width', [], ...
		'struc_image_height', [], ...
		'struc_image_depth', [], ...
		'struc_fov_x', [], ...
		'struc_fov_y', [], ...
		'struc_slicetk', [], ...
		'struc_resort', [], ...
		'struc_flip', [], ...
	      'pcano',     [], ...
	      'annealdeg', [], ...
              'extended',  [], ...
              'icasphere', [], ...
              'icaweight', [], ...
              'icacomp',   [], ...
		'rejcomp', [], ...
		'ica_zthre', [], ...
		'ica_zbound', [], ...
		'soa', [], ...
		'trial_length', []);
end

