% clear_workspace() - clear current workspace by closing all
%                     windows (except main window) opened by
%                     'fmrlab'
%
% Usage: 
%   >> clear_workspace(act);
%
% Inputs:
%   act - actions, if 'all', called by Exit of main program
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2001-20
%
% See also: clear_fmri_global()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: clear_workspace.m,v $
% Revision 1.1  2003/02/06 18:56:58  duann
% Initial revision
%

function clear_workspace(act)

if nargin < 1,
  act = 1;
end
switch(act)
 case 1
    buttonname = fmrlab_messagedlg(...
        'Clear Workspace',...
        'Warning:',...
        'Do you want to close all figures?',...
        {'Yes','No'});
    if strcmp(buttonname,'Yes')==1,
        b = findobj('name','FMRLAB v2.2');
        a = findobj('type','figure');
        for i=1:length(a),
	        if a(i) ~= b,
	            delete(a(i));
            end
        end
    end

 case 2
    b = findobj('name','FMRLAB v2.2');
    a = findobj('type','figure');
    for i=1:length(a),
	    if a(i) ~= b,
	        delete(a(i));
        end
    end
    delete(b);
    
 case 3,
  b = findobj('name','FMRLAB v2.2');
    a = findobj('type','figure');
    for i=1:length(a),
	    if a(i) ~= b,
	        delete(a(i));
        end
    end
end