% create_ref() - create reference function for fmri analysis. 
%
% Usage:
%    >> create_ref(action);
%
% Inputs:
%    action - put 'initialize' to initialize the window
%
% Outputs:
%    
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2001-10
%
% See also: mrp_on_fmri(), map_on_struf()
%
% Notes:
%    - the output reference function will be saved in FMRI data
%      structure as FMRI.ref

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: create_ref.m,v $
% Revision 1.1  2003/02/06 18:57:08  duann
% Initial revision
%


function create_ref(action)

  global FMRI
  
if nargin<1,
  action = 'initialize';
end

% initialize variables
no_cond = 2;
ref_tc = [];
RGB_mainwin = [1 .97 .798];
RGB_background = [1 0.984 0.895];
RGB_button = [0.860 0.824 0.618];
RGB_text = [0.333 0.283 0.003];

if strcmp(action,'initialize'),
    
    if isunix,
        text_size = 14;
    else
        text_size = 12;
    end
    
  % create the base window
  figNumber = figure( ...
    'name', 'Create Reference Function for fMRI Analysis', ...
    'numbertitle','off',...
    'doublebuffer', 'on', ...
    'color',RGB_mainwin,...
    'backingstore','off');
  
  ax1 = sbplot(5,5,[1 20]);

  f1 = uicontrol('style','frame',...
    'backgroundcolor',RGB_background);
  pos = get(f1,'position');
  set(f1,'position',[pos(1)-13 pos(2) 170 pos(4)+35]);
  pos = get(f1,'position');
  uicontrol('style','text',...
    'position',[pos(1)+5 pos(4) 75 15],...
    'string','Conditions',...
    'backgroundcolor',RGB_background,...
	    'foregroundcolor',RGB_text,...
    'fontsize',text_size);
  callbackStr = 'create_ref(''alter_cond'');';
  ed_cond = uicontrol('style','edit',...
    'backgroundcolor',RGB_background,...
		      'foregroundcolor',RGB_text,...
    'string','2',...
    'fontsize',text_size,...
    'callback',callbackStr,...
    'tag','ed_cond',...
    'position',[pos(1)+5 pos(2)+5 50 25]);
  popStr = {'Cond 1', 'Cond 2'};
  pos = get(ed_cond,'position');
  popup_cond = uicontrol('style','popupmenu',...
    'string',popStr,...
    'fontsize',text_size,...
			 'backgroundcolor',RGB_button,...
			 'foregroundcolor',RGB_text,...
    'tag','popup_cond',...
    'position',[pos(1)+pos(3)+5 pos(2) 100 25]);

  pos = get(f1,'position');
  f2 = uicontrol('style','frame',...
    'backgroundcolor',RGB_background,...
		 'foregroundcolor',RGB_text,...
    'position',[pos(1)+pos(3)+5 pos(2) 150 pos(4)]);
  pos = get(f2,'position');
  uicontrol('style','text',...
    'position',[pos(1)+5 pos(4) 100 15],...
    'string','Frame Length',...
    'backgroundcolor',RGB_background,...
	    'foregroundcolor',RGB_text,...
    'fontsize',text_size);
  ed_frame = uicontrol('style','edit',...
    'backgroundcolor',RGB_background,...
		       'foregroundcolor',RGB_text,...
    'string','10',...
    'fontsize',text_size,...
    'tag','ed_frame',...
    'position',[pos(1)+5 pos(2)+5 50 25]);
  pos = get(ed_frame,'position');
  callbackStr = 'create_ref(''append'');';
  bt_append = uicontrol('style','pushbutton',...
    'string','Append',...
    'fontsize',text_size,...
			'backgroundcolor',RGB_button,...
			'foregroundcolor',RGB_text,...
    'tag','bt_append',...
    'callback',callbackStr,...
    'position',[pos(1)+pos(3)+5 pos(2) 80 25]);

  pos = get(f2,'position');
  f3 = uicontrol('style','frame',...
    'backgroundcolor',RGB_background,...
		 'foregroundcolor',RGB_text,...
    'position',[pos(1)+pos(3)+5 pos(2) 150 pos(4)]);
  pos = get(f3,'position');
  uicontrol('style','text',...
    'position',[pos(1)+5 pos(4) 80 15],...
    'string','Replication',...
    'backgroundcolor',RGB_background,...
	    'foregroundcolor',RGB_text,...
    'fontsize',text_size);
  ed_rep = uicontrol('style','edit',...
    'backgroundcolor',RGB_background,...
		     'foregroundcolor',RGB_text,...
    'string','10',...
    'fontsize',text_size,...
    'tag','ed_rep',...
    'position',[pos(1)+5 pos(2)+5 50 25]);
  pos = get(ed_rep,'position');
  callbackStr = 'create_ref(''replicate'');';
  bt_rep = uicontrol('style','pushbutton',...
    'string','Replicate',...
    'fontsize',text_size,...
		     'backgroundcolor',RGB_button,...
		     'foregroundcolor',RGB_text,...
    'tag','bt_rep',...
    'callback',callbackStr,...
    'position',[pos(1)+pos(3)+5 pos(2) 80 25]);

  pos = get(bt_rep,'position');
  callbackStr = 'create_ref(''clear'');';
  bt_clear = uicontrol('style','pushbutton',...
    'string','Clear',...
    'fontsize',text_size,...
		       'backgroundcolor',RGB_button,...
		       'foregroundcolor',RGB_text,...
    'tag','bt_clear',...
    'callback',callbackStr,...
    'position',[pos(1)+pos(3)+10 pos(2)-3 70 25]); 
  pos = get(bt_clear,'position');
  callbackStr = 'create_ref(''save'');';
  bt_save = uicontrol('style','pushbutton',...
    'string','Save',...
    'fontsize',text_size,...
		      'backgroundcolor',RGB_button,...
		      'foregroundcolor',RGB_text,...
    'tag','bt_save',...
    'callback',callbackStr,...
    'position',[pos(1) pos(2)+pos(4)+3 70 25]); 

  % save the temporary variable in the 'userdata' of gcf
  a = struct(...
    'ax',ax1,...
    'ref_tc',ref_tc);
  set(gcf,'userdata',a);

elseif strcmp(action,'alter_cond'),
  a = findobj('tag','ed_cond');
  no_cond = str2num(get(a,'string'))
  popStr = cell(no_cond,1);
  for i=1:no_cond,
    str = sprintf('Cond %d',i);
    popStr{i} = str;
  end
  a = findobj('tag','popup_cond');
  set(a,'value',1,...
    'string','Cond 1',...
    'max',1,...
    'string',popStr);

elseif strcmp(action,'append'),
  a = findobj('tag','popup_cond');
  cond = get(a,'value')-1;
  a = findobj('tag','ed_frame');
  len = str2num(get(a,'string'));
  temp_tc = cond * ones(1,len);
  a = get(gcf,'userdata');
  ref_tc = a.ref_tc;
  ref_tc = [ref_tc temp_tc];
  x = [1:length(ref_tc)];
  line(x,ref_tc,'parent',a.ax,'color','r');
  
  a = struct(...
    'ax',a.ax,...
    'ref_tc',ref_tc);
  set(gcf,'userdata',a);

elseif strcmp(action,'replicate'),
  a = get(gcf,'userdata');
  ref_tc = a.ref_tc;
  ax = a.ax;

  a = findobj('tag','ed_rep');
  no_rep = str2num(get(a,'string'));
  ref_tc = repmat(ref_tc,1,no_rep+1);
  x = [1:length(ref_tc)];
  line(x,ref_tc,'parent',ax,'color','r');

  a = struct(...
    'ax',ax,...
    'ref_tc',ref_tc);
  set(gcf,'userdata',a);

elseif strcmp(action,'clear');
  a = get(gcf,'userdata');
  ref_tc = a.ref_tc;
  ax = a.ax;
  cla(ax)
  ref_tc = [];
  a = struct(...
    'ax',ax,...
    'ref_tc',ref_tc);
  set(gcf,'userdata',a);

elseif strcmp(action,'save'),
  a = get(gcf,'userdata');
  ref_tc = a.ref_tc;
  ax = a.ax;

  if isempty(FMRI),
    fmrlab_messagedlg('Create Reference',...
		  'Error:',...
		  'No FMRI structure exists');
    break;
  end
  FMRI.ref = ref_tc; 
end
