% erosion() - calculate erosion of input image.
%
% Usage:
%   >> outbuf = erosion(buf,neighbor);
%
% Inputs:
%    buf      - the input image buffer.
%    neighbor - erosion based on n by n neighborhood of each pixel
%
% Outputs:
%    outbuf - resulting image.
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. 2002-10
%
% See also: dilation()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: erosion.m,v $
% Revision 1.1  2003/01/29 21:44:01  duann
% Initial revision
%

function outbuf = erosion(buf,neighbor)

if nargin < 2,
  neighbor = 3;
end

sz = size(buf);
tempbuf = zeros(((neighbor+1)+sz(1)),((neighbor+1)+sz(2)));
tempbuf(1+(neighbor+1)/2:sz(1)+(neighbor+1)/2,1+(neighbor+1)/2:sz(2)+(neighbor+1)/2) = buf;

outbuf = zeros(sz(1),sz(2));
for i=1:sz(2),
  for j=1:sz(1);
    cx = j+(neighbor+1)/2;
    cy = i+(neighbor+1)/2;
    a = tempbuf(cx-(neighbor+1)/2:cx+(neighbor+1)/2,cy-(neighbor+1)/2:cy+(neighbor+1)/2); 
    outbuf(j,i) = min(a(:));
  end
end

