% extract_brain_by_edit() - this subroutine is called by
%                           extract_brain_ui() to set threshold by
%                           keying in number in the edit box of the
%                           interactive dialog 
%
% Usage:
%    >> extract_btain_by_edit;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2001-10
%
% See also: extract_brain_ui()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: extract_brain_by_edit.m,v $
% Revision 1.1  2003/02/06 18:58:17  duann
% Initial revision
%

function extract_brain_by_edit

h = findobj('tag','edit1');
a = get(h,'string');
a = str2num(char(a(1)));
h = findobj('tag','slider1');
set(h,'value',a);
temp = zeros(size(avg_data));
ii = find(avg_data >= a);
temp(ii) = avg_data(ii);

for i=1:FMRI.dime_z,
    temp1 = temp(:,:,i);
    temp1 = erosion(temp1,1);
    temp1 = dilation(temp,1);
    temp(:,:,i) = temp1;
end

ii = find(temp > 0);
temp = zeros(size(avg_data));
temp(ii) = avg_data(ii);

for i=1:slice_show,
    axes(h1(6-1));
    imagesc(temp(:,:,i)');
end
