% extract_brain_preview() - subfunction called by
%                           extract_brain_ui() to create preview
%                           window for setting threshold
%
% Usage:
%    >> extract_brain_preview;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: extract_brain_ui()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: extract_brain_preview.m,v $
% Revision 1.1  2003/02/06 18:58:29  duann
% Initial revision
%


function extract_brain_preview()

global FMRI

sz = size(FMRI.data);
FMRI.data = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y*FMRI.dime_z,FMRI.timepoint);
FMRI.data = FMRI.data';
temp = FMRI.data;
avg_data = mean(temp);
avg_data = reshape(avg_data,FMRI.dime_x,FMRI.dime_y,FMRI.dime_z);
FMRI.data = reshape(temp',sz);
h = findobj('tag','slider1');
set(h,'max',max(avg_data(:)));
h = findobj('tag','edit1');
set(h,'string','0');
h1 = findobj(gcf,'tag','Axes1');
slice_show = min(FMRI.dime_z, 5);
for i=1:slice_show,
  axes(h1(11-i));
  imagesc(avg_data(:,:,i)');
end
for i=1:slice_show,
  axes(h1(6-i));
  imagesc(avg_data(:,:,i)');
end
temp = avg_data;
colormap(gray);


