% fmrlab() - FMRLAB (Version 2.2) - Graphic user interface
% environment for functional MRI 9fMRI data analysis using ICA
% (Makeig et al., CNL / The Salk Institute, 1997-2002). Currently,
% FMRLAB is hosted (2002-) by the Swartz Center for Computational
% Neuroscience, Institute for Neural Computation, University of
% California San Diego (http://sccn.ucsd.edu/). Feedback from users
% is welcome {duann@salk.edu}.
%
% Description:
%   FMRLAB (fmrlab.m) is a Matlab tolbox for preprocessing the
%   fMRI time series, performing indeoendent component analysis,
%   and visualizing the resulting activation maps and time
%   courses. Although the origin of designing FMRLAB toolbox is to
%   build a graphic user interface (GUI) for the novice users to
%   explore the hemodynamic phenomena behind the observation of fMRI
%   data, most of the functions in this toolbox can be also used by
%   typing command name in command line by the expert users. 
%
% Usage: 
%   1) for novice users:
%      >> fmrlab % execute the main function of FMRLAB toolbox
%      executing FMRLAB toolbox by typing the main function in the
%      command line and following the instruction of the
%      interactive graphic user interface.
%   2) for expert users:
%      >> load xxxx.fmr
%      loading the fMRI data structure to begin with and using the
%      command line version of functions to manipulate fMRI data.
% 
% Author: Jeng-Ren Duann (duann@salk.salk) with
%         Tzyy-Ping Jung (jung@salk.edu) and Scott Makeig
%         (smakeig@ucsd.edu)

% Main files:
% -----------
% fmrlab.m           - main function of FMRLAB toolbox
% fmrlab.mat         - MAT file to keep necessary parameters for
%                      FMRLAB toolbox
% license.txt        - GNU license
% boldimage.m        - image the intertrial dynamics of BOLD
%                      signal.
% check_image_ui.m   - check if imported images are in big-endian
% clear_fmri_global.m - clear FMRI data structure from the working
%                       environment
% clear_workspace.m   - clean up the workspace by closing all the
%                       opened windows by FMRLAB
% dilation.m          - perform dilation on input image (used in
%                       extract_brain_ui())
% erosion.m           - perform erosion on input image (used in
%                       extract_brain_ui())
% execute_ica.m       - execute ICA with GUI for users to specify
%                       parameters
% export_result.m     - export region of activity (ROA) maps to
%                       ANALYZE format for further visualization
% extract_brain_by_edit.m - set threshold value for removing
%                       off-brain voxels by key in value in edit
%                       box
% extract_brain_ui.m  - GUI for user to remove the off-brain voxels
% extract_brain_ui.mat- MAT file to keep the necessary fields for
%                       extract_brain_ui()
% get_status.m        - get current status of FMRI data structure
% ica_linux           - main program of binary ICA
% fmrlab_color.m      - specify the colormap used to display the
%                       functional ROAs
% fmrlab_normalize.m  - 3D normalize ROA map to standard brain
%                       template
% fmrlab_render.m         - 3D rendering of ROA map on 3D standard
%                       brain template provided by SPM99
% load_dataset.m      - load FMRI data structure up to the working
%                       space
% make_blobs.m        - read spatially normalized ICA ROA map and
%                       convert it to the data structure used to in
%                       3D rendering processes
% map_on_fmri.m       - component browser by overlaying ROA onto 2D
%                       slices of functional images with interactive 
%                       graphic user interface
% map_on_struc.m      - component browser by overlaying ROA onto 2D
%                       slices of structural images with
%                       interactive graphic user interface
% modify_param.m       - modify necessary parameters for data
%                       analysis and visualization
% modify_struc_info.m - modify parameters of structural images
% progressbar.m       - progress bar showing the progress of the
%                       running program
% pvafmap_ui.m        - display percentage variance accounted for
%                       (pvaf) map with graphic user interface
% read_analyze_hdr.m  - read header file of images saved in ANALYZE
%                       format
% read_structure.m    - read structural images according to the
%                       specified parameter
% remove_dummy.m      - remove dummy scans from the fMRI time
%                       series data
% reselect_fmri.m     - select new fMRI data set with the same
%                       parameters
% rm_slice.m          - remove noisy slices from fMRI data
% roamap_ui.m         - display ROA maps with graphic user
%                       interface
% roaproj_ui.m        - ROA back-projection to fine the
%                       back_projected ICA time courses and mean time
%                       course of the ROA voxels and calculate the
%                       PVAF for a specified component
% roatc_ui.m          - find the mean time course of the ROA voxels
% save_dataset.m      - save FMRI data structure as .fmr file in
%                       disk
% set_fmri_global.m   - construct FMRI data structure as global
%                       variable in current workspace for further
%                       analysis
% set_fmri_global_ui.m- set_fmri_global() with interactive graphic
%                       user interface
% set_struc_info.m    - select structural images into FMRI data
%                       structure and set the necessary parameters
% show_2d.m           - call show_actslice() and display normalized
%                       ICA ROA maps onto normalized 2D structural
%                       image of individual subjects or 2D brain
%                       template in a slice-by-slice manner
% show_3d.m           - display normalized ICA ROA maps onto the
%                       rendered 3D brain templates provided by
%                       SPM99
% show_actslice.m     - overlay the activation map onto the
%                       structural image. Both structural images
%                       and activation map should be normalized to
%                       the standard brain space (Talairach space)
%                       with SPM.
% show_mip.m          - display normalized ICA ROA maps on mip
%                       template provided by SPM99
% show_parameters.m   - show parameters of image acquisition and
%                       analysis in main window
% slice_timing.m      - adjust image inhomogeneity due to different
%                       acquisituib timing for each slice
% slice_timing_ui.m   - graphic user interface of slice_timing()
% slice_timing_ui.mat - necessary information needed for
%                       slice_timing_ui()
% spatial_smooth.m    - spatially smooth image slices to remove the
%                       spiky noise due to slignal lose in image
%                       acquisition
% temporal_smooth.m   - temporally smooth fMRI time courses with 3
%                       time-point averaging
% tightsubplot.m      - compact version of subplot()
%
% Functions added in FMRLAB from ICA toolbox:
% -------------------------------------------
% binica.m     - Matlab function to interface stannd alone binary
%                version ICA (excutable by C)
% binica.sc    - script file to keep initial values for ICA training
% cbar.m       - showing color bar
% eegfilt.m    - (high|band|low)-pass filter fMRI time courses using
%                two-way least-square FIR filtering (Signal Processing
%                Toolbox needed)
% floatread.m  - read floating-point binary data from a file
% floatwrite.m - write floating-point binary data into a file
% icadefs.m    - define ICA defaults
% sbplot.m     - create axes in arbitrary subplot grid positions
%                and sizes
% fmrlab_scale.m - Scales an image such that its lowest value attains
%                newMin and its highest value attains newMax
% textsc.m     - print text at the specified location in Matlab
%                figure
% 
% Functions added in FMRLAB from SPM99 toolbox:
%----------------------------------------------
% mip.mat          - template file for maximal intensity projection (MIP)
%                    display
% render_single_subj.mat - 3D rendered brain template from single
%                    subject to render the resulting ROA maps 
% render_smooth_average.mat - 3D rendered brain template from
%                    smoothed averaged brain to render the resulting
%                    ROA maps
% render_spm96.map - 3D rendered brain template from SPM96 to
%                    render the resulting ROA maps
% spm_affsub3.m    - highest level subroutine involved in affine
%                    transformations 
% spm_atranspa.m   - Multiplies the transpose of a matrix by itself -
%                    a compiled routine
% spm_atrnaspa.mexlx - mex file for spm_atranspa() in Linux.
% spm_chi2_plot.m  - display a plot showing convergence of an
%                    optimization routine
% spm_conv_vol.m   - convolves a mapped volume with a three
%                    dimensional separable function
% spm_conv_vol.mexlx - mex file for spm_conv_vol() in Linux
% spm_create_image.m -create an image file
% spm_dctmtx.m     - creates basis functions for Discrete Cosine
%                    Transform
% spm_figure.m     - setup and callback functions for Graphics
%                    window
% spm_get.m        - user interface for filename selection
% spm_get_space.m  - get or set the best guess for the space of the
%                    image
% spm_global.m     - returns the global mean for a memory mapped
%                    volume image
% spm_global.mexlx - mex file for spm_global() in Linux
% spm_hread.m      - reads a header of ANALYZE formatted image
% spm_hwrite.m     - write a header of ANALYZE formatted image
% spm_list_files.m - lists files and directories
% spm_list_files.mexlx - mex file for spm_list_files() in Linux
% spm.m            - Statistical Parametric Mapping (startup
%                    function)
% spm_matrix.m     - returns an affine transformation matrix
% spm_platform.m   - platform specific configuration parameters for
%                    SPM
% spm_project.m    - forms maximium intensity projections
% spm_project.mexlx- mex file for spm_project() in Linux
% spm_sample_vol.m - returns voxel values from a memory mapped image
% spm_sample_vol.mexlx - mex file for spm_sample_vol() in Linux
% spm_slice_vol.m  - returns a slice through a memory mapped image
% spm_slice_vol.mexlx - mex file for spm_slice_vol() in Linux
% spm_smooth.m     - 3 dimensional convolution of an image
% spm_str_manip.m  - miscellaneous string manipulation options
% spm_type.m       - translates data type specifiers between SPM &
%                    Matlab representations
% spm_unlink.m     - routine for silently deleting files on disk
% spm_unlink.mexlx - mex file for spm_unlink() in Linux
% spm_vol_ecat7.m  - get header information etc. for ECAT 7 images
% spm_vol.m        - get header information etc for images
% spm_vol_minc.m   - get header information etc. for MINC images
% spm_write_plane.m- write a transverse plane of image data
% spm_write_sn.m   - write out normalized images
% T1.hdr           - header file of SPM99 T1 template images
% T1.img           - image file of SPM99 T1 template images
% 
% Functions added in FMRLAB from supplements to SPM99 toolbox:
%-------------------------------------------------------------
% slice_overlay.m - overlay functional map onto structural images
%                   in standard Talairach coordinates
%
% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: fmrlab.m,v $
% Revision 1.2  2003/03/04 01:18:33  duann
% add menu item 'Check Image(s)'
%
% Revision 1.1  2003/02/06 19:00:11  duann
% Initial revision
%

function fig = fmrlab(action)

  if nargin ~= 0,
    if strcmp(action,'redraw'),
      h = findobj('name','FMRLAB v2.2');
      if ~isempty(h)
	figure(h);
	return
      end
    elseif strcmp(action, 'rebuild'),
      clear_workspace;
      return
    end
  end

  h0 = findobj('name','FMRLAB v2.2');
  if ~isempty(h0),
    figure(h0);
    return;
  end
  
global MODIFY
MODIFY=0;

RGB_mainwin = [1 .984 .895];
RGB_background = [0.860 0.824 0.618];
RGB_button = [0.860 0.824 0.618];
RGB_text = [0.333 0.283 0.003];

screensize = get(0,'screensize');

fcn = 'global FMRI;';
fcn = [fcn sprintf('\nglobal hwnd;')];
fcn = [fcn sprintf('\nhwnd=gcf;')];

if isunix,
    win_pos = [5 100 450 450];
    text_size = 12;
else
    win_pos = [5 35 450 450];
    text_size = 10;
end

h0 = figure('Color',RGB_mainwin, ...
	'CreateFcn',fcn, ...
	'DeleteFcn','clear_workspace(2);', ...
	'MenuBar','none', ...
	'Name','FMRLAB v2.2', ...
	    'numbertitle','off',...
	'PaperUnits','points', ...
	'Position',win_pos, ...
	'Tag','Fig1', ...
	'ToolBar','none');

h1 = uimenu('Parent',h0, ...
	'Label','&Dataset', ...
	    'foregroundcolor',RGB_text,...
	'Tag','&Windowuimenu1');
h2 = uimenu('Parent',h1, ...
	'Callback','set_fmri_global_ui', ...
	'Label','Create Dataset', ...
	    'foregroundcolor',RGB_text,...
	'Tag','&Datasetuimenu1');
h2 = uimenu('Parent',h1, ...
	'Callback','load_dataset', ...
	'Label','Load Dataset', ...
	    'foregroundcolor',RGB_text,...
	'Tag','&DatasetLoad Dataset1');
h2 = uimenu('Parent',h1, ...
	'Callback','save_dataset', ...
	'Label','Save Dataset', ...
	    'foregroundcolor',RGB_text,...
	'Tag','&DatasetSave Dataset1');
h2 = uimenu('Parent',h1, ...
	'Callback','FMRI = [];h=findobj(hwnd,''tag'',''text1'');set(h,''string'','''');', ...
	'Label','Clear Dataset', ...
	    'foregroundcolor',RGB_text,...
	'Tag','&DatasetClear Dataset1');
h2 = uimenu('Parent',h1, ...
	'Callback','reselect_fmri', ...
	'Label','New Data (Same Info)', ...
	    'foregroundcolor',RGB_text,...
	'Tag','Dataset_Reselect');
h2 = uimenu('Parent',h1, ...
	'Callback','modify_param(''fMRI'')', ...
	    'separator','on',...
	'Label','Edit Funct. Info', ...
	    'foregroundcolor',RGB_text,...
	'Tag','Dataset_modify_info');
%h2 = uimenu('Parent',h1, ...
%	'Callback','modify_param(''BOLD'')', ...
%	'Label','Modify BOLD Info', ...
%	    'foregroundcolor',RGB_text,...
%	'Tag','DatasetModifyBOLDinfo');
h2 = uimenu(...
    'parent',h1,...
    'label','Edit Struct. Info',...
    'foregroundcolor',RGB_text,...
    'tag','dataset_modify_struc_info',...
    'callback','modify_struc_info');

h2 = uimenu('Parent',h1, ...
	'Callback','clear_workspace(2);', ...
	'Label','Exit', ...
	 'foregroundcolor',RGB_text,...
	'Separator','on', ...
	'Tag','&Exit Dataset1');

h1 = uimenu('Parent',h0, ...
	'Label','Process', ...
	    'foregroundcolor',RGB_text,...
	'Tag','&Process');
h2 = uimenu('Parent',h1,...
	    'callback','check_image_ui',...
	    'label','Check Image(s)',...
	    'foregroundcolor',RGB_text,...
	    'Tag','process_ckimg');
h2 = uimenu('Parent',h1,...
	    'callback','rm_slice',...
	    'label','Remove Slice(s)',...
	    'foregroundcolor',RGB_text,...
	    'Tag','process_rm_slice');
h2 = uimenu('Parent',h1, ...
	'Callback','remove_dummy', ...
	'Label','Remove Dummies', ...
	    'foregroundcolor',RGB_text,...
	'Tag','Processuimenu2');
h2 = uimenu('Parent',h1,...
	    'callback','temporal_smooth',...
	    'label','Smooth Temporally',...
	    'foregroundcolor',RGB_text,...
	    'Tag','process_tempo_smooth');

h2 = uimenu('Parent',h1, ...
	'Callback','slice_timing_ui', ...
	'Label','Align Slice Timing', ...	    
	    'foregroundcolor',RGB_text,...
	'Tag','Processuimenu1');
h2 = uimenu('parent',h1,...
	    'callback','spatial_smooth',...
	    'label','Smooth Spatially',...
	    'foregroundcolor',RGB_text,...
	    'tag','process_spatial_smooth');
h2 = uimenu('Parent',h1, ...
	'Callback','extract_brain_ui2', ...
	'Label','Extract Brain Voxels', ...
	    'foregroundcolor',RGB_text,...
	'Tag','ProcessSlice Extractbrain');
h2 = uimenu('Parent',h1, ...
	'Callback','execute_ica', ...
	'Label','Run ICA', ...
	    'foregroundcolor',[1 0 0],...
	'Separator','on', ...
	'Tag','ProcessICATraining');
h1 = uimenu('Parent',h0, ...
	'Label','Visualize', ...
	    'foregroundcolor',RGB_text,...
	'Tag','menu_visualize');
h2 = uimenu('Parent',h1,...
	    'label','Component ROAs',...
	    'foregroundcolor',RGB_text,...
	    'tag','visualize_component_roas');
h3 = uimenu('Parent',h2, ...
	'Callback','map_on_fmri2', ...
	'Label','On Functional Images', ...
	    'foregroundcolor',RGB_text,...
	'Tag','visualize_component_roas_functional');
h3 = uimenu('Parent',h2, ...
	'Callback','map_on_struc2', ...
	'Label','On Structural Images', ...
	    'foregroundcolor',RGB_text,...
	'Tag','VisualizationMapStructural');
h2 = uimenu('Parent',h1, ...
	'Callback','roaproj_ui', ...
	'Label','ROA Time Courses', ...
	    'foregroundcolor',RGB_text,...
	'Tag','Visualization_ROAProjection');
h2 = uimenu('parent',h1,...
	    'label','Dominant Voxel ROAs',...
	    'foregroundcolor',RGB_text,...
	    'tag','visualize_dominatecomp');
h3 = uimenu('Parent',h2, ...
	'Callback','roamap_ui', ...
	'Label','By Max. Z-Value', ...
	    'foregroundcolor',RGB_text,...
	'Tag','Visualization_TilingBrainZ');
h3 = uimenu('Parent',h2, ...
	'Callback','pvafmap_ui', ...
	'Label','By Max. PVAF', ...
	    'foregroundcolor',RGB_text,...
	'Tag','Visualization_TilingBrainPVAF');
h2 = uimenu('Parent',h1, ...
	'Callback','export_result', ...
	    'separator','on',...
	    'foregroundcolor',RGB_text,...
	'Label','Export Selected Comps', ...
	'Tag','Visualization_ExportResult');
h2 = uimenu('parent',h1,...
	    'label','Normalize Selected ROAs',...
	    'foregroundcolor',RGB_text,...
	    'callback','fmrlab_normalize',...
	    'tag','visualize_spatialnormalization');
h2 = uimenu(h1,...
	    'label','Display ROA as in SPM',...
	    'foreground',RGB_text);
h3 = uimenu('parent',h2,...
	    'label','On glass brain',...
	    'foregroundcolor',RGB_text,...
	    'callback','show_mip',...
	    'tag','visualize_mip');
h3 = uimenu('parent',h2,...
	    'label','On normalized slices',...
	    'foregroundcolor',RGB_text,...
	    'callback','show_2d',...
	    'tag','visualize_2d');
h3 = uimenu('parent',h2,...
	    'label','On 3D brain template',...
	    'foregroundcolor',RGB_text,...
	    'callback','show_3d',...
	    'tag','visualize_3d');
%h2 = uimenu('parent',h1,...
%  'label', 'Label Brain Areas',...
%  'foregroundcolor',RGB_text,...
%  'callback','label_brain_area',...
%  'tag','visualize_label_brain_area');
h2 = uimenu('parent',h1,...
	    'label','Clear Workspace',...
	    'foregroundcolor',RGB_text,...
	    'tag','visualize_clear',...
	    'separator','on',...
	    'callback','clear_workspace');
h1 = uimenu(...
    'parent',h0,...
    'label','Help',...
    'foregroundcolor',RGB_text);
h2 = uimenu(...
    'parent',h1,...
    'label','About FMRLAB',...
    'foregroundcolor',RGB_text);
h2 = uimenu(...
    'parent',h1,...
    'label','About FMRLAB help',...
    'foregroundcolor',RGB_text);
h2 = uimenu(...
    'parent',h1,...
    'label','FMRLAB license',...
    'foregroundcolor',RGB_text);
h2 = uimenu(...
    'parent',h1,...
    'label','FMRLAB menus',...
    'foregroundcolor',RGB_text,...
    'separator','on');
h2 = uimenu(...
    'parent',h1,...
    'label','FMRLAB functions',...
    'foregroundcolor',RGB_text);
h2 = uimenu(...
    'parent',h1,...
    'label','Tutorial (web)',...
    'foregroundcolor',RGB_text);
h2 = uimenu(...
    'parent',h1,...
    'label','Contact us (email)',...
    'foregroundcolor',RGB_text);

h0 = findobj('name','FMRLAB v2.2');
pos = get(h0,'position');
h1 = uicontrol(...
    'parent',h0,...
    'units','normalized',...
    'backgroundcolor',RGB_background,...
    'position',[5 5 pos(3)-5 pos(4)-5],...
    'style','frame');
pos = get(h1, 'position');
h2 = uicontrol('Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_background, ...
	       'foregroundcolor',RGB_text,...
	'HorizontalAlignment','left', ...
	'ListboxTop',0, ...
	'Position',[pos(1)+5 pos(2)+5 pos(3)-10 (pos(4)-15)/3], ...
	'Style','text', ...
	'Tag','text1',...
	       'fontsize',text_size,...
	       'fontweight','bold');
tx = sprintf('\nNo Current Dataset\n\n  Select in menu:\n');
tx = [tx sprintf('     Dataset > Create Dataset, or\n')];
tx = [tx sprintf('     Dataset > Load Dataset')];
set(h2,'string',tx);
pos = get(h2,'position');
h2 = uicontrol('Parent',h0, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_background, ...
	       'foregroundcolor',RGB_text,...
	'HorizontalAlignment','left', ...
	'ListboxTop',0, ...
	'Position',[pos(1) pos(2)+pos(4) pos(3) 2*pos(4)], ...
	'Style','text', ...
	'Tag','text2',...
	       'fontsize',text_size,...
	       'fontweight','bold');
tx = sprintf('\nWelcome to FMRLAB 2.2\n\n');
tx = [tx sprintf(['  FMRLAB is a toolbox for fMRI data analysis' ...
		  ' using\n'])];
tx = [tx sprintf(['  Independent Component Analysis (ICA). ICA' ...
		  ' decomposes \n'])];
tx = [tx sprintf(['  fMRI time series into a sum of signal components' ...
		  ' having\n'])];
tx = [tx sprintf(['  maximally spatially independent maps and'...
		  ' unconstrained\n'])];
tx = [tx sprintf(['  time courses. Its data adaptive approach makes ICA' ...
		  ' useful\n'])];
tx = [tx sprintf(['  for characterizing data from any fMRI experimental' ...
		  ' design.\n\n'])];
tx = [tx sprintf('  For more information\n')];
tx = [tx sprintf('  - Manual: FMRLAB Quick Start (>>quickstart)\n')];
tx = [tx sprintf('  - Web: http://www.sccn.ucsd.edu/fmrlab/\n')];
tx = [tx sprintf('  - Email: fmrlab@sccn.ucsd.edu\n\n')];
tx = [tx sprintf('  Feedback Welcome: Email fmrlab@sccn.ucsd.edu\n')];

set(h2,'string',tx);
%h1 = uicontrol('Parent',h0, ...
%	'Units','points', ...
%	'BackgroundColor',RGB_background, ...
%	       'foregroundcolor',RGB_text,...
%	'ListboxTop',0, ...
%	'Position',[8 3 340 23], ...
%	'Style','edit', ...
%	'Tag','edit1');
set(h0, 'units','normalized');
if nargout > 0, fig = h0; end
