% fmrlab_boosting() - test significance of ROA mean time courses
%                     obtaind by ICA decomposition.
%
% Usage: 
%    >> fmrlab_boosting(filename, comp, z_thre, iter);
%
% Inputs: 
%   filename - data file name (e.g., 'run1.fmr');
%   comp     - component number 
%   z_thre   - threshold of z-value
%   iter     - iterations of boostrapping
%
% Outputs:
%   - the result will be saved in 'compxxx_boosting.mat', where
%   'xxx' is the component number
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: pvaf_vs_thre()

%--
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: fmrlab_boosting.m,v $
% Revision 1.1  2003/02/06 18:59:23  duann
% Initial revision
%

function fmrlab_boosting(filename, comp, z_thre, iter)

h = figure;

load(filename, '-mat');
W = FMRI.icaweight * FMRI.icasphere;
invW = pinv(W);
u = W * FMRI.data;

temp = u(comp, :);
temp = (temp-mean(temp))/std(temp);
ii = find(temp > z_thre);
ii2 = 1:size(FMRI.data,2);
ii2(ii) = [];

% Calculating difference between conditions
sum1 = mean(FMRI.data(:,ii)');
sum2 = mean(FMRI.data(:,ii2)');
diff1 = sum1 - sum2;
figure(h);
clf
plot(diff1,'r');
hold on

% using boostraping to test if the difference is
% obtained by chance
diff2 = zeros(iter, size(FMRI.data,1));
for i=1:iter
  % randomly pick ii timecourses as condition 1
  rand_ii = rand(length(ii));
  rand_ii = fmrlab_scale(rand_ii, 1, size(FMRI.data,2));
  rand_ii = round(rand_ii);
  a = diag(rand_ii);
  sum1 = mean(FMRI.data(:,a)');

  % randomly pick ii2 timecourses as condition 2
  rand_ii2 = rand(length(ii2));
  rand_ii2 = fmrlab_scale(rand_ii2, 1, size(FMRI.data,2));
  rand_ii2 = round(rand_ii2);
  a = diag(rand_ii2);
  sum2 = mean(FMRI.data(:,a)');
  
  diff2(i,:) = sum1-sum2;
end
    
mean_diff2 = mean(diff2);
std_diff2 = std(diff2);
plot(mean_diff2,'b');
plot(mean_diff2-std_diff2,'g.');
plot(mean_diff2+std_diff2,'g.');
ti = title(['Component ' num2str(comp) ': (Threshold = ' num2str(z_thre) ...
	   ')']);
if isunix,
    text_size = 14;
else
    text_size = 12;
end
set(ti,'fontsize',text_size);