% fmrlab_color() - specify the colormap used to display the functional
%                region of activity (ROA). 
%
% Usage: 
%   >> cmap = fmrlab_color(met, colors);
%
% Inputs: 
%   met - integer (1 - 5) used to specify the method to set the
%         colormap, default = 2
%
% Optional Inputs:
%   colors - user defined colormap (N by 3) matrix
%
% Outputs: 
%    cmap - output colormap matrix
%
% Author: Jeng-Ren Duann, CNL/Salk. Inst., 2001-10
%
% See also: colormap(), image(), imagesc()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: fmrlab_color.m,v $
% Revision 1.1  2003/02/06 18:59:34  duann
% Initial revision
%

function cmap = fmrlab_color(met, colors)

if met == 1
   tmp = zeros(64, 3);
   a = linspace(1,0.3,32);
   tmp(1:32, 3) = a';
   a = linspace(0.3,1,32);
   tmp(33:64, 1) = a';
   cmap = [gray(64); tmp]; 
   colormap(cmap);
end

if met == 5
   tmp = zeros(64, 3);
   a = linspace(0.2,1,64);
   tmp(1:64, 1) = a';
   cmap = [gray(64); jet(64)];
   colormap(cmap);
end

if met == 2
   tmp = zeros(64, 3);
   a = linspace(0.2,1,64);
   tmp(1:64, 1) = a';
   a = jet(64);
   b = zeros(size(a));
   for i=1:28
     b(i,:) = a(32-i+1,:);
   end
   j = 0;
   for i=37:64
     b(i,:) = a(64-j,:);
     j = j+1;
   end
   a = [gray(64); b];
   % adjust the warm color
   a(126:128,1) = 1;
   b = linspace(0.0625,1.000,20);
   a(109:128,2) = b';
   a(125:128,3) = 0;
   %adjust the cold color
   a(65:92,3) = 1;
   b = linspace(1,0,28);
   a(65:92,2) = b';
   %a(79:95,2) = 0;
   a(65:92,1) = 0;
   b = linspace(1,0.4,20);
   a(73:92,3) = b';
   cmap = a;
   colormap(cmap);
end

if met == 3
  tmp = zeros(64, 3); 
  cmap = [gray(64); jet(64)];
  colormap(cmap);
end

if met == 4
  tmp = zeros(64, 3);
  gap = fix(64/colors);
  b = [];
  for i=1:colors
    a = linspace(0.3, 1, gap);
    switch(i)
      case 1
        tmp(1+(i-1)*gap:i*gap, 1) = a';
      case 2
        tmp(1+(i-1)*gap:i*gap, 2) = a';
      case 3
        tmp(1+(i-1)*gap:i*gap, 3) = a';
      case 4
        tmp(1+(i-1)*gap:i*gap, 1) = a';
        tmp(1+(i-1)*gap:i*gap, 2) = a';
      case 5
        tmp(1+(i-1)*gap:i*gap, 1) = a';
        tmp(1+(i-1)*gap:i*gap, 3) = a';
      case 6
        tmp(1+(i-1)*gap:i*gap, 2) = a';
        tmp(1+(i-1)*gap:i*gap, 3) = a';
    end
  end
  cmap = [gray(64); tmp];
  colormap(cmap);
end
