% fmrlab_normalize() - 3D spatial normalization by interfacing with
%                      SPM normalization routines.
%
% Usage: fmrlab_normalize();
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: spm_normalize(), fmrlab_render(), show_mip(),
%           show_2d(), show_3d()
%
% Notes: - This function is adapted from SPM 3D normalization
%          routines (http://fil.ion.ucl.ac.uk/spm).
%        - This functions 3D normalizes the structural image (T1)
%          to the standard template provided by SPM99 and applies the
%          transferring parameters to the exported selected ROA in
%          ANALYZE format.
%        - This function will do the normalization automatically,
%          however, the default settings might not be able to
%          give the best result for the 3D normalization.
%        - The misalignment of the functional (or ROA) images to
%          the structural images due to the subject's movement is not
%          accounted in this function.
%        - Valid overlay display of resulting ROA on top of
%          normalized 2D structural images or 3D rendering brain
%          template is not always guaranteed
%        - All the parameters, please refer to SPM99.
%

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: fmrlab_normalize.m,v $
% Revision 1.1  2003/02/06 19:00:31  duann
% Initial revision
%

function fmrlab_normalize()
 
a = which('fmrlab');
for i=length(a):-1:1,
  if a(i) == '/' | a(i) == '\',
    break;
  end
end
a = a(1:i);

str = ['Select the structural image file in Analyze format (str_*' ...
       ' .img).'];
strucname = spm_get(1,'*.img',str);

spm_smooth(strucname, 'spm_sn3d_tmp.img', [4 5 4]);
VF = spm_vol('spm_sn3d_tmp.img');
VG = spm_vol([a 'T1.img']);
gl = spm_global(VF);
VF.pinfo(1:2,:) = VF.pinfo(1:2,:)/gl;
gl = spm_global(VG);
VG.pinfo(1:2,:) = VG.pinfo(1:2,:)/gl;

global sptl_Ornt 
sptl_Ornt = [0 0 0 0 0 0 1 1 1 0 0 0];

p1 = spm_affsub3('affine3',VG,VF,1,8);
p1 = spm_affsub3('affine3',VG,VF,1,4,p1);

% save results
prms = p1(1:12);
Affine = inv(inv(VG.mat) * spm_matrix(prms') * VF.mat);
Transform = [];
Dims = [VG.dim(1:3); 0 0 0];
MF = VF.mat;
MG = VG.mat;
vox = sqrt(sum(MG(1:3,1:3).^2));
origin = MG\[0 0 0 1]';
origin = round(origin(1:3)');
Dims = [Dims; vox; origin; VF.dim(1:3); sqrt(sum(MF(1:3,1:3).^2))];
mgc = 960209;
save('sn.mat','mgc','Affine','Dims','Transform','MF','MG');

% select roa images to apply the affine transformation to
str = ['Select the component ROA image file(s) in Analyze format' ...
       ' (roa_*.img).'];
P = spm_get([],'*.img',str);
bb = [-78 -112 -50; 78 76 85];
vox = [2 2 2];
spm_write_sn(P,'sn.mat',bb,vox,1);


