% get_status() - get the current stauts of the FMRI data set from
%                the input string (FMRI.processed)
% 
% Usage: 
%   >> str = get_status(str_in);
% 
% Inputs:
%   str_in - input string, it's normally the 'processed' field of
%            FMRI data structure
%
% Outputs:
%   str - output string, which indicate the current status of the
%         FMRI data set.
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: set_global_fmri_ui()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: get_status.m,v $
% Revision 1.1  2003/02/06 19:01:07  duann
% Initial revision
%

function str = get_status(str_in)

if isempty(findstr(str_in,':')),
    str = str_in;
    return;
end

for i=length(str_in):-1:1,
  if str_in(i) == ':',
    break;
  end
end

str = str_in(i+1:length(str_in));
