% label_z() - Export z values of highly participating voxels 
%             in component ROAs
%
% Usage:
%   >> label_z(thre);
%
% Inputs:
%   thre - threshold in z value to make component ROA
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2003
%
% See also: fmrlab_normalize(), spm_affsub3(), show_3d(), show_mip()
%
% Notes: - Must have structural images to perform the spatial
%          normalization process.
%        - show_2d() only works on normalized ICA component maps
%          (or ROAs) and structural images.
%        - The accuracy of the spatial normalization process
%          heavily depends on the image quality and slice
%          number. Thus, the validity of the results of show_2d()
%          cannot be guaranteed. 
        
% --
% Copyright (C) 2003 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: label_z.m,v $
% Revision 1.1  2003/02/06 19:01:22  duann
% Initial revision
%

function label_z(thre)
  
  if nargin < 1,
    thre = 2.0;
  end
  
  RGB_mainwin = [1 .984 .895];

  disp('Select the maps you want to label...');
  map_name = spm_get([], 'nroa_*.img', 'Get Normalized ROA file');
  if isequal(map_name,0),
    fmrlab_messagedlg('Label Brain Areas',...
		      'Warning:',...
		      ['To export normalized ROA image files, see: '...
		       'Visualize > Export Selected Comps']);
    return;
  end

  for i=1:size(map_name,1);
    fp = fopen(map_name(i,:),'rb','ieee-le');
    if fp == -1,
      %errordlg('Cannot open map file...!');
      fmrlab_messagedlg('Label Brain areas',...
			'Error:',...
			'Cannot open map file');
      return;
    end
    data = fread(fp,'float');  
    fclose(fp);
  
    ii = find(data >= thre);
    length(ii)
    for j=length(map_name(i,:)):-1:1,
      if map_name(i,j) == '.',
	break;
      end
    end
    target_name = [map_name(i,1:j-1) '_pos_Z.txt']
    fp = fopen(target_name,'w');
    for j=1:length(ii),
      fprintf(fp,'%d, %5.2f\n', j-1,data(ii(j)));
    end
    fclose(fp);
    
    ii = find(data <= -thre);
    length(ii)
    for j=length(map_name(i,:)):-1:1,
      if map_name(i,j) == '.',
	break;
      end
    end
    target_name = [map_name(i,1:j-1) '_neg_Z.txt']
    fp = fopen(target_name,'w');
    for j=1:length(ii),
      fprintf(fp,'%d, %5.2f\n', j-1,data(ii(j)));
    end
    fclose(fp);
  end

  