% map_on_fmri3() - component browser by overlaying ROA onto 2D
%                 slices of functional images with interactive 
%                 graphic user interface
%
% Usage:
%   >> map_on_fmri3(action)
%
% Inputs:
%   action - specifying action for the browse window to perform,
%            the value can be:
%          - 'init': constructing all elements in GUI and linking all events
%          - 'backward': switch the currently displayed component to the 
%                        previous one
%          - 'foreward': switch the currently displayed component to the 
%                        next one
%          - 'refresh': redraw the entire component browser (including the 
%                       time course and bold image plot window, if applicable)
%          - 'goto_select_list': switch the currently displayed component to 
%                                the one indicated in select-component list
%          - 'add_select': add the currently displayed component to select-
%                          component list
%          - 'remove_select': remove the currently displayed component from 
%                             the select-component list indicated 
%          - 'goto_reject': switch the currently displayed component to the one
%                           indicated in the reject-component list
%          - 'add_reject': add the currently displayed component to reject-
%                          component list
%          - 'remove_reject': remove the currently displayed component from
%                             the reject-component list
%          - 'op_clicked': 'operations' buttons selected
%          - 'pgdn': page down button pressed.
%          - 'pgup': page up button pressed.
%
% Outputs:
%
% Author: Jeng-Ren Duann, SCCN/INC/UCSD & CNL/Salk Inst., 2003
%
% See also: map_on_struc3(), boldimage(), cbar()
%
% Notes: - map_on_struc() might need interpolation to make the ROA
%          the same coordinates with structural images. Thus, it might take
%          longer to browse component maps. It's highly recommended to use
%          map_on_fmri() first to add component of interest into the
%          selection list, then to use map_on_struc() to browse the selected
%          component only

% Copyright (C) 2003 Jeng-Ren Duann, SCCN/INC/UCSD, duann@sccn.ucsd.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: map_on_fmri3.m,v $
%

function map_on_fmri3(action)

global FMRI

if length(FMRI) == 0,
    fmrlab_messagedlg('map_on_fmri3()',...
	    'Error:',...
		['No current data set exists. Please load a ''.fmr''' ...
		' data file first.']);
    return;
end

if isempty(FMRI.icaweight),
    fmrlab_messagedlg('map_on_fmri3()',...
        'Error:',...
        'No ICA results available, please run ICA first');
    return;
end

if nargin < 1,
  action = 'init';
end
  
RGB_mainwin = [1 .984 .895];
RGB_background = [0.860 0.824 0.618];
RGB_button = [0.860 0.824 0.618]; 
RGB_text = [0.333 0.283 0.003];

text_size = 12;
cap_size = 14;

switch(action)
 case 'init'
  f_roa = findobj('name',['Display Component ROA on Functional' ...
		    ' Variance Images']);
  if isempty(f_roa),
    % making control panel
    pos = [50 280 150 488];
    f_control = figure(...
	'name', 'Control', ...
	'numbertitle','off',...
	'color',RGB_mainwin,...
	'menubar','none',...
	'position',pos,...
	'backingstore','off',...
	'deletefcn','map_on_fmri3(''close'');');
    pos = [5 465 140 25];
    h1 = uicontrol(...
	'style','text',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_mainwin, ...
	'FontSize',cap_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','left',...
	'String','Browse');
    pos = [5 445 70 25];
    h1 = uicontrol(...
	'style','pushbutton' ,...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','center',...
	'String','<',...
	'callback','map_on_fmri3(''prev'');');
    pos = [75 445 70 25];
    h1 = uicontrol(...
	'style','pushbutton',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','center',...
	'String','>',...
	'callback','map_on_fmri3(''next'');');
    pos = [5 420 140 25];
    h1 = uicontrol(...
	'style','edit',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_mainwin, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','center',...
	'String','1',...
	'tag','ed_comp',...
	'callback','map_on_fmri3(''goto_comp'');');
    % buttons for selecting component
    pos = [5 390 140 25];
    h1 = uicontrol(...
	'style','text',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_mainwin, ...
	'FontSize',cap_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','left',...
	'String','Select Comp');
    pos = [5 370 70 25];
    h1 = uicontrol(...
	'style','pushbutton',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','center',...
	'String','Mark',...
	'callback','map_on_fmri3(''mark_select'');');
    pos = [75 370 70 25];
    h1 = uicontrol(...
	'style','pushbutton',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','center',...
	'String','UnMark',...
	'callback','map_on_fmri3(''unmark_select'');');
    pos = [5 345 140 25];
    h1 = uicontrol(...
	'style','popupmenu',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_mainwin, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'string','0',...
	'Tag','select_list',...
	'callback','map_on_fmri3(''goto_select'');');
    if length(FMRI.icacomp) ~= 0,
      set(h1,'string',num2str(FMRI.icacomp));
    end
    % buttons for rejecting component
    pos = [5 320 140 25];
    h1 = uicontrol(...
	'style','text',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_mainwin, ...
	'FontSize',cap_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','left',...
	'String','Reject Comp');
    pos = [5 300 70 25];
    h1 = uicontrol(...
	'style','pushbutton',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','center',...
	'String','Mark',...
	'callback','map_on_fmri3(''mark_reject'');');
    pos = [75 300 70 25];
    h1 = uicontrol(...
	'style','pushbutton',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_button, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'horizontalalign','center',...
	'String','UnMark',...
	'callback','map_on_fmri3(''unmark_reject'');');
     pos = [5 275 140 25];
     h1 = uicontrol(...
	'style','popupmenu',...
	'Parent',f_control, ...
	'Units','pixels', ...
	'BackgroundColor',RGB_mainwin, ...
	'FontSize',text_size, ...
	'ForegroundColor',RGB_text, ...
	'Position',pos, ...
	'string','0',...
	'Tag','reject_list',...
	'callback','map_on_fmri3(''goto_reject'');');
    if length(FMRI.rejcomp) ~= 0,
      set(h1,'string',num2str(FMRI.icacomp));
    end
   
    % making roa window
    pos = [205 280 500 488];
    f_roa = figure(...
	'name', 'Display Component ROA on Functional Variance Images', ...
	'numbertitle','off',...
	'color',RGB_mainwin,...
	'menubar','none',...
	'position',pos,...
	'backingstore','off',...
	'resize','off',...
	'deletefcn','map_on_fmri3(''close'');');
    pos = [470 10 20 300];
    h1 = axes(...
	'Parent',f_roa, ...
	'units','pixels',...
	'position',pos,...
	'Color',RGB_mainwin,...
	'box','on',...
	'Tag','cb',...
	'xtick',[],...
	'xticklabel',[],...
	'ytick',[],...
	'yticklabel',[]);
    % plot colorbar
    cb = linspace(65,128,64);
    cb = cb';
    b = repmat(cb,1,5);
    kk = image(flipud(b));
    set(h1,'xtick',[]);
    set(h1,'ytick',linspace(1,64,10));
    cb = linspace(8.0,1.5,5);
    cb = [cb linspace(-1.5,-8.0,5)];
    cb = num2str(cb','%4.1f');
    i = [2:4 7:9];
    for j=1:size(cb,2),
      cb(i,j) = ' ';
    end
    set(h1,'yticklabel',cb);
    fmrlab_color(2);
    cb = h1;
    pos = [10 10 460 468];
    ax = axes(...
	'Parent',f_roa, ...
	'units','pixels',...
	'position',pos,...
	'Color','k',...
	'box','on',...
	'Tag','cb',...
	'xtick',[],...
	'xticklabel',[],...
	'ytick',[],...
	'yticklabel',[]);
    userdata.ax = ax;
    userdata.cb = cb;
    set(f_roa,'userdata',userdata);
    %display_component_map;
    
    % making time course window
    pos = [50 50 655 200];
    f_time = figure(...
	'name', 'Time Course', ...
	'numbertitle','off',...
	'color',RGB_mainwin,...
	'menubar','none',...
	'position',pos,...
	'backingstore','off',...
	'deletefcn','map_on_fmri3(''close'');');
    
  end
  
 case 'close'
  
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  
function display_component_map()
global FMRI
RGB_mainwin = [1 .984 .895];
RGB_background = [0.860 0.824 0.618];
RGB_button = [0.860 0.824 0.618];
RGB_text = [0.333 0.283 0.003];
if isunix,
    text_size = 14;
else
    text_size = 12;
end
f_roa = findobj('name',['Display Component ROA on Functional' ...
    ' Variance Images']);
if f_main == 0,
    disp('Cannot find main window');
    return;
end
userdata = get(f_roa,'userdata');
% form base image
avg_image = sqrt(std(FMRI.data));
base_image = zeros(FMRI.dime_x*FMRI.dime_y*FMRI.dime_z,1);
for i=1:length(FMRI.idx),
    base_image(FMRI.idx(i)) = avg_image(i);
end
base_image = fmrlab_scale(base_image,1,64);

% find the displaying parameters
a = findobj(f_main,'tag','ed_thre');
uthre = str2num(get(a,'string'));
lthre = -1 * uthre;
a = findobj(f_main,'tag','ed_lim');
ulim = str2num(get(a,'string'));
llim = -1 * ulim;
% update ticks of colorbar
cb = linspace(ulim,uthre,5);
cb = [cb linspace(lthre,llim,5)];
cb = num2str(cb','%4.1f');
i = [2:4 7:9];
for j=1:size(cb,2),
    cb(i,j) = ' ';
end
set(userdata.cb,'yticklabel',cb);
  
% get current component
a = findobj(f_control,'tag','ed_component');
comp = str2num(get(a,'string'));
% calculating component map
W = FMRI.icaweight * FMRI.icasphere;
invW = pinv(W);
u = W * FMRI.data;
temp_data = u(comp, :);
mean_temp_data = mean(temp_data);
std_temp_data = std(temp_data);
temp_data = (temp_data-mean_temp_data)/std_temp_data; %convert to z score
uidx = find(temp_data >= ulim);
temp_data(uidx) = ulim;
uidx = find(temp_data >= uthre);
umap = zeros(length(temp_data),1);
umap(uidx) = temp_data(uidx);
umap(uidx) = fmrlab_scale(umap(uidx),101,128,uthre,ulim);
map = zeros(FMRI.dime_x*FMRI.dime_y*FMRI.dime_z,1);
for i=1:length(FMRI.idx),
    map(FMRI.idx(i)) = umap(i);
end
img = max(base_image,map);

lidx = find(temp_data <= llim);
temp_data(lidx) = llim;
lidx = find(temp_data <= lthre);
lmap = zeros(length(temp_data),1);
lmap(lidx) = temp_data(lidx);
lmap(lidx) = fmrlab_scale(lmap(lidx),65,92,llim,lthre);
map = zeros(FMRI.dime_x*FMRI.dime_y*FMRI.dime_z,1);
for i=1:length(FMRI.idx),
    map(FMRI.idx(i)) = lmap(i);
end
img = max(img,map);
img = reshape(img,FMRI.dime_x,FMRI.dime_y,FMRI.dime_z);

% display component maps
%ii = min((userdata.start_slice-1)+15,FMRI.dime_z);
%pp = 1;
%for i=userdata.start_slice:ii
%    axes(userdata.ax(pp));
%    image(real(img(:,:,i))');
%    axis off
%    axis image
%    pp = pp +1;
%end
img2 = zeros(FMRI.dime_y,FMRI.dime_x,1,FMRI.dime_z);
for i=1:FMRI.dime_z,
  temp = reshape(img(:,:,i),FMRI.dime_x,FMRI.dime_y);
  img2(:,:,1,i) = temp;
end
axes(userdata.ax);
montage(img2,fmrlab_color(2));

return;

% update the title bar according to the current component
a = findobj(f_main,'tag','title_string');
set(a,'string',['Independent Component #' num2str(comp)]);

% display time couse and bold image plots if specified
a = findobj(f_main,'tag','list_tc');
b = get(a,'value');
  
% display time course if b ~= 1
if b~=1,
    % calculate back-projected component time course and
    % + ROA mean time course
    ddd = zeros(size(invW,1),size(u,2));
    ddd = invW(:,comp) * u(comp,:);
    ddd = ddd(:,uidx)';
    bpctc = mean(ddd);
    ddd = FMRI.data(:,uidx);
    ddd = mean(ddd');
    bpctc = 100 * (bpctc-mean(bpctc)) / (mean(ddd));
    roatc = 100 * (ddd-mean(ddd))/(mean(ddd));

    % clean up the memory space before displaying figures
    clear u, invW;
    
    f_time = findobj('name','Component Time Courses');
    if isempty(f_time),
        pos = [5 40 735 200];
        f_time = [];
        f_time = figure(...
            'position',pos,...
            'numbertitle','off',...
            'menubar','none',...
            'color',RGB_mainwin,...
            'name','Component Time Courses');
    else
        figure(f_time);
        clf;
    end
    
    switch(b)
    case 2,
        if isempty(FMRI.tr) | FMRI.tr == 0,
	        plot(bpctc);
            set(gca,'fontsize',text_size);
	        xlabel('Scan Number');
       else
	        x1 = linspace(FMRI.tr,FMRI.timepoint*FMRI.tr,FMRI.timepoint);
	       plot(x1,bpctc);
	        set(gca,'fontsize',text_size);
        xlabel('Time (s)');
    end
        pos = get(gca,'position');
        set(gca,'position',[pos(1) pos(2)+pos(4)*0.1 pos(3) pos(4)*0.9]);
        legend('Comp. proj. to +ROA');
        ylabel('\Delta BOLD Signal (%)');
        set(gca,'ylim',[min(bpctc) max(bpctc)]);
        set(gca,'ytick',[min(bpctc) 0 max(bpctc)]);
        
    case 3,
        if isempty(FMRI.tr) | FMRI.tr == 0,
	        plot(roatc,'r');
	        set(gca,'fontsize',text_size);
	        xlabel('Scan Number');
        else
	        x1 = linspace(FMRI.tr,FMRI.timepoint*FMRI.tr,FMRI.timepoint);
	        plot(x1,roatc,'r');
	        set(gca,'fontsize',text_size);
	        xlabel('Time (s)');
        end
        pos = get(gca,'position');
        set(gca,'position',[pos(1) pos(2)+pos(4)*0.1 pos(3) pos(4)*0.9]);
        legend('+ROA mean time course');
        ylabel('\Delta BOLD Signal (%)');
        set(gca,'ylim',[min(roatc) max(roatc)]);
        set(gca,'ytick',[min(roatc) 0 max(roatc)]);
            
    case 4,
        if isempty(FMRI.tr) | FMRI.tr == 0,
	        plot(bpctc);
	        hold on
	        plot(roatc,'r');
	        set(gca,'fontsize',text_size);
	        xlabel('Scan Number');
        else
	        x1 = linspace(FMRI.tr,FMRI.timepoint*FMRI.tr, ...
		        FMRI.timepoint);
	        plot(x1,bpctc);
	        hold on
	        plot(x1,roatc,'r');
	        set(gca,'fontsize',text_size);
	        xlabel('Time (s)');
        end
        pos = get(gca,'position');
        set(gca,'position',[pos(1) pos(2)+pos(4)*0.1 pos(3) pos(4)*0.9]);
        legend('Comp. proj. to +ROA','+ROA mean time course');
        ylabel('\Delta BOLD Signal (%)');
        set(gca,'ylim',[min(min(roatc),min(bpctc))...
		    max(max(roatc),max(bpctc))]);
        set(gca,'ytick',[min(min(roatc),min(bpctc))...
		    0 max(max(roatc),max(bpctc))]);
        v = 100*((1-var(roatc-bpctc)/var(roatc)));
        %ti = text(0.75*max(x1),...
        %    1.2*min(str2num(get(gca,'yticklabel'))),...
        %    [sprintf('p.v.a.f. = %5.2f',v) '%']);
        ti = textsc(0.85,0.05,[sprintf('p.v.a.f. = %5.2f',v) '%']);
        set(ti,'fontsize',text_size,'color',[1 0 1]);

    
    case 5,
        if isempty(FMRI.tr) | FMRI.tr == 0,
	        plot(bpctc);
	        set(gca,'fontsize',text_size);
	        xlabel('Scan Number');
        else
	        x1 = linspace(FMRI.tr,FMRI.timepoint*FMRI.tr,FMRI.timepoint);
	        plot(x1,bpctc);
	        set(gca,'fontsize',text_size);
	        xlabel('Time (s)');
        end
        pos = get(gca,'position');
        set(gca,'position',[pos(1) pos(2)+pos(4)*0.1 pos(3) pos(4)*0.9]);
        legend('Comp. proj. to +ROA');
        ylabel('\Delta BOLD Signal (%)');
        set(gca,'ylim',[min(bpctc) max(bpctc)]);
        set(gca,'ytick',[min(bpctc) 0 max(bpctc)]);
       
        % find bold image plot window
        f_bold = findobj('name','BOLD Image Plot');
        if isempty(f_bold),
            pos = [750 40 270 350];
            f_bold = [];
            f_bold = figure(...
                'position',pos,...
                'numbertitle','off',...
                'menubar','none',...
                'color',RGB_mainwin,...
                'name','BOLD Image Plot');
        else
            figure(f_bold);
            clf;
        end
       
        % enter FMRI.soa if missing
        if length(FMRI.soa) == 0,
	        prompt = {'Trial onsets (scan numbers):',...
		        'Trial scans (in scans):'};
	        defs = {num2str(FMRI.soa), num2str(FMRI.trial_length)};
	        BOLD_err = 0;
	        a = fmrlab_inputdlg(prompt,'BOLD-image plot parameters',1,defs);
	        if ~isempty(a),
	            FMRI.soa = str2num(char(a(1)));
	            if length(FMRI.soa)==1 | length(FMRI.soa)==0,
	                fmrlab_messagedlg('Component ROAs on fMRI',...
			            'Error:',...
			            'Too few trials');
	                BOLD_err = 1;
	            end
   
	            for i=1:length(FMRI.soa),
	            if FMRI.soa(i) > FMRI.timepoint | FMRI.soa(i) < 1,
	                fmrlab_messagedlg('Component ROAs on fMRI',...
				        'Error:',...
				        'Onset scan number exceeds total scan number');
	                BOLD_err = 1;
	                break;
	            end
	        end
	   
	        FMRI.trial_length = str2num(char(a(2)));
	        if FMRI.trial_length == 0,
	            fmrlab_messagedlg('Component ROAs on fMRI',...
			        'Error:',...
			        'Trial length cannot be zero');
	            BOLD_err = 1;
	        end
	   
	        for i=1:length(FMRI.soa),
	            temp = FMRI.trial_length + FMRI.soa(i) - 1;
	            if temp > FMRI.timepoint,
	                fmrlab_messagedlg('Component ROAs on fMRI',...
				        'Error:',...
				        'Trial length exceeds the total scan number');
	                BOLD_err = 1;
	                break;
	            end
	        end
	    else      
	        BOLD_err = 1;
    end
       
	    if BOLD_err == 1,
	        a = findobj(f_main,'tag','list_tc');
	        set(a,'value',1);
	        close(f_time);
	        close(f_bold);
	        return;
        end
    end
	          
    a = []; 
    for i=1:length(FMRI.soa),
	    a = [a bpctc(FMRI.soa(i):FMRI.soa(i)+FMRI.trial_length-1)];
    end
    boldimage(a,ones(length(FMRI.soa),1),...
		 0:FMRI.tr:FMRI.tr*(FMRI.trial_length-1),...
		 ['Component #' num2str(comp)],1,1,'erp','nosort','noplot','cbar');
end
 
end
  