% modify_param() - modify the parameters of (1) fMRI acquisition
%                  and (2) displaying BOLD image
%
% Usage: 
%   >> modify_param(met);
%
% Inputs:
%   met - specify the parameter set to be modified, the value can
%         be:
%       - 'fMRI': modifying fMRI acquisition parameters, e.g.,
%         image width, image height, slice thinkness, TR, etc.
%       - 'BOLD': modifying the necessary parameters for displaying
%         BOLD image
%
% Outputs:
%
% Author: Jeng--Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD,2002
%
% See also: modify_struc_info(), set_fmri_global_ui()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: modify_param.m,v $
% Revision 1.1  2003/02/06 19:10:16  duann
% Initial revision
%

function modify_param(met)

% Input: 
%   met - which set of parameters needs to be changed
%         ('fMRI' - fmri parameters; 'BOLD' - parameters for BOLD image plot)
%
% Jeng-Ren Duann, CNL/Salk Inst., 2001-11-08

global FMRI
global hwnd

if length(FMRI) == 0,
  %errordlg('Data set not loaded...!');
  fmrlab_messagedlg('Modify Parameters',...
		'Error:',...
		'No dataset loaded');
  return;
end

if met == 'fMRI',
  prompt = {'Image Width (in pixels):',...
	  'Image Height (in pixels):', ...
          'Image Depth (number of slices):', ...
	  'Field of View (FOV) on X-axis (|left-right|, mm):', ...
          'Field of View (FOV) on Y-axis (|ant-post|, mm):', ...
	  'Slice thickness including gap (mm):', ...
          'Number of scans (total):', ...
	  'Number of initial (dummy) scans to remove:', ...
	  'TR (inter-scan interval, in sec):'};
  defs = {num2str(FMRI.dime_x), ...
	  num2str(FMRI.dime_y), ...
	  num2str(FMRI.dime_z),...
          num2str(FMRI.fov_x), ...
	  num2str(FMRI.fov_y), ...
	  num2str(FMRI.slicetk),...
          num2str(FMRI.dummy+FMRI.timepoint), ...
	  num2str(FMRI.dummy), ...
	  num2str(FMRI.tr)};
  a = fmrlab_inputdlg(prompt, 'Functional Image Information',1,defs);
  if isempty(a),
    %errordlg('Cancelled by user, exit program ...');
    return
  end
  FMRI.dime_x = str2num(char(a(1)));
  FMRI.dime_y = str2num(char(a(2)));
  FMRI.dime_z = str2num(char(a(3)));
  FMRI.fov_x = str2num(char(a(4)));
  FMRI.fov_y = str2num(char(a(5)));
  FMRI.slicetk = str2num(char(a(6)));
  FMRI.dummy = str2num(char(a(8)));
  FMRI.timepoint = str2num(char(a(7))) - FMRI.dummy;
  FMRI.tr = str2num(char(a(9)));
elseif met == 'BOLD',
  prompt = {'SOA:', 'Trial Length:'};
  defs = {num2str(FMRI.soa), num2str(FMRI.trial_length)};
  a = fmrlab_inputdlg(prompt,'Parameter needed for BOLD image plot',1,defs);
   if isempty(a),
    %errordlg('Cancelled by user, exit program ...');
    return
  end
  FMRI.soa = str2num(char(a(1)));
  FMRI.trial_length = str2num(char(a(2)));
end

show_parameters