% mousemoving() - general function to trace the mouse moving in an
%                 image axis and get the position, image intensity
%                 and pressed button number when button pressed.
%
% Usage:
%    [x,y,value,button]=mousemoving(f);
%
% Inputs: 
%    f - handle of image axis
%
% Outputs:
%    x      - x coordinate of the mouse location
%    y      - y coordinate of the mouse location
%    value  - image indensity of the location indicated by mouse
%             when button pressed
%    button - button number pressed
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002-10
%
% See also: ginput()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: mousemoving.m,v $
% Revision 1.1  2003/02/06 19:12:22  duann
% Initial revision
%

function [x,y,value,button]=mousemoving(f)

if isunix,
    text_size = 14;
else
    text_size = 12;
end

old_units_f = get(f,'units');
set(f,'units','pixels');

a = findobj(f,'type','image');
if isempty(a),
  %errordlg('There is no image displayed...');
  fmrlab_messagedlg('Display ROAs',...
		'Error:',...
		'There is no images displayed');
  return;
else
  for i=1:length(a),
    b = get(a(i),'xdata');
    if b(1)~=0,
      b = a(i);
      break;
    end
  end
end

a = get(b,'parent');
old_units_a = get(a,'units');
set(a,'units','pixels');
pos_a = get(a,'position');
offset_x = (pos_a(3)-pos_a(4))/2;
set(b,'buttondownfcn','cb_keydown');
im = get(b,'cdata');
sz = size(im);

global chk
chk = 0;

pre_pt = [0 0];

tx = sprintf('X:    Y:    Component:    ');
axes(a);
h_tx = text(1, sz(2)*1.05,tx);
set(h_tx,'fontsize',text_size);
while chk==0,
  ptr_fig = get(0,'pointerwindow');
  if ptr_fig == f,
    ptr_pos = get(0, 'pointerlocation');
    pos = get(f, 'position');
    pt = [ptr_pos(1)-pos(1) ptr_pos(2)-pos(2)];
    if pt(1)~=pre_pt(1) & pt(2)~=pre_pt(2),
      pre_pt=pt;
      coor(1) = round((pt(1)-pos_a(1)-offset_x)*sz(1)/(pos_a(3)-2*offset_x));
      coor(2) = round(sz(2) + (sz(2)*(pos_a(2)-pt(2))/pos_a(4)));
      if (0<coor(1) & coor(1)<=sz(1)) & (0<coor(2) & coor(2)<=sz(2)),
	figure(f);
        tx = sprintf('X: %3d  Y: %3d  Component: %3f',...
		     coor(1), coor(2), im(coor(2),coor(1)));
	delete(h_tx)
	h_tx = text(1,sz(2)*1.05, tx);
	set(h_tx,'fontsize',text_size);
      end
      
    end
    
  end
end

set(f,'units',old_units_f);
set(a,'units',old_units_a);
delete(h_tx);
x = coor(1);
y = coor(2);
value = im(coor(2),coor(1));
b = get(f,'selectiontype');
if strcmp(b,'alt'),
  button = 3;
elseif strcmp(b,'extend'),
  button = 2;
elseif strcmp(b,'normal'),
  button = 1;
end
