% progressbar() - indicate progress of the running processes
% 
% Usage:
%   >> progressbar(percentage);
%
% Inputs:
%   percentage - percentage of the process running, it's a floating
%                point number between [0,1] and put nan to close
%                this window
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: 
 
% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: progressbar.m,v $
% Revision 1.1  2003/02/06 19:13:08  duann
% Initial revision
%

function progressbar(percent)

% This function is used to indicate the percentage of process perceeding and
% functions as 'system is working' indicator.
% 
% Usage: 
%    >> progressbar(percent)
%
% Input: 
%    percent - percentage of the process running, it's a floating point number
%              between [0,1] and put nan to close this window
%
% Jeng-Ren Duann, CNL/Salk Inst. 2001-10-16

f_progressbar = findobj('name','Progress Bar');
if f_progressbar ~= 0,
  figure(f_progressbar);
  clf
else
  ss = get(0,'screensize');
  f_progressbar = figure(...
	'name', 'Progress Bar',...
	'position',[(ss(3)-300)/2 ss(4)*0.66 300 100],...
	'menubar','none',...
      'toolbar','none',...
      'numbertitle','off',...
	'color',[0.860 0.824 0.618]);
end

if isnan(percent),
  close(f_progressbar);
  return
end

% Draw the background bar
ss = get(f_progressbar,'position');
a = rectangle('position',[(ss(3)-200)/2 (ss(4)-30)/2 200 30]);
axis off
a = get(a,'position');
rectangle('position',[a(1) a(2) 200*percent 30],...
	'facecolor',[0 0 1]);
tt = text(a(1),a(2)-10,'Processing ...');
if isunix,
    text_size = 14;
else
    text_size = 12;
end
set(tt,'fontsize',text_size,'color',[.333 .283 .003]);
