% read_analyze_hdr() - read image header in ANALYZE format (*.hdr)
%
% Usage:
%    >> hdr = read_analyze_hdr(fname);
%
% Inputs:
%    fname - file name of image header (*.hdr)
%
% Outputs:
%    hdr - header information of image
%
% Author: Jeng-Ren Duann, CNL/SALK INST. & SCCN/INC/UCSD, 2001
%
% See also: export_result(), fmrlab_normalize()

%--
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: read_analyze_hdr.m,v $
% Revision 1.1  2003/02/06 19:13:48  duann
% Initial revision
%

function hdr = read_analyze_hdr(fname)
  
% read_analyze_hdr() - This function is used to read the header
% from a specified analyze formatted image (*.hdr)
  
  fp = fopen(fname, 'rb','ieee-be');
  if (fp == -1)
    %errordlg('Cannot open data file...!');
    fmrlab_messagedlg('Read ANALYZE Header',...
		  'Error:',...
		  'Cannot open data file');
    return;
  end
  
  % test the endian of the input file
  size_hdr = fread(fp,1,'int32');
  if size_hdr > 400,
    fclose(fp);
    fp = fopen(fname,'rb','ieee-le');
  else
    fseek(fp,0,-1);
  end
  
  % read (struct) header_key
  %--------------------------------------------------------------------
  size_hdr    = fread(fp,1,'int32');		%sizeof_hdr
  data_type   = char(fread(fp,10,'char')');	%data_type
  db_name     = char(fread(fp,18,'char')');	%db_name
  extents     = fread(fp,1,'int32');		%extents
  session_err = fread(fp,1,'int16');		%session_error
  regular     = char(fread(fp,1,'char'));	%regular
  hkey_un0    = char(fread(fp,1,'char'));	%hkey_un0
      
  % read (struct) image_dimension
  %--------------------------------------------------------------------
  dim        = fread(fp,8,'int16'); %short int dim[8]
  vox_units  = char(fread(fp,4,'char')');
  a          = fread(fp,1,'int16'); % unused
  cal_units  = char(fread(fp,8,'char'));
  datatype   = fread(fp,1,'int16');
  bitpix     = fread(fp,1,'int16');
  dim_un0    = fread(fp,1,'int16');
  pixdim     = fread(fp,8,'float'); 
  vox_offset = fread(fp,1,'float');
  scale_fact = fread(fp,1,'float');
  funused    = fread(fp,2,'float');
  cal_max    = fread(fp,1,'float');
  cal_min    = fread(fp,1,'float');
  compressed = fread(fp,1,'int32');
  verified   = fread(fp,1,'int32');
  glmax      = fread(fp,1,'int32');
  glmin      = fread(fp,1,'int32');
  
  % read (struct) data_history
  %-------------------------------------------------------------------
  descrip = char(fread(fp,80,'char')');
  aux_file = char(fread(fp,24,'char')');
  orient = char(fread(fp,1,'char'));
  origin = fread(fp,5,'int16');
  str_unused = char(fread(fp,85,'char')');
  %-------------------------------------------------------------------
  
  fclose(fp);
  
  hdr = struct('dim',dim,...
	       'datatype',datatype,...
	       'bitpix',bitpix,...
	       'pixdim',pixdim,...
	       'origin',origin);