% remove_dummy() - remove the first N dummy scans from the fMRI
%                  time series. N is defined by FMRI.dummy field in
%                  FMRI data structure
%
% Usage: 
%   >> remove_dummy();
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: set_fmri_global_ui(), rm_slice()
%
% Notes: - Caution: This process is not reversible. Once the dummy
%          scans has been removed, there is no way to get it back
%          unless you reload the fMRI data again. 
%        - The necessary parameters needed by the function are
%          assigned in FMRI data structure

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: remove_dummy.m,v $
% Revision 1.1  2003/02/06 19:14:02  duann
% Initial revision
%

function remove_dummy

global FMRI

if length(FMRI) == 0,
  fmrlab_messagedlg('Remove Dummy',...
	     'Error:',...
	     ['No current data set exists. Please load a ''.fmr''' ...
	      ' data files first']);
  return;
end

if isempty(FMRI.dummy),
  %errordlg('Number of dummy scans is not specified!');
  fmrlab_messagedlg('Remove Dummy',...
		'Error:',...
		'Number of dummy scans not specified');
  return;
end

datalen = FMRI.dime_x*FMRI.dime_y*FMRI.dime_z*(FMRI.timepoint+ ...
					       FMRI.dummy);
if datalen > size(FMRI.data,1),
  fmrlab_messagedlg('Remove Dummies',...
		 'Error:',...
		 ['Data size not matched. Check if data has already' ...
		  ' been ''dedummied''']);
  return;
end

if datalen < size(FMRI.data,1),
  fmrlab_messagedlg('Remove Dummies',...
		 'Error:',...
		 ['Data size not matched. Check if anything wrong' ...
		  ' in functional image information']);
  return;
end

data = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y*FMRI.dime_z, FMRI.dummy+FMRI.timepoint);
if FMRI.dummy ~= 0,
  data(:,1:FMRI.dummy) = [];
end
FMRI.data = reshape(data,FMRI.dime_x*FMRI.dime_y*FMRI.dime_z*FMRI.timepoint,1);
FMRI.processed = [FMRI.processed ':rmdummies'];

show_parameters
