% rm_slice() - remove noisy slice(s) from fMRI data set.
%
% Usage:
%   >> rm_slice;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2002
%
% See also: slice_timing(), remove_dummy()
%
% Notes: - ICA needs as many voxels as possible for the process to
%          converge. It's not recommended to use rm_slice() unless
%          the noisy slice is observed in the raw data.
%        - The process flow of FMRLAB is not reversible. Once the
%          slices were removed, the only way to get it back is to use
%          reselect_fmri() to select the same fMRI data set again and
%          redo the preprocess.
 
% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: rm_slice.m,v $
% Revision 1.1  2003/02/06 19:14:49  duann
% Initial revision
%

function rm_slice()

  global FMRI

  if length(FMRI) == 0,
    fmrlab_messagedlg('Remove Slice(s)',...
	       'Error:',...
	       ['No current data set exists. Please load a ''.fmr''' ...
		' data files first']);
    return;
  end
    
  prompt = {'Slice number(s) to remove from data:'};
  def = {'1'};
  a = fmrlab_inputdlg(prompt,'Remove Slice(s)',1,def);
  if isempty(a),
    %errordlg('Stopped by user...');
    return;
  end
  
  slice_no = str2num(char(a));
  
  FMRI.data = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y, ...
		      FMRI.dime_z,(FMRI.timepoint+FMRI.dummy));
  FMRI.data(:,slice_no,:) = [];
  FMRI.dime_z = FMRI.dime_z - length(slice_no);
  FMRI.data  = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y* ...
		       FMRI.dime_z*(FMRI.timepoint+FMRI.dummy),1);
  FMRI.processed = [FMRI.processed ':rm_sliced'];
  show_parameters
  