% run_fmrlab() - Initialize FMRLAB.
%
% Usage: >> run_fmrlab(fmrlab_path)
%
% Inputs: 
%    fmrlab_path - path name of FMRLAB
% 
% Author: Jeng-Ren Duann, CNL/Salk Inst. La Jolla, 01/2003
%
% See also: fmrlab()

% Copyright (C) Sigurd Enghoff, CNL / Salk Institute, La Jolla, 7/1998
%
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: run_fmrlab.m,v $
% Revision 1.2  2003/02/01 01:25:31  duann
% add parameters for pophelp
%
% Revision 1.1  2003/01/29 20:20:46  duann
% Initial revision
%

function run_fmrlab(fmrlab_path)
  
if nargin < 2,
    prompt = {'Full path in which FMRLAB installed:'};
    a = inputdlg(prompt,'FMRLAB',1,{''});
    if isempty(a),
        return;
    end
    fmrlab_path = char(a(1));
    if isunix,
        if fmrlab_path(length(fmrlab_path)) ~= '/',
            fmrlab_path = [fmrlab_path '/'];
        end
    else
        if fmrlab_path(length(fmrlab_path)) ~= '\',
            fmrlab_path = [fmrlab_path '\'];
        end
    end
end

% check if the fmrlab_path specified by user exists
if ~exist(fmrlab_path,'dir'),
  disp('Path not found');
  return;
end

addpath(fmrlab_path);
fname = [fmrlab_path 'icadefs.m'];
if exist(fname,'file'),
    if isunix,
        str = ['!mv ' fmrlab_path 'icadefs.m ' fmrlab_path 'icadefs.bak'];
        eval(str);
    else
        copyfile([fmrlab_path 'icadefs.m'],[fmrlab_path 'icadefs.bak']);
    end
end

str = [fmrlab_path 'icadefs.m'];
fp = fopen(str,'w');

fprintf(fp,'ICADIR = [''%s''];\n',fmrlab_path);
if isunix,
    fprintf(fp,'ICABINARY = ''%sica_linux'';\n\n',fmrlab_path);
else
    fprintf(fp,'ICABINARY = ''%sica.exe'';\n\n',fmrlab_path);
end
fprintf(fp,'SC = ''%sbinica.sc'';\n\n',fmrlab_path);

% makeing compatibility of eeglab functions
fprintf(fp,'BACKCOLOR = [1 .984 .895];\n');
fprintf(fp,'GUIBACKCOLOR = [0.860 0.824 0.618];\n');
fprintf(fp,'GUIBUTTONCOLOR = [0.860 0.824 0.618];\n');
fprintf(fp,'GUITEXTCOLOR = [0.333 0.283 0.003];\n');
fclose(fp);

fmrlab