% set_fmri_global() - set the data structure of FMRI as a global variable
%                     for fMRI data analys
%
% Usage: 
%    >> set_fmri_global;
%
% Inputs:
%
% outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2001-07-31
%
% See also: set_fmri_global_ui()

%--
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: set_fmri_global.m,v $
% Revision 1.1  2003/02/06 19:16:13  duann
% Initial revision
%


function set_fmri_global

% This function is used to set the data structure of FMRI as a global variable
% for fMRI data analysis.
%
% parameters in FMRI structure:
% GENERAL USE VARIABLES:
% 	FMRI.data	image body
%	FMRI.filename	image file name
%	FMRI.pathname	image path
%	FMRI.dime_x	image width (in pixels)
%	FMRI.dime_y	image height (in pixels)
%	FMRI.dime_z	image depth (in pixels)
%	FMRI.fov_x	field of view in x direction (in mm)
%	FMRI.fov_y	field of view in y direction (in mm)
%	FMRI.slicetk	slice thickness (in mm)
%	FMRI.dummy	dummy scans conducted in fMRI experiment
%	FMRI.timepoint	real time point acquired in fMRI experiment
%			total time point = dummy + timepoint
%	FMRI.tr		inter-scan interval = TR (in sec)
%       FMRI.idx        index indicates the inside-brain voxels
% 	FMRI.processed	recording the stage of image processing
%			it can be: 'raw', 'slice_timed', 'deskulled', 'icaed'
%
% ICA VARIABLE:
%	FMRI.pcano	dimensionality to be reduced to (default = 0, all)
%	FMRI.annealdeg	annleaing angle used in ICA training (default = 60 degree)
%	FMRI.extended	if extended ICA used (default = 0, no)
%	FMRI.icasphere	sphere matrix of ica result
%	FMRI.icaweight	weight matric of ica result
%       FMRI.icacomp    list of component number selected by user
%	
% Jeng-Ren Duann, CNL, Salk Inst., 2001-07-31

global FMRI

filename = input('Image file name: ')
str = ['Input image path (' pwd ') : '];
pathname = input(str);
if isempty(pathname)
  pathname = pwd;
end

fname = [pathname '/' filename];
fp = fopen(fname,'rb','ieee-be');
if fp == -1,
  disp('File does not exist...!');
  return
end
data = fread(fp,'uint16');
fclose(fp);

dime_x = input('Image width (in pixels): ');
dime_y = input('Image height (in pixels): ');
dime_z = input('Image depth (in pixels): ');
fov_x = input('Field of view (x, in mm): ');
fov_y = input('Field of view (y, in mm): ');
slicetk = input('Slice thickness (in mm): ');
dummy = input('Dummy scans: ');
timepoint = input('Time point (without Dummy): ');
tr = input('Interscan interval (TR, in sec): ');

pcano = input('PCA number (0): ');
if isempty(pcano),
  pcano = 0;
end
annealdeg = input('Annealing angle (60): ');
if isempty(annealdeg),
  annealdeg = 60;
end
extended = input('Extended ICA used (0/1): ');

FMRI = struct('data',      data, ...
              'filename',  filename, ...
              'pathname',  pathname, ...
	      'dime_x',    dime_x, ...
	      'dime_y',    dime_y, ...
              'dime_z',    dime_z, ...
              'fov_x',     fov_x, ...
              'fov_y',     fov_y, ...
              'slicetk',   slicetk, ...
              'dummy',     dummy, ...
              'timepoint', timepoint, ...
              'tr',        tr, ...
              'idx',       idx, ...
              'processed', 'raw', ...
	      'pcano',     pcano, ...
	      'annealdeg', annealdeg, ...
              'extended',  extended, ...
              'icasphere', [], ...
              'icaweight', [], ...
              'icacomp',   []);
