% show_actslice() - overlay the activation map onto the structural image. Both 
%                   structural images and activation map should be normalized
%                   to the standard brain space (Talairach space) with SPM.
% 
% Usage: 
%   >> show_actslice(struc, contrast1, range1, contrast2 range2, trans, ...
%                      slice_range);
% Inputs:
%   struc       - file name of normalized structural images (ex. 'nstr_0001.img')
%   contrast1   - file name of normalized postive activation map ...
%                 (ex. 'ncomp4_0001.img')
%   range1      - the display range of the z-score (ex. [2 10])
%   contrast2   - file name of normalized negative activation map ...
%                 (ex. 'ncomp4_0001.img');
%   range2      - the display range of the z-score (ex. [-2 -10])
%   trans       - slice position to be displayed ('axial', 'saggital', 'coronal')
%   slice_range - starting and end slice position in mm (ex. -26:2:20)
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. & SCCN/INC/UCSD, 2001-10
%
% See also: show_2d(), jr_normalize(), slice_overlay()

% --
% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: show_actslice.m,v $
% Revision 1.1  2003/02/06 19:16:58  duann
% Initial revision
%

function show_actslice(struc, contrast1, range1, contrast2, range2, trans, ...
                       slice_range)

% Jeng-Ren Duann, CNL/Salk and INC/UCSD, 2000-10-04

clear global SO;
global SO;

pos = get(0,'screensize');
SO.figure = figure(...
'name','2D Overlay',...
		   'numbertitle','off',...
		   'position',[pos(3)/2 pos(4)*0.1 pos(3)/2 pos(4)*0.8],...
    'menubar','none',...
    'toolbar','none');

SO.img(1).vol = spm_vol(struc);
SO.img(1).prop = 1;
SO.img(1).cmap = gray;
SO.img(2).vol = spm_vol(contrast1);
SO.img(2).range = range1;
SO.img(2).prop = Inf;
a = hot;
SO.img(2).cmap = [a(5:64,:); a(61:64,:)];
SO.img(3).vol = spm_vol(contrast2);
SO.img(3).range = range2
SO.img(3).prop = Inf;
SO.img(3).cmap = winter;

SO.cbar = [2 3];
SO.transform = trans;
SO.slices = slice_range;

slice_overlay;
