% show_mip() - display ICA component maps (or ROAs) on a
%              see-through maximal intensity projection (MIP) model
%              provided by SPM99
%
% Usage:
%   >> show_mip;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst., 2002-10
%
% See also: show_2d(), show_3d(), fmrlab_normalize()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: show_mip.m,v $
% Revision 1.1  2003/02/06 19:17:06  duann
% Initial revision
%

function show_mip

% Syntax:
%   >> show_mip
%
% Jeng-Ren Duann, CNL/Salk Inst., 2002-05-25

  RGB_mainwin = [1 .984 .895];

[fname, pname] = uigetfile(...
  {'nroa_*.img', 'Load Normalized ROA file (nroa_*.img)'},...
			   'Get Normalized ROA file');
if isequal(fname,0) | isequal(pname,0),
  fmrlab_messagedlg('ROA on SPM Glass Brain',...
		'Warning:',...
		['To export normalized ROA image files, see: Visualize' ...
		 ' > Export Selected Comps']);
  return;
end

filename = [pname fname];
fp = fopen(filename,'rb','ieee-le');
if fp == -1,
  %errordlg('Cannot open file...');
  fmrlab_messagedlg('MIP Display',...
		'Error:',...
		'Cannot open file');
  return;
end
data = fread(fp,'float');
fclose(fp);

pos_ii = find(data > 1.5);
pos = data(pos_ii)';
x = mod(pos_ii,79)-40;
y = mod(floor(pos_ii/79),95)-57;
z = (mod(floor(pos_ii/79/95),68)-26);
pos_xyz = [x y z]';
pos_xyz = 2*pos_xyz;
nag_ii = find(data < -1.5);
nag = abs(data(nag_ii)');
x = mod(nag_ii,79)-40;
y = mod(floor(nag_ii/79),95)-57;
z = (mod(floor(nag_ii/79/95),68)-26);
nag_xyz = [x y z]';
nag_xyz = 2*nag_xyz;

load MIP
mip = repmat(rot90(mip96/max(mip96(:))),[1 1 3]);
dim = [3 3 3 size(mip96)];

r = rot90(spm_project(rot90(pos),round(pos_xyz),dim));
r = r/max(r(:));
b = rot90(spm_project(rot90(nag),round(nag_xyz),dim));
b = b/max(b(:));
g = zeros(size(r));
mip = max(cat(3,r,g,b),mip);

figure(...
  'numbertitle','off',...
  'name','Maximum Intensity Projection',...
    'toolbar','none',...
    'color',RGB_mainwin,...
    'menubar','none');
image(mip)
axis image
axis off
for i=length(fname):-1:1
  if fname(i) == '.',
    break;
  end
end
a = str2num(fname(i-4:i-1));
ti = title(['Component ' num2str(a)]);
if isunix,
    text_size = 14;
else
    text_size = 12;
end
set(ti,'fontsize',text_size,'fontweight','bold');

