% slice_timing() - resampling the fMRI time series according to the
%                  slicing order with ideal lowpass interpolation
%
% Usage:
%      >> new_fmri = slice_timing(fmri, time_point, slice_sequence,
%      refering_slice);
%
% Inputs: 
%   fmri           - the original fMRI time series
%   time_point     - how many time points in the fMRI time course
%   slice_sequence - vector to give the sequence in which the slice images are
%                    acquired, ex. [1 3 5 7 9 2 4 6 8 10]
%   refering_slice - the refering slice for others to adjust their
%                    acquisition timing
%
% Outputs:
%   new_fmri - the resulting fMRI after slice timing process
%
% Author: Jeng-Ren Duann, CNL/Salk Inst., 2001-10
%
% See also: slice_timing_ui()

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: slice_timing.m,v $
% Revision 1.1  2003/02/06 19:20:20  duann
% Initial revision
%

function new_fmri = slice_timing(fmri, time_point, slice_sequence, refering_slice)

% Jeng-Ren Duann, duann@salk.edu
% CNL/Salk and INC/UCSD, Sep. 2000

slice_no = length(slice_sequence);
vox_no = length(fmri)/time_point/slice_no;

fmri = reshape(fmri, vox_no*slice_no, time_point);
%fmri = [fmri(:,1) fmri];
fmri = reshape(fmri, vox_no, slice_no, time_point);
new_fmri = zeros(vox_no, slice_no, time_point);

for start_seq=1:slice_no,
  if slice_sequence(start_seq) == refering_slice,
    break;
  end
end
start_seq;
progressbar(0.01);
drawnow
for i=1:length(slice_sequence)
  for j=1:vox_no
    temp = fmri(j,slice_sequence(i),:);
    temp2 = interp(temp, slice_no);
    if i>1,
      for k=1:i-1,
	temp2 = [temp2(1) temp2];
      end
    end
    tt = start_seq:slice_no:slice_no*length(temp);
    new_seq = temp2(tt);
    new_fmri(j,slice_sequence(i),:) = new_seq;
%    if (j==1000)
%      figure(99)
%      clf
%      plot(temp(:));
%      hold on
%      plot(new_seq,'r');
%    end
    
%    ii = 1;
%    for k=slice_no-i+1:slice_no:length(temp2)
%      new_fmri(j,slice_sequence(i),ii) = temp2(k);
%      ii = ii + 1;
%      if ii > time_point
%        break;
%      end
%    end
  end
  disp(['Slice #' num2str(slice_sequence(i)) ' is processed...']);
  progressbar(i/length(slice_sequence));
  drawnow
end
progressbar(1)
drawnow
pause(0.5);
progressbar(nan);

new_fmri = reshape(new_fmri, vox_no*slice_no*time_point, 1);
