% temporal_smooth() - perform 3 time-point moving average on
%                     fMRI time series.
%
% Usage:
%   >> temporal_smooth;
%
% Inputs:
%
% Outputs:
%
% Author: Jeng-Ren Duann, CNL/Salk Inst. 2002-10
%
% See also: spatial_smooth(), rm_slice()
%
% Notes: - temporal_smooth() is not recommended for the common data
%          analysis of fMRI data using ICA, especially infomax ICA,
%          unless the fMRI time series looks fairly noisy in time domain. 
%        - temporal_smooth() applies only 3 time-point moving average
%          on the time course of each voxel. 
%

% Copyright (C) 2002 Jeng-Ren Duann, Salk Institute, duann@salk.edu
%
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License as
% published by the Free Software Foundation; either version 2 of
% the License, or (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

% $Log: temporal_smooth.m,v $
% Revision 1.1  2003/02/06 18:21:46  duann
% Initial revision
%

function temporal_smooth()
  
  global FMRI
  
  if length(FMRI) == 0,
    fmrlab_messagedlg('Temporal Smoothing',...
	       'Error:',...
	       ['No current data set exists. Please load a ''.fmr''' ...
		' data files first']);
    return;
  end
  
  str = sprintf('Temporally smooth FMR time courses\n');
  str = [str sprintf('with a 3-timepoint moving average?\n')];
  str = [str sprintf('(Gives same number of time points)')];
  button_name = fmrlab_messagedlg('Temporal Smoothing',...
      'Information',...
      str,...
      {'OK','Cancel'});
  
  if strcmp(button_name,'OK'),
    FMRI.data = reshape(FMRI.data,FMRI.dime_x*FMRI.dime_y*FMRI.dime_z, ...
	  	      FMRI.timepoint);
    temp = FMRI.data;
    temp1 = zeros(size(temp));
    temp1(:,1:FMRI.timepoint-1) = temp(:,2:FMRI.timepoint);
    temp1(:,FMRI.timepoint) = temp(:,1);
    temp2 = zeros(size(temp));
    temp2(:,2:FMRI.timepoint) = temp(:,1:FMRI.timepoint-1);
    temp2(:,1) = temp(:,FMRI.timepoint);
    temp = (temp + temp1 + temp2)/3;
%    progressbar(0.01);
%    for i=1:FMRI.dime_x*FMRI.dime_y*FMRI.dime_z,
%      for j=2:FMRI.timepoint-1,
%        temp(i,j) = mean(FMRI.data(i,j-1:j+1));
%      end
%      if mod(i,1000) == 0,
%        progressbar(i/FMRI.dime_x/FMRI.dime_y/FMRI.dime_z);
%      end
%    end
    FMRI.data = reshape(temp,FMRI.dime_x*FMRI.dime_y*FMRI.dime_z*FMRI.timepoint,1);
%    progressbar(nan);  
    FMRI.processed = [FMRI.processed ':temporally_smoothed'];
    show_parameters
  end
  