#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QCloseEvent>
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/ini_parser.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/filesystem.hpp>
#include "Resampler.h"

// send a chunk every approx. this many ms
// to get a uniform lag distribution this should not be a divisor of 64 (= the default stride of the BioSemi driver)
const int send_interval_ms = 13;

// the age of each chunk received (in seconds) is anywhere between 0 and send_interval_ms miliseconds old, and is on average half of the maximum
const double buffer_lag = (send_interval_ms/2000.0);

// this is the default target sampling rate, in Hz
const int default_target_srate = 512;

// resampling filter coefficients (Sinc, linear-phase, 10ms delay, Lanczos window)
const double coeffs_2x_lp[] = {0, 0, 2.130203e-18, 8.271541e-03, -7.170356e-18, -2.294337e-02, 1.240827e-17, 4.818109e-02, -1.673083e-17, 
	-9.925850e-02, 1.917183e-17, 3.183099e-01, 4.918158e-01, 2.977755e-01, 1.673083e-17, -8.030181e-02, -1.240827e-17, 3.212072e-02, 
	7.170356e-18, -1.063484e-02, -2.130203e-18, 1.378696e-18, -1.742893e-18};

const double coeffs_4x_lp[] = {0, 0, 0, 0, 5.108107e-19, 1.294707e-03, 3.006461e-03, 3.096457e-03, -2.924656e-18, -5.520185e-03, 
	-9.920641e-03, -8.735685e-03, 5.570682e-18, 1.302634e-02, 2.223861e-02, 1.892732e-02, -7.897033e-18, -2.760092e-02, -4.776326e-02, 
	-4.211181e-02, 9.388725e-18, 7.379830e-02, 1.585013e-01, 2.250791e-01, 2.489732e-01, 2.213949e-01, 1.533295e-01, 7.018636e-02, 
	8.773969e-18, -3.864129e-02, -4.298945e-02, -2.433512e-02, -6.808611e-18, 1.592109e-02, 1.819523e-02, 1.032399e-02, 4.252249e-18, 
	-6.369444e-03, -6.823323e-03, -3.509318e-03, -1.656834e-18, 1.447026e-03, 9.269079e-04, 4.617879e-19, -4.621620e-19};

const double coeffs_8x_lp[] = {0, 0, 0, 0, 0, 0, 0, 0, 1.248130e-19, 1.637134e-04, 4.758227e-04, 8.686678e-04, 1.230919e-03, 
	1.428484e-03, 1.334558e-03, 8.632860e-04, -1.299762e-18, -1.179239e-03, -2.504791e-03, -3.730587e-03, -4.570926e-03, -4.752470e-03, 
	-4.073308e-03, -2.458414e-03, 2.622918e-18, 3.027397e-03, 6.183899e-03, 8.915102e-03, 1.063251e-02, 1.081358e-02, 9.106581e-03, 
	5.422972e-03, -3.821248e-18, -6.580539e-03, -1.342578e-02, -1.941819e-02, -2.334704e-02, -2.406955e-02, -2.067984e-02, -1.266153e-02,
	4.630930e-18, 1.676476e-02, 3.655642e-02, 5.785328e-02, 7.884320e-02, 9.762404e-02, 1.124239e-01, 1.218119e-01, 1.248715e-01,
	1.213116e-01, 1.115011e-01, 9.642213e-02, 7.754788e-02, 5.666320e-02, 3.565177e-02, 1.627911e-02, 4.476958e-18, -1.218547e-02, 
	-1.981062e-02, -2.294876e-02, -2.215141e-02, -1.833095e-02, -1.260786e-02, -6.146034e-03, -3.548654e-18, 5.006087e-03, 8.353689e-03, 
	9.853533e-03, 9.619890e-03, 8.004856e-03, 5.507142e-03, 2.672189e-03, 2.292749e-18, -2.126020e-03, -3.480759e-03, -4.006927e-03, 
	-3.795332e-03, -3.043276e-03, -2.001275e-03, -9.189818e-04, -9.823184e-19, 6.275579e-04, 9.215904e-04, 9.183060e-04, 7.102991e-04, 
	4.166033e-04, 1.517191e-04, 1.217548e-19, -1.187246e-19};

const double coeffs_16x_lp[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3.083204e-20, 2.013481e-05, 6.070447e-05, 
	1.203808e-04, 1.961716e-04, 2.834842e-04, 3.762925e-04, 4.674027e-04, 5.488105e-04, 6.121353e-04, 6.491120e-04, 6.521168e-04, 
	6.147009e-04, 5.321028e-04, 4.017090e-04, 2.234351e-04, -6.096732e-19, -2.629288e-04, -5.567378e-04, -8.700278e-04, -1.188937e-03, 
	-1.497622e-03, -1.778884e-03, -2.014925e-03, -2.188194e-03, -2.282304e-03, -2.282966e-03, -2.178905e-03, -1.962710e-03, 
	-1.631565e-03, -1.187833e-03, -6.394329e-04, 1.270468e-18, 7.112165e-04, 1.469716e-03, 2.246384e-03, 3.008384e-03, 3.720301e-03, 
	4.345477e-03, 4.847528e-03, 5.191952e-03, 5.347800e-03, 5.289315e-03, 4.997495e-03, 4.461477e-03, 3.679711e-03, 2.660833e-03, 
	1.424191e-03, -1.877634e-18, -1.570936e-03, -3.237911e-03, -4.941446e-03, -6.614803e-03, -8.185879e-03, -9.579407e-03, -1.071940e-02, 
	-1.153177e-02, -1.194701e-02, -1.190284e-02, -1.134677e-02, -1.023844e-02, -8.551603e-03, -6.275741e-03, -3.417242e-03, 2.297888e-18, 
	3.934520e-03, 8.327811e-03, 1.310543e-02, 1.817869e-02, 2.344680e-02, 2.879958e-02, 3.412039e-02, 3.928953e-02, 4.418757e-02, 
	4.869900e-02, 5.271559e-02, 5.613970e-02, 5.888725e-02, 6.089031e-02, 6.209918e-02, 6.248394e-02, 6.203535e-02, 6.076517e-02, 
	5.870572e-02, 5.590890e-02, 5.244458e-02, 4.839838e-02, 4.386908e-02, 3.896554e-02, 3.380347e-02, 2.850192e-02, 2.317979e-02, 
	1.795242e-02, 1.292834e-02, 8.206341e-03, 3.872874e-03, 2.259377e-18, -3.356209e-03, -6.156673e-03, -8.379741e-03, -1.002104e-02, 
	-1.109277e-02, -1.162251e-02, -1.165152e-02, -1.123273e-02, -1.042837e-02, -9.307476e-03, -7.943204e-03, -6.410229e-03, -4.782173e-03,
	-3.129236e-03, -1.516075e-03, -1.809455e-18, 1.370455e-03, 2.556565e-03, 3.530032e-03, 4.273170e-03, 4.778708e-03, 5.049198e-03, 
	5.096119e-03, 4.938686e-03, 4.602462e-03, 4.117817e-03, 3.518321e-03, 2.839122e-03, 2.115390e-03, 1.380876e-03, 6.666428e-04, 
	1.187891e-18, -5.963143e-04, -1.104699e-03, -1.512992e-03, -1.814510e-03, -2.007857e-03, -2.096503e-03, -2.088195e-03, -1.994217e-03,
	-1.828550e-03, -1.606987e-03, -1.346227e-03, -1.063008e-03, -7.733073e-04, -4.916479e-04, -2.305282e-04, -5.302818e-19, 1.925989e-04, 
	3.427548e-04, 4.487374e-04, 5.114209e-04, 5.339851e-04, 5.215215e-04, 4.805689e-04, 4.186099e-04, 3.435539e-04, 2.632378e-04, 
	1.849670e-04, 1.151190e-04, 5.882842e-05, 1.976316e-05, 3.064219e-20, -3.007076e-20};

const double coeffs_32x_lp[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	7.661009e-21, 2.483226e-06, 7.505838e-06, 1.507521e-05, 2.514813e-05, 3.762967e-05, 5.237291e-05, 6.917931e-05, 8.779997e-05, 
	1.079377e-04, 1.292498e-04, 1.513517e-04, 1.738215e-04, 1.962047e-04, 2.180205e-04, 2.387678e-04, 2.579322e-04, 2.749936e-04, 
	2.894337e-04, 3.007444e-04, 3.084360e-04, 3.120451e-04, 3.111436e-04, 3.053465e-04, 2.943196e-04, 2.777874e-04, 2.555401e-04, 
	2.274397e-04, 1.934260e-04, 1.535213e-04, 1.078345e-04, 5.656415e-05, -2.948458e-19, -6.147585e-05, -1.273896e-04, -1.971774e-04, 
	-2.701881e-04, -3.456879e-04, -4.228652e-04, -5.008379e-04, -5.786609e-04, -6.553352e-04, -7.298184e-04, -8.010354e-04, 
	-8.678909e-04, -9.292817e-04, -9.841106e-04, -1.031300e-03, -1.069808e-03, -1.098638e-03, -1.116861e-03, -1.123623e-03, 
	-1.118163e-03, -1.099826e-03, -1.068074e-03, -1.022501e-03, -9.628435e-04, -8.889877e-04, -8.009810e-04, -6.990380e-04, 
	-5.835454e-04, -4.550661e-04, -3.143408e-04, -1.622877e-04, 6.249458e-19, 1.712582e-04, 3.500585e-04, 5.348169e-04, 7.238043e-04, 
	9.151596e-04, 1.106904e-03, 1.296958e-03, 1.483161e-03, 1.663287e-03, 1.835071e-03, 1.996232e-03, 2.144491e-03, 2.277604e-03, 
	2.393380e-03, 2.489711e-03, 2.564599e-03, 2.616178e-03, 2.642743e-03, 2.642773e-03, 2.614956e-03, 2.558210e-03, 2.471707e-03, 
	2.354888e-03, 2.207485e-03, 2.029534e-03, 1.821388e-03, 1.583727e-03, 1.317564e-03, 1.024250e-03, 7.054781e-04, 3.632748e-04, 
	-9.304290e-19, -3.816642e-04, -7.787255e-04, -1.187897e-03, -1.605614e-03, -2.028062e-03, -2.451192e-03, -2.870760e-03, 
	-3.282346e-03, -3.681397e-03, -4.063255e-03, -4.423200e-03, -4.756486e-03, -5.058378e-03, -5.324202e-03, -5.549377e-03, 
	-5.729466e-03, -5.860210e-03, -5.937576e-03, -5.957793e-03, -5.917394e-03, -5.813252e-03, -5.642617e-03, -5.403147e-03, 
	-5.092941e-03, -4.710564e-03, -4.255073e-03, -3.726036e-03, -3.123546e-03, -2.448240e-03, -1.701299e-03, -8.844576e-04, 
	1.144338e-18, 9.492449e-04, 1.959914e-03, 3.028122e-03, 4.149487e-03, 5.319148e-03, 6.531793e-03, 7.781697e-03, 9.062752e-03, 
	1.036851e-02, 1.169222e-02, 1.302688e-02, 1.436529e-02, 1.570008e-02, 1.702381e-02, 1.832894e-02, 1.960799e-02, 2.085351e-02, 
	2.205818e-02, 2.321484e-02, 2.431657e-02, 2.535672e-02, 2.632897e-02, 2.722736e-02, 2.804639e-02, 2.878098e-02, 2.942659e-02, 
	2.997920e-02, 3.043537e-02, 3.079225e-02, 3.104759e-02, 3.119982e-02, 3.124799e-02, 3.119181e-02, 3.103164e-02, 3.076851e-02, 
	3.040408e-02, 2.994068e-02, 2.938121e-02, 2.872918e-02, 2.798868e-02, 2.716432e-02, 2.626121e-02, 2.528491e-02, 2.424141e-02, 
	2.313707e-02, 2.197855e-02, 2.077280e-02, 1.952699e-02, 1.824843e-02, 1.694457e-02, 1.562288e-02, 1.429087e-02, 1.295595e-02, 
	1.162546e-02, 1.030655e-02, 9.006179e-03, 7.731038e-03, 6.487516e-03, 5.281656e-03, 4.119116e-03, 3.005136e-03, 1.944500e-03, 
	9.415194e-04, 1.134710e-18, -8.767706e-04, -1.686039e-03, -2.425595e-03, -3.093776e-03, -3.689468e-03, -4.212103e-03, -4.661645e-03, 
	-5.038584e-03, -5.343912e-03, -5.579110e-03, -5.746117e-03, -5.847305e-03, -5.885451e-03, -5.863697e-03, -5.785521e-03, 
	-5.654697e-03, -5.475254e-03, -5.251437e-03, -4.987666e-03, -4.688495e-03, -4.358568e-03, -4.002580e-03, -3.625232e-03, 
	-3.231197e-03, -2.825077e-03, -2.411370e-03, -1.994430e-03, -1.578442e-03, -1.167385e-03, -7.650087e-04, -3.748073e-04, 
	-9.133823e-19, 3.564885e-04, 6.920424e-04, 1.004366e-03, 1.291494e-03, 1.551792e-03, 1.783964e-03, 1.987046e-03, 2.160403e-03, 
	2.303723e-03, 2.417004e-03, 2.500543e-03, 2.554920e-03, 2.580981e-03, 2.579816e-03, 2.552742e-03, 2.501275e-03, 2.427114e-03, 
	2.332106e-03, 2.218231e-03, 2.087570e-03, 1.942280e-03, 1.784571e-03, 1.616678e-03, 1.440840e-03, 1.259274e-03, 1.074152e-03, 
	8.875833e-04, 7.015919e-04, 5.181006e-04, 3.389139e-04, 1.657043e-04, 6.042992e-19, -1.568252e-04, -3.035601e-04, -4.391617e-04, 
	-5.627598e-04, -6.736582e-04, -7.713346e-04, -8.554392e-04, -9.257899e-04, -9.823673e-04, -1.025307e-03, -1.054893e-03, 
	-1.071543e-03, -1.075802e-03, -1.068329e-03, -1.049882e-03, -1.021308e-03, -9.835255e-04, -9.375120e-04, -8.842901e-04, 
	-8.249123e-04, -7.604471e-04, -6.919659e-04, -6.205295e-04, -5.471754e-04, -4.729072e-04, -3.986827e-04, -3.254052e-04, 
	-2.539141e-04, -1.849781e-04, -1.192887e-04, -5.745492e-05, -2.749960e-19, 5.264149e-05, 1.001248e-04, 1.421950e-04, 1.786861e-04,
	2.095187e-04, 2.346968e-04, 2.543038e-04, 2.684972e-04, 2.775027e-04, 2.816080e-04, 2.811557e-04, 2.765355e-04, 2.681765e-04, 
	2.565392e-04, 2.421072e-04, 2.253792e-04, 2.068605e-04, 1.870557e-04, 1.664605e-04, 1.455554e-04, 1.247982e-04, 1.046184e-04, 
	8.541173e-05, 6.753516e-05, 5.130300e-05, 3.698357e-05, 2.479670e-05, 1.491199e-05, 7.447935e-06, 2.471745e-06, 7.649200e-21, 
	-7.565841e-21};

const double coeffs_64x_lp[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.970532e-21, 3.228544e-07, 9.734794e-07, 
	1.955192e-06, 3.269668e-06, 4.916909e-06, 6.895211e-06, 9.201144e-06, 1.182953e-05, 1.477345e-05, 1.802422e-05, 2.157140e-05, 
	2.540281e-05, 2.950455e-05, 3.386102e-05, 3.845495e-05, 4.326743e-05, 4.827800e-05, 5.346463e-05, 5.880382e-05, 6.427070e-05, 
	6.983904e-05, 7.548134e-05, 8.116897e-05, 8.687219e-05, 9.256030e-05, 9.820171e-05, 1.037641e-04, 1.092144e-04, 1.145190e-04, 
	1.196442e-04, 1.245554e-04, 1.292185e-04, 1.335988e-04, 1.376621e-04, 1.413744e-04, 1.447018e-04, 1.476112e-04, 1.500702e-04, 
	1.520470e-04, 1.535110e-04, 1.544324e-04, 1.547829e-04, 1.545355e-04, 1.536647e-04, 1.521466e-04, 1.499593e-04, 1.470825e-04, 
	1.434982e-04, 1.391904e-04, 1.341456e-04, 1.283523e-04, 1.218018e-04, 1.144879e-04, 1.064071e-04, 9.755859e-05, 8.794441e-05, 
	7.756951e-05, 6.644181e-05, 5.457220e-05, 4.197465e-05, 2.866617e-05, 1.466688e-05, -1.472739e-19, -1.530815e-05, -3.122815e-05, 
	-4.772753e-05, -6.477076e-05, -8.231933e-05, -1.003318e-04, -1.187638e-04, -1.375683e-04, -1.566953e-04, -1.760926e-04, -1.957051e-04,
	-2.154755e-04, -2.353442e-04, -2.552496e-04, -2.751280e-04, -2.949140e-04, -3.145406e-04, -3.339392e-04, -3.530400e-04, -3.717723e-04,
	-3.900643e-04, -4.078437e-04, -4.250377e-04, -4.415734e-04, -4.573778e-04, -4.723782e-04, -4.865023e-04, -4.996788e-04, -5.118372e-04,
	-5.229081e-04, -5.328239e-04, -5.415185e-04, -5.489278e-04, -5.549900e-04, -5.596458e-04, -5.628385e-04, -5.645145e-04, -5.646232e-04,
	-5.631178e-04, -5.599548e-04, -5.550948e-04, -5.485024e-04, -5.401465e-04, -5.300007e-04, -5.180431e-04, -5.042568e-04, -4.886297e-04,
	-4.711552e-04, -4.518320e-04, -4.306641e-04, -4.076613e-04, -3.828389e-04, -3.562181e-04, -3.278260e-04, -2.976957e-04, -2.658659e-04,
	-2.323816e-04, -1.972938e-04, -1.606593e-04, -1.225410e-04, -8.300763e-05, -4.213384e-05, 3.148568e-19, 4.330784e-05, 8.769810e-05, 
	1.330737e-04, 1.793325e-04, 2.263671e-04, 2.740652e-04, 3.223099e-04, 3.709799e-04, 4.199495e-04, 4.690892e-04, 5.182658e-04,
	5.673428e-04, 6.161803e-04, 6.646361e-04, 7.125654e-04, 7.598212e-04, 8.062550e-04, 8.517170e-04, 8.960563e-04, 9.391217e-04,
	9.807616e-04, 1.020825e-03, 1.059161e-03, 1.095622e-03, 1.130058e-03, 1.162325e-03, 1.192279e-03, 1.219780e-03, 1.244691e-03, 
	1.266879e-03, 1.286215e-03, 1.302576e-03, 1.315841e-03, 1.325898e-03, 1.332639e-03, 1.335964e-03, 1.335777e-03, 1.331992e-03, 
	1.324530e-03, 1.313318e-03, 1.298296e-03, 1.279406e-03, 1.256606e-03, 1.229858e-03, 1.199136e-03, 1.164424e-03, 1.125715e-03, 
	1.083015e-03, 1.036337e-03, 9.857071e-04, 9.311624e-04, 8.727505e-04, 8.105302e-04, 7.445721e-04, 6.749578e-04, 6.017805e-04, 
	5.251450e-04, 4.451672e-04, 3.619747e-04, 2.757062e-04, 1.865117e-04, 9.455232e-05, -4.704854e-19, -9.696257e-05, -1.961422e-04, 
	-2.973355e-04, -4.003290e-04, -5.048998e-04, -6.108153e-04, -7.178343e-04, -8.257069e-04, -9.341750e-04, -1.042973e-03, -1.151828e-03, 
	-1.260459e-03, -1.368582e-03, -1.475904e-03, -1.582129e-03, -1.686955e-03, -1.790076e-03, -1.891186e-03, -1.989971e-03, -2.086118e-03, 
	-2.179314e-03, -2.269242e-03, -2.355587e-03, -2.438034e-03, -2.516270e-03, -2.589983e-03, -2.658865e-03, -2.722611e-03, -2.780920e-03, 
	-2.833497e-03, -2.880052e-03, -2.920300e-03, -2.953966e-03, -2.980781e-03, -3.000485e-03, -3.012828e-03, -3.017567e-03, -3.014473e-03, 
	-3.003327e-03, -2.983922e-03, -2.956062e-03, -2.919565e-03, -2.874264e-03, -2.820005e-03, -2.756647e-03, -2.684067e-03, -2.602157e-03, 
	-2.510822e-03, -2.409988e-03, -2.299596e-03, -2.179602e-03, -2.049982e-03, -1.910731e-03, -1.761858e-03, -1.603393e-03, -1.435385e-03, 
	-1.257898e-03, -1.071019e-03, -8.748497e-04, -6.695134e-04, -4.551504e-04, -2.319200e-04, 5.800740e-19, 2.404138e-04, 4.891072e-04, 
	7.458484e-04, 1.010388e-03, 1.282459e-03, 1.561777e-03, 1.848043e-03, 2.140940e-03, 2.440137e-03, 2.745285e-03, 3.056023e-03, 3.371976e-03, 
	3.692753e-03, 4.017954e-03, 4.347163e-03, 4.679955e-03, 5.015894e-03, 5.354534e-03, 5.695418e-03, 6.038083e-03, 6.382057e-03, 6.726862e-03, 
	7.072015e-03, 7.417025e-03, 7.761401e-03, 8.104645e-03, 8.446260e-03, 8.785745e-03, 9.122601e-03, 9.456327e-03, 9.786425e-03, 1.011240e-02, 
	1.043376e-02, 1.075002e-02, 1.106069e-02, 1.136530e-02, 1.166338e-02, 1.195447e-02, 1.223811e-02, 1.251387e-02, 1.278130e-02, 1.304001e-02, 
	1.328956e-02, 1.352958e-02, 1.375967e-02, 1.397948e-02, 1.418866e-02, 1.438686e-02, 1.457378e-02, 1.474911e-02, 1.491257e-02, 1.506391e-02, 
	1.520286e-02, 1.532922e-02, 1.544278e-02, 1.554335e-02, 1.563077e-02, 1.570490e-02, 1.576562e-02, 1.581283e-02, 1.584645e-02, 1.586644e-02, 
	1.587275e-02, 1.586539e-02, 1.584435e-02, 1.580968e-02, 1.576143e-02, 1.569969e-02, 1.562455e-02, 1.553613e-02, 1.543458e-02, 1.532007e-02, 
	1.519278e-02, 1.505291e-02, 1.490070e-02, 1.473639e-02, 1.456024e-02, 1.437254e-02, 1.417358e-02, 1.396370e-02, 1.374322e-02, 1.351250e-02, 
	1.327190e-02, 1.302181e-02, 1.276261e-02, 1.249473e-02, 1.221857e-02, 1.193458e-02, 1.164320e-02, 1.134487e-02, 1.104007e-02, 1.072925e-02, 
	1.041290e-02, 1.009150e-02, 9.765539e-03, 9.435506e-03, 9.101897e-03, 8.765211e-03, 8.425946e-03, 8.084602e-03, 7.741679e-03, 7.397673e-03, 
	7.053080e-03, 6.708392e-03, 6.364096e-03, 6.020676e-03, 5.678608e-03, 5.338361e-03, 5.000399e-03, 4.665175e-03, 4.333133e-03, 4.004708e-03, 
	3.680323e-03, 3.360390e-03, 3.045310e-03, 2.735469e-03, 2.431241e-03, 2.132986e-03, 1.841047e-03, 1.555754e-03, 1.277422e-03, 1.006348e-03, 
	7.428137e-04, 4.870823e-04, 2.394013e-04, 5.775897e-19, -2.309102e-04, -4.531358e-04, -6.665017e-04, -8.708511e-04, -1.066046e-03, -1.251966e-03, 
	-1.428511e-03, -1.595598e-03, -1.753163e-03, -1.901161e-03, -2.039564e-03, -2.168364e-03, -2.287568e-03, -2.397204e-03, -2.497316e-03, 
	-2.587964e-03, -2.669226e-03, -2.741197e-03, -2.803986e-03, -2.857719e-03, -2.902537e-03, -2.938595e-03, -2.966061e-03, -2.985119e-03, 
	-2.995965e-03, -2.998805e-03, -2.993860e-03, -2.981361e-03, -2.961549e-03, -2.934674e-03, -2.900997e-03, -2.860785e-03, -2.814316e-03, 
	-2.761872e-03, -2.703743e-03, -2.640224e-03, -2.571615e-03, -2.498219e-03, -2.420345e-03, -2.338303e-03, -2.252404e-03, -2.162962e-03, 
	-2.070292e-03, -1.974707e-03, -1.876520e-03, -1.776044e-03, -1.673587e-03, -1.569456e-03, -1.463956e-03, -1.357384e-03, -1.250037e-03, 
	-1.142203e-03, -1.034166e-03, -9.262047e-04, -8.185889e-04, -7.115822e-04, -6.054405e-04, -5.004115e-04, -3.967340e-04, -2.946383e-04, 
	-1.943450e-04, -9.606516e-05, -4.660873e-19, 9.365961e-05, 1.847332e-04, 2.730511e-04, 3.584544e-04, 4.407953e-04, 5.199371e-04, 5.957543e-04, 
	6.681329e-04, 7.369702e-04, 8.021748e-04, 8.636667e-04, 9.213774e-04, 9.752494e-04, 1.025237e-03, 1.071304e-03, 1.113427e-03, 1.151592e-03, 
	1.185796e-03, 1.216046e-03, 1.242361e-03, 1.264766e-03, 1.283299e-03, 1.298006e-03, 1.308941e-03, 1.316169e-03, 1.319760e-03, 1.319795e-03, 
	1.316360e-03, 1.309551e-03, 1.299466e-03, 1.286215e-03, 1.269910e-03, 1.250670e-03, 1.228617e-03, 1.203882e-03, 1.176595e-03, 1.146893e-03, 
	1.114916e-03, 1.080805e-03, 1.044705e-03, 1.006762e-03, 9.671252e-04, 9.259430e-04, 8.833652e-04, 8.395418e-04, 7.946225e-04, 7.487566e-04, 
	7.020923e-04, 6.547764e-04, 6.069541e-04, 5.587684e-04, 5.103599e-04, 4.618664e-04, 4.134226e-04, 3.651599e-04, 3.172059e-04, 2.696842e-04, 
	2.227144e-04, 1.764114e-04, 1.308855e-04, 8.624230e-05, 4.258207e-05, 3.095299e-19, -4.141416e-05, -8.157616e-05, -1.204074e-04, -1.578350e-04, 
	-1.937918e-04, -2.282167e-04, -2.610543e-04, -2.922553e-04, -3.217761e-04, -3.495794e-04, -3.756333e-04, -3.999122e-04, -4.223961e-04, -4.430706e-04,
	-4.619271e-04, -4.789625e-04, -4.941790e-04, -5.075841e-04, -5.191905e-04, -5.290157e-04, -5.370821e-04, -5.434168e-04, -5.480511e-04, -5.510207e-04, 
	-5.523652e-04, -5.521281e-04, -5.503564e-04, -5.471005e-04, -5.424140e-04, -5.363531e-04, -5.289770e-04, -5.203470e-04, -5.105267e-04, -4.995816e-04,
	-4.875789e-04, -4.745870e-04, -4.606757e-04, -4.459156e-04, -4.303780e-04, -4.141346e-04, -3.972573e-04, -3.798181e-04, -3.618885e-04, -3.435397e-04,
	-3.248422e-04, -3.058656e-04, -2.866783e-04, -2.673474e-04, -2.479387e-04, -2.285163e-04, -2.091423e-04, -1.898770e-04, -1.707785e-04, -1.519027e-04, 
	-1.333032e-04, -1.150308e-04, -9.713402e-05, -7.965849e-05, -6.264712e-05, -4.613996e-05, -3.017411e-05, -1.478375e-05, -1.421525e-19, 1.414903e-05, 
	2.763829e-05, 4.044582e-05, 5.255270e-05, 6.394305e-05, 7.460406e-05, 8.452589e-05, 9.370163e-05, 1.021273e-04, 1.098018e-04, 1.167268e-04,
	1.229065e-04, 1.283479e-04, 1.330606e-04, 1.370563e-04, 1.403493e-04, 1.429561e-04, 1.448951e-04, 1.461869e-04, 1.468538e-04, 1.469199e-04, 
	1.464108e-04, 1.453537e-04, 1.437769e-04, 1.417101e-04, 1.391840e-04, 1.362300e-04, 1.328805e-04, 1.291683e-04, 1.251269e-04, 1.207900e-04, 
	1.161914e-04, 1.113651e-04, 1.063451e-04, 1.011649e-04, 9.585786e-05, 9.045695e-05, 8.499443e-05, 7.950191e-05, 7.401020e-05, 6.854917e-05, 
	6.314773e-05, 5.783364e-05, 5.263349e-05, 4.757259e-05, 4.267490e-05, 3.796296e-05, 3.345782e-05, 2.917898e-05, 2.514437e-05, 2.137028e-05, 
	1.787133e-05, 1.466043e-05, 1.174878e-05, 9.145856e-06, 6.859377e-06, 4.895323e-06, 3.257940e-06, 1.949742e-06, 9.715426e-07, 3.224691e-07, 
	1.969748e-21, -1.958061e-21};

const double coeffs_128x_lp[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.918560e-22, 
	4.017880e-08, 1.208808e-07, 2.424013e-07, 4.049859e-07, 6.088296e-07, 8.540765e-07, 1.140819e-06, 1.469097e-06, 1.838898e-06, 2.250157e-06, 
	2.702754e-06, 3.196517e-06, 3.731218e-06, 4.306577e-06, 4.922256e-06, 5.577865e-06, 6.272960e-06, 7.007039e-06, 7.779547e-06, 8.589875e-06, 
	9.437358e-06, 1.032128e-05, 1.124086e-05, 1.219528e-05, 1.318366e-05, 1.420506e-05, 1.525849e-05, 1.634293e-05, 1.745727e-05, 1.860038e-05, 
	1.977107e-05, 2.096809e-05, 2.219016e-05, 2.343594e-05, 2.470404e-05, 2.599303e-05, 2.730145e-05, 2.862775e-05, 2.997040e-05, 3.132777e-05, 
	3.269823e-05, 3.408008e-05, 3.547161e-05, 3.687106e-05, 3.827663e-05, 3.968649e-05, 4.109879e-05, 4.251162e-05, 4.392307e-05, 4.533119e-05, 
	4.673400e-05, 4.812950e-05, 4.951568e-05, 5.089048e-05, 5.225185e-05, 5.359770e-05, 5.492595e-05, 5.623448e-05, 5.752118e-05, 5.878391e-05, 
	6.002055e-05, 6.122894e-05, 6.240695e-05, 6.355243e-05, 6.466323e-05, 6.573721e-05, 6.677223e-05, 6.776617e-05, 6.871691e-05, 6.962232e-05, 
	7.048033e-05, 7.128885e-05, 7.204582e-05, 7.274921e-05, 7.339698e-05, 7.398716e-05, 7.451778e-05, 7.498690e-05, 7.539261e-05, 7.573305e-05, 
	7.600638e-05, 7.621081e-05, 7.634458e-05, 7.640599e-05, 7.639335e-05, 7.630505e-05, 7.613952e-05, 7.589524e-05, 7.557074e-05, 7.516461e-05, 
	7.467549e-05, 7.410209e-05, 7.344317e-05, 7.269757e-05, 7.186418e-05, 7.094195e-05, 6.992993e-05, 6.882721e-05, 6.763295e-05, 6.634642e-05, 
	6.496694e-05, 6.349389e-05, 6.192677e-05, 6.026513e-05, 5.850861e-05, 5.665694e-05, 5.470993e-05, 5.266746e-05, 5.052952e-05, 4.829618e-05, 
	4.596760e-05, 4.354403e-05, 4.102580e-05, 3.841334e-05, 3.570719e-05, 3.290795e-05, 3.001635e-05, 2.703319e-05, 2.395936e-05, 2.079587e-05, 
	1.754381e-05, 1.420437e-05, 1.077884e-05, 7.268594e-06, 3.675123e-06, -7.299566e-20, -3.755102e-06, -7.588414e-06, -1.149807e-05, -1.548210e-05,
	-1.953847e-05, -2.366500e-05, -2.785946e-05, -3.211951e-05, -3.644271e-05, -4.082655e-05, -4.526841e-05, -4.976558e-05, -5.431527e-05, 
	-5.891461e-05, -6.356062e-05, -6.825025e-05, -7.298038e-05, -7.774778e-05, -8.254917e-05, -8.738116e-05, -9.224031e-05, -9.712309e-05,
	-1.020259e-04, -1.069451e-04, -1.118769e-04, -1.168176e-04, -1.217632e-04, -1.267099e-04, -1.316536e-04, -1.365903e-04, -1.415160e-04, 
	-1.464264e-04, -1.513174e-04, -1.561848e-04, -1.610242e-04, -1.658313e-04, -1.706018e-04, -1.753313e-04, -1.800154e-04, -1.846495e-04,
	-1.892293e-04, -1.937502e-04, -1.982078e-04, -2.025974e-04, -2.069146e-04, -2.111549e-04, -2.153136e-04, -2.193862e-04, -2.233682e-04,
	-2.272551e-04, -2.310423e-04, -2.347253e-04, -2.382996e-04, -2.417608e-04, -2.451044e-04, -2.483260e-04, -2.514213e-04, -2.543858e-04,
	-2.572153e-04, -2.599056e-04, -2.624524e-04, -2.648516e-04, -2.670991e-04, -2.691909e-04, -2.711229e-04, -2.728914e-04, -2.744925e-04,
	-2.759224e-04, -2.771775e-04, -2.782542e-04, -2.791490e-04, -2.798585e-04, -2.803795e-04, -2.807086e-04, -2.808428e-04, -2.807790e-04,
	-2.805146e-04, -2.800465e-04, -2.793723e-04, -2.784893e-04, -2.773951e-04, -2.760875e-04, -2.745644e-04, -2.728236e-04, -2.708634e-04,
	-2.686819e-04, -2.662776e-04, -2.636491e-04, -2.607951e-04, -2.577143e-04, -2.544058e-04, -2.508688e-04, -2.471026e-04, -2.431066e-04, 
	-2.388806e-04, -2.344243e-04, -2.297378e-04, -2.248211e-04, -2.196746e-04, -2.142988e-04, -2.086944e-04, -2.028623e-04, -1.968034e-04,
	-1.905191e-04, -1.840106e-04, -1.772795e-04, -1.703277e-04, -1.631571e-04, -1.557698e-04, -1.481681e-04, -1.403545e-04, -1.323318e-04,
	-1.241028e-04, -1.156705e-04, -1.070382e-04, -9.820941e-05, -8.918768e-05, -7.997683e-05, -7.058087e-05, -6.100398e-05, -5.125051e-05,
	-4.132501e-05, -3.123222e-05, -2.097703e-05, -1.056454e-05, 1.567631e-19, 1.071114e-05, 2.156328e-05, 3.255063e-05, 4.366724e-05, 5.490699e-05, 
	6.626360e-05, 7.773063e-05, 8.930148e-05, 1.009694e-04, 1.127274e-04, 1.245686e-04, 1.364856e-04, 1.484711e-04, 1.605177e-04, 1.726176e-04, 
	1.847633e-04, 1.969467e-04, 2.091599e-04, 2.213947e-04, 2.336429e-04, 2.458961e-04, 2.581459e-04, 2.703838e-04, 2.826010e-04, 2.947888e-04, 
	3.069385e-04, 3.190410e-04, 3.310874e-04, 3.430686e-04, 3.549755e-04, 3.667989e-04, 3.785296e-04, 3.901583e-04, 4.016757e-04, 4.130724e-04, 
	4.243390e-04, 4.354662e-04, 4.464444e-04, 4.572642e-04, 4.679163e-04, 4.783911e-04, 4.886792e-04, 4.987712e-04, 5.086578e-04, 5.183294e-04, 
	5.277769e-04, 5.369909e-04, 5.459622e-04, 5.546815e-04, 5.631398e-04, 5.713280e-04, 5.792372e-04, 5.868584e-04, 5.941828e-04, 6.012018e-04,
	6.079067e-04, 6.142891e-04, 6.203405e-04, 6.260527e-04, 6.314177e-04, 6.364274e-04, 6.410740e-04, 6.453498e-04, 6.492474e-04, 6.527593e-04, 
	6.558784e-04, 6.585977e-04, 6.609104e-04, 6.628099e-04, 6.642897e-04, 6.653436e-04, 6.659657e-04, 6.661501e-04, 6.658913e-04, 6.651840e-04, 
	6.640231e-04, 6.624038e-04, 6.603214e-04, 6.577715e-04, 6.547503e-04, 6.512537e-04, 6.472783e-04, 6.428208e-04, 6.378782e-04, 6.324478e-04,
	6.265272e-04, 6.201143e-04, 6.132073e-04, 6.058047e-04, 5.979052e-04, 5.895081e-04, 5.806126e-04, 5.712186e-04, 5.613262e-04, 5.509357e-04,
	5.400480e-04, 5.286640e-04, 5.167852e-04, 5.044134e-04, 4.915505e-04, 4.781992e-04, 4.643621e-04, 4.500424e-04, 4.352435e-04, 4.199694e-04, 
	4.042242e-04, 3.880125e-04, 3.713391e-04, 3.542093e-04, 3.366288e-04, 3.186034e-04, 3.001397e-04, 2.812441e-04, 2.619238e-04, 2.421863e-04, 
	2.220391e-04, 2.014905e-04, 1.805489e-04, 1.592232e-04, 1.375225e-04, 1.154562e-04, 9.303440e-05, 7.026714e-05, 4.716501e-05, 2.373889e-05, 
	-2.346951e-19, -2.404011e-05, -4.836956e-05, -7.297616e-05, -9.784738e-05, -1.229704e-04, -1.483320e-04, -1.739188e-04, -1.997170e-04, -2.257126e-04, 
	-2.518913e-04, -2.782383e-04, -3.047387e-04, -3.313775e-04, -3.581391e-04, -3.850078e-04, -4.119677e-04, -4.390025e-04, -4.660958e-04, -4.932309e-04, 
	-5.203908e-04, -5.475584e-04, -5.747164e-04, -6.018472e-04, -6.289331e-04, -6.559561e-04, -6.828981e-04, -7.097409e-04, -7.364659e-04, -7.630546e-04, 
	-7.894883e-04, -8.157480e-04, -8.418149e-04, -8.676697e-04, -8.932932e-04, -9.186663e-04, -9.437693e-04, -9.685829e-04, -9.930876e-04, -1.017264e-03, 
	-1.041092e-03, -1.064552e-03, -1.087624e-03, -1.110290e-03, -1.132528e-03, -1.154320e-03, -1.175645e-03, -1.196485e-03, -1.216819e-03, -1.236628e-03, 
	-1.255892e-03, -1.274592e-03, -1.292709e-03, -1.310224e-03, -1.327116e-03, -1.343369e-03, -1.358961e-03, -1.373876e-03, -1.388094e-03, -1.401597e-03,
	-1.414366e-03, -1.426384e-03, -1.437633e-03, -1.448095e-03, -1.457753e-03, -1.466589e-03, -1.474588e-03, -1.481731e-03, -1.488003e-03, -1.493387e-03, 
	-1.497869e-03, -1.501431e-03, -1.504059e-03, -1.505739e-03, -1.506455e-03, -1.506193e-03, -1.504940e-03, -1.502681e-03, -1.499404e-03, -1.495096e-03, 
	-1.489745e-03, -1.483338e-03, -1.475864e-03, -1.467312e-03, -1.457670e-03, -1.446930e-03, -1.435080e-03, -1.422112e-03, -1.408016e-03, -1.392784e-03, 
	-1.376408e-03, -1.358880e-03, -1.340194e-03, -1.320342e-03, -1.299319e-03, -1.277119e-03, -1.253737e-03, -1.229169e-03, -1.203410e-03, -1.176457e-03, 
	-1.148307e-03, -1.118959e-03, -1.088409e-03, -1.056656e-03, -1.023701e-03, -9.895419e-04, -9.541801e-04, -9.176164e-04, -8.798523e-04, -8.408897e-04, 
	-8.007315e-04, -7.593808e-04, -7.168414e-04, -6.731178e-04, -6.282148e-04, -5.821382e-04, -5.348939e-04, -4.864888e-04, -4.369301e-04, -3.862257e-04,
	-3.343841e-04, -2.814144e-04, -2.273260e-04, -1.721294e-04, -1.158351e-04, -5.845472e-05, 2.897299e-19, 5.951651e-05, 1.200817e-04, 1.816821e-04, 
	2.443034e-04, 3.079309e-04, 3.725492e-04, 4.381427e-04, 5.046949e-04, 5.721890e-04, 6.406074e-04, 7.099322e-04, 7.801450e-04, 8.512268e-04, 
	9.231580e-04, 9.959188e-04, 1.069489e-03, 1.143846e-03, 1.218971e-03, 1.294840e-03, 1.371432e-03, 1.448723e-03, 1.526691e-03, 1.605311e-03, 
	1.684560e-03, 1.764413e-03, 1.844845e-03, 1.925831e-03, 2.007345e-03, 2.089362e-03, 2.171854e-03, 2.254795e-03, 2.338158e-03, 2.421916e-03, 
	2.506041e-03, 2.590504e-03, 2.675278e-03, 2.760333e-03, 2.845642e-03, 2.931175e-03, 3.016902e-03, 3.102794e-03, 3.188822e-03, 3.274955e-03, 
	3.361163e-03, 3.447416e-03, 3.533684e-03, 3.619935e-03, 3.706139e-03, 3.792265e-03, 3.878283e-03, 3.964160e-03, 4.049867e-03, 4.135371e-03, 
	4.220642e-03, 4.305649e-03, 4.390359e-03, 4.474743e-03, 4.558768e-03, 4.642404e-03, 4.725619e-03, 4.808382e-03, 4.890662e-03, 4.972428e-03, 
	5.053650e-03, 5.134297e-03, 5.214337e-03, 5.293742e-03, 5.372480e-03, 5.450521e-03, 5.527835e-03, 5.604394e-03, 5.680167e-03, 5.755125e-03, 
	5.829239e-03, 5.902481e-03, 5.974822e-03, 6.046233e-03, 6.116688e-03, 6.186159e-03, 6.254618e-03, 6.322039e-03, 6.388395e-03, 6.453660e-03, 
	6.517808e-03, 6.580815e-03, 6.642655e-03, 6.703304e-03, 6.762737e-03, 6.820932e-03, 6.877865e-03, 6.933513e-03, 6.987855e-03, 7.040868e-03, 
	7.092532e-03, 7.142826e-03, 7.191729e-03, 7.239222e-03, 7.285287e-03, 7.329904e-03, 7.373056e-03, 7.414725e-03, 7.454895e-03, 7.493549e-03, 
	7.530672e-03, 7.566249e-03, 7.600265e-03, 7.632708e-03, 7.663562e-03, 7.692817e-03, 7.720461e-03, 7.746481e-03, 7.770868e-03, 7.793612e-03, 
	7.814704e-03, 7.834134e-03, 7.851895e-03, 7.867981e-03, 7.882384e-03, 7.895098e-03, 7.906119e-03, 7.915441e-03, 7.923062e-03, 7.928978e-03, 
	7.933186e-03, 7.935686e-03, 7.936475e-03, 7.935554e-03, 7.932923e-03, 7.928583e-03, 7.922537e-03, 7.914785e-03, 7.905332e-03, 7.894182e-03,
	7.881338e-03, 7.866807e-03, 7.850594e-03, 7.832705e-03, 7.813149e-03, 7.791932e-03, 7.769064e-03, 7.744554e-03, 7.718412e-03, 7.690649e-03, 
	7.661275e-03, 7.630302e-03, 7.597744e-03, 7.563614e-03, 7.527924e-03, 7.490690e-03, 7.451927e-03, 7.411650e-03, 7.369875e-03, 7.326620e-03, 
	7.281902e-03, 7.235738e-03, 7.188148e-03, 7.139150e-03, 7.088764e-03, 7.037010e-03, 6.983910e-03, 6.929483e-03, 6.873753e-03, 6.816740e-03,
	6.758468e-03, 6.698960e-03, 6.638240e-03, 6.576331e-03, 6.513258e-03, 6.449047e-03, 6.383722e-03, 6.317308e-03, 6.249833e-03, 6.181323e-03, 
	6.111804e-03, 6.041304e-03, 5.969851e-03, 5.897471e-03, 5.824194e-03, 5.750047e-03, 5.675059e-03, 5.599260e-03, 5.522679e-03, 5.445345e-03, 
	5.367287e-03, 5.288536e-03, 5.209122e-03, 5.129075e-03, 5.048425e-03, 4.967203e-03, 4.885440e-03, 4.803167e-03, 4.720413e-03, 4.637211e-03, 
	4.553592e-03, 4.469587e-03, 4.385226e-03, 4.300541e-03, 4.215564e-03, 4.130325e-03, 4.044856e-03, 3.959188e-03, 3.873352e-03, 3.787379e-03, 
	3.701301e-03, 3.615147e-03, 3.528950e-03, 3.442739e-03, 3.356545e-03, 3.270400e-03, 3.184332e-03, 3.098372e-03, 3.012550e-03, 2.926896e-03, 
	2.841439e-03, 2.756209e-03, 2.671235e-03, 2.586544e-03, 2.502167e-03, 2.418130e-03, 2.334463e-03, 2.251193e-03, 2.168346e-03, 2.085951e-03, 
	2.004034e-03, 1.922620e-03, 1.841737e-03, 1.761410e-03, 1.681663e-03, 1.602523e-03, 1.524012e-03, 1.446156e-03, 1.368978e-03, 1.292501e-03, 
	1.216747e-03, 1.141740e-03, 1.067500e-03, 9.940494e-04, 9.214089e-04, 8.495989e-04, 7.786393e-04, 7.085495e-04, 6.393483e-04, 5.710542e-04, 
	5.036851e-04, 4.372583e-04, 3.717906e-04, 3.072983e-04, 2.437972e-04, 1.813024e-04, 1.198286e-04, 5.938999e-05, 2.891088e-19, -5.832836e-05, 
	-1.155827e-04, -1.717511e-04, -2.268224e-04, -2.807858e-04, -3.336312e-04, -3.853491e-04, -4.359305e-04, -4.853669e-04, -5.336507e-04, -5.807746e-04,
	-6.267319e-04, -6.715165e-04, -7.151230e-04, -7.575466e-04, -7.987827e-04, -8.388278e-04, -8.776786e-04, -9.153326e-04, -9.517877e-04, -9.870425e-04,
	-1.021096e-03, -1.053948e-03, -1.085599e-03, -1.116049e-03, -1.145301e-03, -1.173355e-03, -1.200214e-03, -1.225881e-03, -1.250360e-03, -1.273655e-03, 
	-1.295771e-03, -1.316712e-03, -1.336483e-03, -1.355092e-03, -1.372545e-03, -1.388849e-03, -1.404011e-03, -1.418040e-03, -1.430944e-03, -1.442732e-03, 
	-1.453413e-03, -1.462998e-03, -1.471497e-03, -1.478920e-03, -1.485280e-03, -1.490586e-03, -1.494852e-03, -1.498090e-03, -1.500312e-03, -1.501533e-03,
	-1.501764e-03, -1.501021e-03, -1.499318e-03, -1.496668e-03, -1.493088e-03, -1.488591e-03, -1.483195e-03, -1.476914e-03, -1.469764e-03, -1.461763e-03,
	-1.452927e-03, -1.443272e-03, -1.432816e-03, -1.421577e-03, -1.409571e-03, -1.396817e-03, -1.383332e-03, -1.369135e-03, -1.354245e-03, -1.338679e-03, 
	-1.322456e-03, -1.305596e-03, -1.288117e-03, -1.270038e-03, -1.251379e-03, -1.232159e-03, -1.212396e-03, -1.192112e-03, -1.171324e-03, -1.150053e-03, 
	-1.128318e-03, -1.106140e-03, -1.083536e-03, -1.060528e-03, -1.037135e-03, -1.013376e-03, -9.892716e-04, -9.648406e-04, -9.401029e-04, -9.150779e-04, 
	-8.897850e-04, -8.642436e-04, -8.384729e-04, -8.124921e-04, -7.863202e-04, -7.599761e-04, -7.334788e-04, -7.068468e-04, -6.800987e-04, -6.532528e-04, 
	-6.263275e-04, -5.993406e-04, -5.723102e-04, -5.452539e-04, -5.181891e-04, -4.911332e-04, -4.641032e-04, -4.371160e-04, -4.101882e-04, -3.833362e-04,
	-3.565761e-04, -3.299238e-04, -3.033950e-04, -2.770051e-04, -2.507692e-04, -2.247020e-04, -1.988183e-04, -1.731322e-04, -1.476577e-04, -1.224085e-04,
	-9.739806e-05, -7.263936e-05, -4.814521e-05, -2.392804e-05, -2.335956e-19, 2.362712e-05, 4.694183e-05, 6.993299e-05, 9.258978e-05, 1.149017e-04,
	1.368587e-04, 1.584509e-04, 1.796689e-04, 2.005035e-04, 2.209461e-04, 2.409883e-04, 2.606219e-04, 2.798393e-04, 2.986331e-04, 3.169964e-04, 3.349225e-04, 
	3.524052e-04, 3.694386e-04, 3.860170e-04, 4.021353e-04, 4.177887e-04, 4.329726e-04, 4.476829e-04, 4.619158e-04, 4.756679e-04, 4.889361e-04, 5.017177e-04,
	5.140102e-04, 5.258116e-04, 5.371202e-04, 5.479347e-04, 5.582540e-04, 5.680774e-04, 5.774045e-04, 5.862354e-04, 5.945702e-04, 6.024096e-04, 6.097545e-04,
	6.166061e-04, 6.229659e-04, 6.288359e-04, 6.342181e-04, 6.391149e-04, 6.435291e-04, 6.474638e-04, 6.509221e-04, 6.539076e-04, 6.564243e-04, 6.584761e-04, 
	6.600674e-04, 6.612028e-04, 6.618872e-04, 6.621257e-04, 6.619235e-04, 6.612864e-04, 6.602200e-04, 6.587303e-04, 6.568235e-04, 6.545062e-04, 6.517848e-04, 
	6.486661e-04, 6.451573e-04, 6.412653e-04, 6.369977e-04, 6.323618e-04, 6.273653e-04, 6.220161e-04, 6.163221e-04, 6.102914e-04, 6.039322e-04, 5.972529e-04, 
	5.902619e-04, 5.829678e-04, 5.753793e-04, 5.675051e-04, 5.593542e-04, 5.509354e-04, 5.422579e-04, 5.333305e-04, 5.241627e-04, 5.147634e-04, 5.051420e-04, 
	4.953078e-04, 4.852701e-04, 4.750382e-04, 4.646216e-04, 4.540296e-04, 4.432716e-04, 4.323570e-04, 4.212952e-04, 4.100956e-04, 3.987676e-04, 3.873204e-04, 
	3.757634e-04, 3.641060e-04, 3.523572e-04, 3.405263e-04, 3.286224e-04, 3.166546e-04, 3.046319e-04, 2.925632e-04, 2.804574e-04, 2.683233e-04, 2.561694e-04,
	2.440046e-04, 2.318372e-04, 2.196756e-04, 2.075281e-04, 1.954030e-04, 1.833083e-04, 1.712519e-04, 1.592416e-04, 1.472853e-04, 1.353903e-04, 1.235642e-04, 
	1.118142e-04, 1.001476e-04, 8.857118e-05, 7.709194e-05, 6.571654e-05, 5.445153e-05, 4.330328e-05, 3.227803e-05, 2.138183e-05, 1.062058e-05, 1.554313e-19, 
	-1.047436e-05, -2.079711e-05, -3.096305e-05, -4.096714e-05, -5.080454e-05, -6.047058e-05, -6.996075e-05, -7.927075e-05, -8.839645e-05, -9.733391e-05, 
	-1.060794e-04, -1.146293e-04, -1.229802e-04, -1.311289e-04, -1.390725e-04, -1.468080e-04, -1.543329e-04, -1.616446e-04, -1.687410e-04, -1.756198e-04, 
	-1.822793e-04, -1.887177e-04, -1.949334e-04, -2.009250e-04, -2.066915e-04, -2.122318e-04, -2.175451e-04, -2.226307e-04, -2.274882e-04, -2.321173e-04, 
	-2.365178e-04, -2.406898e-04, -2.446335e-04, -2.483493e-04, -2.518378e-04, -2.550995e-04, -2.581354e-04, -2.609465e-04, -2.635340e-04, -2.658992e-04, 
	-2.680435e-04, -2.699685e-04, -2.716761e-04, -2.731680e-04, -2.744464e-04, -2.755133e-04, -2.763711e-04, -2.770222e-04, -2.774691e-04, -2.777145e-04,
	-2.777612e-04, -2.776119e-04, -2.772699e-04, -2.767380e-04, -2.760196e-04, -2.751179e-04, -2.740363e-04, -2.727784e-04, -2.713476e-04, -2.697477e-04, 
	-2.679824e-04, -2.660555e-04, -2.639708e-04, -2.617323e-04, -2.593441e-04, -2.568102e-04, -2.541347e-04, -2.513219e-04, -2.483759e-04, -2.453010e-04, 
	-2.421016e-04, -2.387819e-04, -2.353465e-04, -2.317996e-04, -2.281458e-04, -2.243895e-04, -2.205352e-04, -2.165873e-04, -2.125505e-04, -2.084291e-04, 
	-2.042277e-04, -1.999508e-04, -1.956030e-04, -1.911887e-04, -1.867124e-04, -1.821786e-04, -1.775917e-04, -1.729562e-04, -1.682766e-04, -1.635571e-04, 
	-1.588021e-04, -1.540160e-04, -1.492031e-04, -1.443675e-04, -1.395135e-04, -1.346452e-04, -1.297667e-04, -1.248822e-04, -1.199955e-04, -1.151106e-04, 
	-1.102314e-04, -1.053618e-04, -1.005054e-04, -9.566606e-05, -9.084727e-05, -8.605263e-05, -8.128561e-05, -7.654962e-05, -7.184799e-05, -6.718397e-05,
	-6.256073e-05, -5.798135e-05, -5.344885e-05, -4.896613e-05, -4.453605e-05, -4.016134e-05, -3.584467e-05, -3.158860e-05, -2.739561e-05, -2.326810e-05,
	-1.920836e-05, -1.521859e-05, -1.130090e-05, -7.457313e-06, -3.689736e-06, -7.171532e-20, 3.610166e-06, 7.139130e-06, 1.058535e-05, 1.394740e-05, 1.722391e-05,
	2.041366e-05, 2.351547e-05, 2.652830e-05, 2.945119e-05, 3.228326e-05, 3.502375e-05, 3.767197e-05, 4.022735e-05, 4.268939e-05, 4.505769e-05, 4.733194e-05,
	4.951192e-05, 5.159750e-05, 5.358865e-05, 5.548541e-05, 5.728791e-05, 5.899637e-05, 6.061108e-05, 6.213244e-05, 6.356090e-05, 6.489701e-05, 6.614139e-05, 
	6.729473e-05, 6.835781e-05, 6.933147e-05, 7.021663e-05, 7.101427e-05, 7.172545e-05, 7.235129e-05, 7.289297e-05, 7.335173e-05, 7.372888e-05, 7.402579e-05, 
	7.424388e-05, 7.438463e-05, 7.444955e-05, 7.444023e-05, 7.435829e-05, 7.420541e-05, 7.398330e-05, 7.369371e-05, 7.333845e-05, 7.291935e-05, 7.243828e-05, 
	7.189713e-05, 7.129784e-05, 7.064238e-05, 6.993273e-05, 6.917089e-05, 6.835892e-05, 6.749884e-05, 6.659275e-05, 6.564271e-05, 6.465084e-05, 6.361923e-05, 
	6.255001e-05, 6.144530e-05, 6.030723e-05, 5.913793e-05, 5.793952e-05, 5.671415e-05, 5.546393e-05, 5.419098e-05, 5.289740e-05, 5.158531e-05, 5.025679e-05, 
	4.891391e-05, 4.755874e-05, 4.619330e-05, 4.481962e-05, 4.343971e-05, 4.205553e-05, 4.066904e-05, 3.928216e-05, 3.789679e-05, 3.651479e-05, 3.513801e-05, 
	3.376824e-05, 3.240725e-05, 3.105677e-05, 2.971849e-05, 2.839409e-05, 2.708516e-05, 2.579329e-05, 2.452002e-05, 2.326682e-05, 2.203516e-05, 2.082642e-05, 
	1.964197e-05, 1.848310e-05, 1.735109e-05, 1.624714e-05, 1.517241e-05, 1.412802e-05, 1.311501e-05, 1.213440e-05, 1.118715e-05, 1.027415e-05, 9.396256e-06,
	8.554267e-06, 7.748922e-06, 6.980911e-06, 6.250867e-06, 5.559369e-06, 4.906943e-06, 4.294058e-06, 3.721132e-06, 3.188524e-06, 2.696543e-06, 2.245439e-06,
	1.835413e-06, 1.466607e-06, 1.139114e-06, 8.529708e-07, 6.081630e-07, 4.046232e-07, 2.422325e-07, 1.208207e-07, 4.016681e-08, 4.918071e-22, -4.902970e-22};


MainWindow::MainWindow(QWidget *parent, const std::string &config_file) :
QMainWindow(parent),
ui(new Ui::MainWindow)
{
	ui->setupUi(this);

	// parse startup config file
	load_config(config_file);

	// make GUI connections
	QObject::connect(ui->actionQuit, SIGNAL(triggered()), this, SLOT(close()));
	QObject::connect(ui->connectButton, SIGNAL(clicked()), this, SLOT(connect_amp()));
	QObject::connect(ui->actionLoad_Configuration, SIGNAL(triggered()), this, SLOT(load_config_dialog()));
	QObject::connect(ui->action_Save_Configuration, SIGNAL(triggered()), this, SLOT(save_config_dialog()));
	QObject::connect(ui->browseLocation, SIGNAL(clicked()), this, SLOT(load_chanlocs_dialog()));
}

void MainWindow::load_config_dialog() {
	QString sel = QFileDialog::getOpenFileName(this,"Load Configuration File","","Configuration Files (*.cfg)");
	if (!sel.isEmpty())
		load_config(sel.toStdString());
}

void MainWindow::save_config_dialog() {
	QString sel = QFileDialog::getSaveFileName(this,"Save Configuration File","","Configuration Files (*.cfg)");
	if (!sel.isEmpty())
		save_config(sel.toStdString());
}

void MainWindow::load_chanlocs_dialog() {
	QString sel = QFileDialog::getOpenFileName(this,"Load Channel Locations",ui->capLocation->text(),"Channel location files (*.sfp)");
	if (!sel.isEmpty())
		ui->capLocation->setText(sel);
}


void MainWindow::closeEvent(QCloseEvent *ev) {
	if (reader_thread_)
		ev->ignore();
}

void MainWindow::load_config(const std::string &filename) {
	try {
		using boost::property_tree::ptree;
		ptree pt;
		read_ini(filename, pt);

		// get the circumference...
		std::string circumference = pt.get<std::string>("cap.circumference","54");
		try {
			ui->capCircumference->setValue(boost::lexical_cast<int>(circumference));
		} catch(std::exception &) {
			QMessageBox::information(this,"Error in Config File","The cap circumference parameter must be a number.",QMessageBox::Ok);
		}

		// initialize the list of cap designs
		std::string knownschemes = pt.get<std::string>("cap.knownschemes","[Rita-MoBI-2010-7, BioSemi-ABC]");
		std::vector<std::string> schemes;
		boost::algorithm::split(schemes,knownschemes.substr(1,knownschemes.size()-2),boost::algorithm::is_any_of(","),boost::algorithm::token_compress_on);
		ui->capDesign->clear();
		for (int k=0;k<schemes.size();k++) {
			boost::algorithm::trim_if(schemes[k],boost::algorithm::is_any_of(" '\""));
			ui->capDesign->addItem(schemes[k].c_str());
		}

		// activate the default scheme
		std::string defaultscheme = pt.get<std::string>("cap.defaultscheme","BioSemi-ABC");
		int idx = std::find(schemes.begin(),schemes.end(),defaultscheme) - schemes.begin();
		if (idx)
			ui->capDesign->setCurrentIndex(idx);

		// assign the location file
		std::string loc_file = pt.get<std::string>("locations.filename","");
		ui->capLocation->setText(loc_file.c_str());

		// assign default ref channels
		std::string ref_chns = pt.get<std::string>("reference.channels","[EX1, EX2]");
		ui->referenceChannels->setText(ref_chns.substr(1,ref_chns.size()-2).c_str());

		// assign channel subset
		ui->channelSubset->setCurrentIndex(pt.get<int>("recording.chansubset",0));

		// assign resample flag
		ui->resamplingOn->setCheckState(pt.get<bool>("recording.resample",true) ? Qt::Checked : Qt::Unchecked);

	} catch(std::exception &e) {
		std::cout << "Problem parsing config file: " << e.what() << std::endl;
	}
}

void MainWindow::save_config(const std::string &filename) {
	using boost::property_tree::ptree;
	ptree pt;
	try {
		pt.put("cap.circumference",ui->capCircumference->text().toStdString());
		std::ostringstream schemes;
		schemes << "[";
		for (int k=0;k<ui->capDesign->count();k++)
			schemes << ui->capDesign->itemText(k).toStdString() << ", ";
		std::string tmp(schemes.str());
		pt.put("cap.knownschemes",tmp.substr(0,tmp.size()-2)+= "]");
		pt.put("cap.defaultscheme",ui->capDesign->itemText(ui->capDesign->currentIndex()).toStdString());
		pt.put("locations.filename", ui->capLocation->text().toStdString());
		pt.put("reference.channels", (std::string("[") += ui->referenceChannels->text().toStdString()) += "]");
		pt.put("recording.chansubset", ui->channelSubset->currentIndex());
		pt.put("recording.resample", ui->resamplingOn->checkState() == Qt::Checked);
		write_ini(filename, pt);
	} catch(std::exception &e) {
		std::cout << "Problem saving to config file: " << e.what() << std::endl;
	}
}

// start the amplifier connection
void MainWindow::connect_amp() {	
	if (reader_thread_) {
		// we are linked: shut down the reader thread, unlink
		try {
			reader_thread_->interrupt();
			reader_thread_->join();
			reader_thread_.reset();
		} catch(std::exception &e) {
			QMessageBox::critical(this,"Error",(std::string("Could not stop the background processing: ")+=e.what()).c_str(),QMessageBox::Ok);
			return;
		}

		try {
			if (biosemi_)
				biosemi_.reset();
		} catch(std::exception &e) {
			QMessageBox::critical(this,"Error",(std::string("Could not unlink to the amplifier: ")+=e.what()).c_str(),QMessageBox::Ok);
		}

		// indicate that we are now successfully unlinked
		ui->connectButton->setText("Link");
	} else {
		// we are not linked: try to link now

		// shut down current BioSemi connection, if any
		if (biosemi_)
			biosemi_.reset();

		// try to parse the locations file, if any...
		std::map<std::string,std::vector<std::string> > locmap;
		try {
			std::string filename = ui->capLocation->text().toStdString();
			if (!filename.empty()) {
				std::ifstream f(filename.c_str());
				if (f.fail()) {
					QMessageBox::critical(this,"Error","The given channel locations file could not be opened.",QMessageBox::Ok);
					return;
				}

				char buffer[1024];
				while (!f.eof()) {
					f.getline(buffer,sizeof(buffer));
					// ignore comment lines
					if (buffer[0] == ';' || buffer[0] == '/' || buffer[0] == '#' || buffer[0] == '%')
						continue;
					// parse contents & store in location map
					std::vector<std::string> parts; boost::algorithm::split(parts,buffer,boost::algorithm::is_space(),boost::algorithm::token_compress_on);
					if (parts.size() == 4)
						locmap[parts[0]] = std::vector<std::string>(parts.begin()+1,parts.end());
				}
			}
		}
		catch(std::exception &) {
			if (QMessageBox::question(this,"Error","Could not parse the channel locations file. Do you want to fix this problem first?",QMessageBox::Yes,QMessageBox::No) == QMessageBox::Yes)
				return;
		}

		// create a new BioSemi connection
		try {
			biosemi_.reset(new biosemi_io());
		} catch (std::exception &e) {
			QMessageBox::critical(this,"Error",(std::string("Could not link to the amplifier: ")+=e.what()).c_str(),QMessageBox::Ok);
			return;
		}

		// determine the channel index set & reduced labels / types
		index_set_.clear();
		channels_.clear();
		types_.clear();
		std::vector<std::string> channels = biosemi_->channel_labels();
		std::vector<std::string> types = biosemi_->channel_types();
		std::string subset = ui->channelSubset->itemText(ui->channelSubset->currentIndex()).toStdString();
		for (int k=0;k<channels.size();k++) {
			bool skip = types[k]=="Sync"
				|| ((subset == "160" || subset == "160, no AUX") && types[k]=="EEG" && channels[k][0]>'E') 
				|| ((subset == "128" || subset == "128, no AUX") && types[k]=="EEG" && channels[k][0]>'D') 
				|| ((subset == "64" || subset == "64, no AUX") && types[k]=="EEG" && channels[k][0]>'B') 
				|| ((subset == "32" || subset == "32, no AUX") && types[k]=="EEG" && channels[k][0]>'A')
				|| ((subset == "all, no AUX" || subset == "160, no AUX" || subset == "128, no AUX" || subset == "64, no AUX" || subset == "32, no AUX") && types[k]=="AUX");
			if (!skip) {
				index_set_.push_back(k);
				channels_.push_back(channels[k]);
				types_.push_back(types[k]);
			}
		}

		// and create new reader thread
		reader_thread_.reset(new boost::thread(&MainWindow::read_thread,this,locmap,ui->capDesign->currentText().toStdString(),ui->capLocation->text().toStdString(),ui->capCircumference->text().toStdString(),ui->referenceChannels->text().toStdString(),ui->resamplingOn->checkState()==Qt::Checked));

		// done
		ui->connectButton->setText("Unlink");
	}
}


// background data reader thread
void MainWindow::read_thread(std::map<std::string,std::vector<std::string> > locmap, std::string capdesign, std::string caplocation, std::string capcircumference, std::string capreference, bool resample) {
	// we correct for the "effective" lag of the signal as introduced by the resampling, if enabled
	// note that this correction can produce up to 10ms of "pre-ringing" effects in the 
	// EEG that appears to precede its cause when aligning lag-compensated data; this is a tradeoff
	// commonly made in neuroscience analysis, e.g. when doing forward-backward filtering
	double sigproc_lag = resample ? 0.01 : 0;
	// the compensated is determined by the buffer lag plus sigproc lag
	double compensated_lag = buffer_lag + sigproc_lag;
	
	// make a new stream info and append meta-data (we uniquely identify the device by the host name since one cannot use two Amps on the same machine)
	lsl::stream_info info("BioSemi","EEG",channels_.size(),resample ? default_target_srate : biosemi_->srate(),lsl::cf_float32,boost::asio::ip::host_name());
	// <cap> meta-data
	info.desc().append_child("cap")
		.append_child_value("size",capcircumference.c_str())
		.append_child_value("labelscheme",capdesign.c_str());
	// <amplifier> meta-data
	info.desc().append_child("amplifier")
		.append_child("settings")
			.append_child_value("speedmode",boost::lexical_cast<std::string>(biosemi_->speed_mode()).c_str());
	// <location_measurement> meta-data
	info.desc().append_child("location_measurement")
		.append_child_value("locationfile",caplocation.c_str())
		.append_child_value("model",location_system_.c_str())
		.append_child_value("manufacturer",location_manufacturer_.c_str());
	// <channels> meta-data
	lsl::xml_element chaninfo = info.desc().append_child("channels");
	for (int k=0;k<channels_.size();k++) {
		lsl::xml_element chn = chaninfo.append_child("channel");
		chn.append_child_value("label",channels_[k].c_str());
		chn.append_child_value("type",types_[k].c_str());
		chn.append_child_value("unit","microvolts");
		lsl::xml_element hw = chn.append_child("hardware");
		hw.append_child_value("manufacturer","BioSemi");
		if (types_[k] == "EEG") {
			hw.append_child_value("coupling","Gel");
			hw.append_child_value("material","Ag-AgCl");
			hw.append_child_value("surface","Pin");
		}
		if (locmap.count(channels_[k])) {
			chn.append_child("location")
				.append_child_value("X",locmap[channels_[k]][0].c_str())
				.append_child_value("Y",locmap[channels_[k]][1].c_str())
				.append_child_value("Z",locmap[channels_[k]][2].c_str());
		}
	}
	// <fiducials> meta-data
	lsl::xml_element fiducials = info.desc().append_child("fiducials");
	for (std::map<std::string,std::vector<std::string> >::iterator i=locmap.begin(),e=locmap.end();i!=e;i++) {
		if (std::find(channels_.begin(),channels_.end(),i->first) == channels_.end()) {
			lsl::xml_element fid = fiducials.append_child("fiducial");
			fid.append_child_value("label",i->first.c_str());
			fid.append_child("location")
				.append_child_value("X",i->second[0].c_str())
				.append_child_value("Y",i->second[1].c_str())
				.append_child_value("Z",i->second[2].c_str());
		}
	}
	// <reference> meta-data
	lsl::xml_element reference = info.desc().append_child("reference");
	reference.append_child_value("subtracted","No");
	std::vector<std::string> refchns; boost::algorithm::split(refchns,capreference,boost::algorithm::is_any_of(", "),boost::algorithm::token_compress_on);
	for (int k=0;k<refchns.size();k++)
		reference.append_child_value("label",refchns[k].c_str());

	// <acqusition> meta-data
	info.desc().append_child("acquisition")
		.append_child_value("manufacturer","BioSemi")
		.append_child_value("model",biosemi_->is_mk2() ? "ActiveTwo Mk2" : "ActiveTwo Mk1")
		.append_child_value("precision","24")
		.append_child_value("compensated_lag",boost::lexical_cast<std::string>(compensated_lag).c_str())
		.append_child_value("causal_correction",boost::lexical_cast<std::string>(sigproc_lag).c_str());

	// <synchronization> meta-data
	info.desc().append_child("synchronization")
		.append_child_value("offset_mean", "0.00772")
		.append_child_value("offset_rms", "0.000070")
		.append_child_value("offset_median", "0.00772")
		.append_child_value("offset_5_centile", "0.00764")
		.append_child_value("offset_95_centile", "0.00783");

	// make a new outlet
	lsl::stream_outlet outlet(info);

	// allocate temp data & resamplers...
	biosemi_io::chunk_t raw_chunk;
	std::vector<std::vector<double> > scaled_chunk_tr;
	std::vector<std::vector<double> > resampled_chunk_tr;
	std::vector<std::vector<float> > resampled_chunk;
	std::vector<Resampler<double,double,double>*> resamplers;

	int ratechange = biosemi_->srate() / default_target_srate;
	if (resample) {
		for (unsigned c=0;c<channels_.size();c++) {
			switch (ratechange) {
				case 2:
					resamplers.push_back(new Resampler<double,double,double>(1,2,coeffs_2x_lp,sizeof(coeffs_2x_lp)/sizeof(coeffs_2x_lp[0])));
					break;
				case 4:
					resamplers.push_back(new Resampler<double,double,double>(1,4,coeffs_4x_lp,sizeof(coeffs_4x_lp)/sizeof(coeffs_4x_lp[0])));
					break;
				case 8:
					resamplers.push_back(new Resampler<double,double,double>(1,8,coeffs_8x_lp,sizeof(coeffs_8x_lp)/sizeof(coeffs_8x_lp[0])));
					break;
				case 16:
					resamplers.push_back(new Resampler<double,double,double>(1,16,coeffs_16x_lp,sizeof(coeffs_16x_lp)/sizeof(coeffs_16x_lp[0])));
					break;
				case 32:
					resamplers.push_back(new Resampler<double,double,double>(1,32,coeffs_32x_lp,sizeof(coeffs_32x_lp)/sizeof(coeffs_32x_lp[0])));
					break;
				case 64:
					resamplers.push_back(new Resampler<double,double,double>(1,64,coeffs_64x_lp,sizeof(coeffs_64x_lp)/sizeof(coeffs_64x_lp[0])));
					break;
				case 128:
					resamplers.push_back(new Resampler<double,double,double>(1,128,coeffs_128x_lp,sizeof(coeffs_128x_lp)/sizeof(coeffs_128x_lp[0])));
					break;
			}
		}
	}

	// send data...
	while (true) {

		// get a chunk from the device --> raw_chunk is [#insamples x #channels]
		biosemi_->get_chunk(raw_chunk);
		int outchannels = channels_.size();
		int insamples = raw_chunk.size();
		int outsamples = resample ? resamplers[0]->neededOutCount(insamples) : insamples;

		if (insamples > 0) {
			// convert to microvolts --> scaled_chunk_tr is [#channels x #insamples]
			scaled_chunk_tr.resize(outchannels);
			for (int c=0,e=outchannels;c<e;c++) {
				scaled_chunk_tr[c].resize(insamples);
				if (types_[c] == "Trigger") {
					// don't scale the trigger channel
					for (int s=0,e=insamples;s<e;s++)
						scaled_chunk_tr[c][s] = raw_chunk[s][index_set_[c]]/256;
				} else {
					// scale all the rest (note that there is a version of the analog input boxes for which the voltage is actually 4x this value)
					for (int s=0,e=insamples;s<e;s++)
						scaled_chunk_tr[c][s] = raw_chunk[s][index_set_[c]]/256 * 0.03125;  // 31.25 nV per bit
				}
			}

			// optionally resample --> resampled_chunk_tr is [#channels x #outsamples]
			if (resamplers.empty())
				resampled_chunk_tr = scaled_chunk_tr;
			else {
				resampled_chunk_tr.resize(outchannels);
				for (int c=0,e=outchannels;c<e;c++) {
					resampled_chunk_tr[c].resize(outsamples);
					resamplers[c]->apply(&scaled_chunk_tr[c][0],insamples, &resampled_chunk_tr[c][0],outsamples);
				}
			}

			// flip back --> resampled_chunk is [#outsamples x #channels]
			resampled_chunk.resize(outsamples);
			for (int s=0,e=outsamples;s<e;s++) {
				resampled_chunk[s].resize(outchannels);
				for (int c=0,e=outchannels;c<e;c++)
					resampled_chunk[s][c] = resampled_chunk_tr[c][s];
			}

			// send it off into LSL
			outlet.push_chunk(resampled_chunk,lsl::local_clock() - compensated_lag);
		}

		// sleep until we get the next chunk
		boost::this_thread::sleep(boost::posix_time::millisec(send_interval_ms));
	}
}


MainWindow::~MainWindow() {
	delete ui;
}
